/*
 * Simple DS1820 sensor demo
 *
 * Note: Don't forget to connect a 4.7k Ohm resistor 
 *       between the DS1820's data pin and the +3.3V pin
 *
 */
 
#include "mbed.h"
#include "DS1820.h"

DigitalOut ledpin(LED1); 
DigitalIn  sensor_in(D4);

Serial serial(USBTX, USBRX);
 
int main() {
    DS1820  ds1820(PA_9);    // substitute PA_9 with actual mbed pin name connected to the DS1820 data pin    
                             
    if(ds1820.begin()) {
        ds1820.startConversion();   // start temperature conversion
        wait(1.0);                  // let DS1820 complete the temperature conversion
        while(1) {
            serial.printf("temp = %3.1f\r\n", ds1820.read());     // read temperature
            ds1820.startConversion();     // start temperature conversion
            wait(1.0);                    // let DS1820 complete the temperature conversion
        }
    } else
        serial.printf("No DS1820 sensor found!\r\n");

      
    while(1) {
        // LEDs are ON
        if(sensor_in)
        {
            ledpin = 1;
            serial.printf("LED:ON\n");     
            wait(1.2);
        }
        else
        {
        // LEDs are OFF
            ledpin = 0;
           serial.printf("LED:OFF\n");
            wait(1.4);
        }
  }
}

// You can create an array of sensors:

//int main() {
//    DS1820  ds1820[3] = {DS1820(PA_8), DS1820(PA_9), DS1820(PC_7)};
//
//    for(int i = 0; i < 3; i++) {
//        if(!ds1820[i].begin()) {
//            serial.printf("Cannot find sensor %d", i);
//        } else
//            ds1820[i].startConversion();
//    }   
//    wait(1.0);  // let DS1820s complete the temperature conversion    
//    while(1) {
//        for(int i = 0; i < 3; i++) {
//            if(ds1820[i].isPresent() {
//                serial.printf("temp%d = %3.1f\r\n", i, ds1820[i].read());     // read temperature
//                ds1820[i].startConversion();     // start temperature conversion
//            }
//        }
//        wait(1.0);  // let DS1820s complete the temperature conversion
//    }
//}               
//                
                
                
                
                