#ifndef VS1002_H
#define VS1002_H

//#define FS_ONLY
#define FIXED_VOL

#include "mbed.h"
//#include "SDFileSystem.h"
#include "string"
#include "string.h"

//SCI_MODE register bits as of p.26 of the datasheet
#define SM_DIFF         0x0001
#define SM_SETTOZERO    0x0002
#define SM_RESET        0x0004
#define SM_OUTOFWAV     0x0008
#define SM_PDOWN        0x0010
#define SM_TESTS        0x0020
#define SM_STREAM       0x0040
#define SM_PLUSV        0x0080
#define SM_DACT         0x0100
#define SM_SDIORD       0x0200
#define SM_SDISHARE     0x0400
#define SM_SDINEW       0x0800
#define SM_ADPCM        0x1000
#define SM_ADPCM_HP     0x2000


class VS1002  {

public:
//    VS1002(int _mmosi, int _mmiso, int _ssck, int _ccs, const char* _name,
// int _mosi, int _miso, int _sck, int _cs, int _rst, int _dreq, int _dcs, int _vol);
    VS1002( PinName _mosi, PinName _miso, PinName _sck, PinName _cs, PinName _rst, PinName _dreq,
    PinName _dcs, PinName _vol);

    void cs_low(void); 
    void cs_high(void);
    void dcs_low(void);
    void dcs_high(void);
    void sci_en(void);
    void sci_dis(void);
    void sdi_en(void);
    void sdi_dis(void);
    
    void sci_initialise(void);
    void sdi_initialise(void);
    void reset(void);
    void power_down(void);
 
    void sci_write(unsigned char, unsigned short int);
    void sdi_write(unsigned char);
    unsigned short int read(unsigned short int);
    void sine_test_activate(unsigned char);
    void volume(void);
    void sine_test_deactivate(void);
    void play_song(void);
    int num_of_files;
    
    DigitalIn _DREQ;
    DigitalOut _RST;
    AnalogIn _VOL;
    
protected:

    SPI _spi;
    DigitalOut _CS;
    DigitalOut _DCS;

};
#endif
