
#include "DynamixelAX12.h"
#include "mbed.h"

Serial serialBT(p28,p27);
Dynamixel din_1(1),din_2(2);
DigitalOut led_1(LED1);
DigitalOut led_2(LED2);
DigitalOut led_3(LED3);
DigitalOut led_4(LED4);
void Joystick(char incom);
bool FS=false;//FailSafe

void SerInterrupt(){
    led_1 = !led_1;
    char incom=serialBT.getc();
    if(!FS)
        Joystick(incom);
    else
        if(incom=='P'){
            FS=false;
            led_4=0;
        }//if
}//SerInterrupt

void FailSafe(){
    FS=true;
    din_1.SetVelocity(0);
    din_2.SetVelocity(0);
    led_4 = 1;
}//FailSafe

int main(void){
    serialBT.baud(9600);
    serialBT.attach(&SerInterrupt,Serial::RxIrq);
    din_1.SetMode(true);
    din_2.SetMode(true);
    FailSafe();
    while(1){}//while(1)
}//Main

void Joystick(char incom){
    if((incom=='1')||(incom=='2')){
        short val=((short)serialBT.getc())|(((short)serialBT.getc())<<8);
        if(val<0)
            val=1024-val;
        switch(incom){
            case '1':
                din_1.SetVelocity(val);
                break;
            case '2':
                din_2.SetVelocity(val);
                break;
        }//switch
    }else{
        while(serialBT.readable()){serialBT.getc();}
        FailSafe();
    }//else
    return;
}//Joystick

