//Instructions for Dynamixel
#define iPing 0x01                  //No execution, is used when the controller is ready to receive Status Packet.  -->No. of parameters = 0
#define iReadData 0x02              //Reads data from Dynamixel.                                                    -->No. of parameters = 2
#define iWriteData 0x03             //Writes data to Dynamixel.                                                     -->No. of parameters = 2 or more
#define iRegWrite 0x04              //Writes data to dynamixel, but it waits for the action comand to arrive.       -->No. of parameters = 2 or more
#define iAction 0x05                //Initiates motions registered with RegWrite.                                   -->No. of parameters = 0
#define iReset 0x06                 //Restores the state of Dynamixel to the factory default settings.              -->No. of parameters = 0
#define iSyncWrite 0x83             //Its used to control several Dynamixels simultaneously.                        -->No. of parameters = 4 or more
//Control Table Eeprom
#define cID 0x03                    //ID of Dynamixel.
#define cBaudRate 0x04              //Baud Rate of Dynamixel.
#define cReturnDelayTime 0x05       //Return Delay Time.
#define cCWAngleLimitL 0x06         //Lowest byte of clockwise Angle Limit.
#define cCWAngleLimitH 0x07         //Highest byte of clockwise Angle Limit.
#define cCCWAngleLimitL 0x08        //Lowest byte of counterclockwise Angle Limit.
#define cCCWAngleLimitH 0x09        //Highest byte of counterclockwise Angle Limit.
#define cTemperatureLimitH 0x0B     //Internal Limit Temperature.
#define cLowVoltageLimit 0x0C       //Lowest Limit Voltage.
#define cHighVoltageLimit 0x0D      //Highest Limit Voltage.
#define cMaxTorqueL 0x0E            //Lowest byte of Max. Torque.
#define cMaxTorqueH 0x0F            //Highest byte of Max. Torque.
#define cStatusReturnLevel 0x10     //Status Return Level.
#define cAlarmLED 0x11              //LED for Alarm.
#define cAlarmShutDown 0x12         //Shutdown for Alarm.
//Control Table RAM
#define cTorqueEnable 0x18          //Torque On/Off.
#define cLED 0x19                   //LED On/Off.
#define cCWCompilanceMargin 0x1A    //CW Compliance margin.
#define cCCWCompilanceMargin 0x1B   //CCW Compliance margin.
#define cCWCompilanceSlope 0x1C     //CW Compliance slope.
#define cCCWCompilanceSlope 0x1D    //CCW Compliance slope.
#define cGoalPositionL 0x1E         //Lowest byte of Goal Position.
#define cGoalPositionH 0x1F         //Highest byte of Goal Position.
#define cMovingSpeedL 0x20          //Lowest byte of Moving Speed (Moving Velocity).
#define cMovingSpeedH 0x21          //Highest byte of Moving Speed (Moving Velocity).
#define cTorqueLimitL 0x22          //Lowest byte of Torque Limit (Goal Torque).
#define cTorqueLimitH 0x23          //Highest byte of Torque Limit (Goal Torque).
#define cLock 0x2F                  //Locking EEPROM.
#define cPunchL 0x30                //Lowest byte of Punch.
#define cPunchH 0x31                //Highest byte of Punch.

#include "mbed.h"

//Class that defines one dinamixel AX-12W
class Dynamixel{
    private:
        int position;               //Absolute position of the servo. (It goes from 0 to 1023)(The mode hast to be set in False).
        int velocity;               //Angular velocity of the servo. (It goes from 0 to 2047)(The mode hast to be set in True).
        bool led;                   //Led state on board of the dynamixel.
        bool serialDirection;       //Serial Tx/Rx selection bit (True=send  False=receive).
        bool mode;                  //Servo working mode (True=Continous  False=Absolute).
        char ID;                    //Dinamixel ID (254 || 0xFE it´s a podcast to all dynamixels conected).
        Serial serialPort;          //Serial port
        DigitalOut directionPin;    //Direction Pin
    public:
        Dynamixel(void);            //ID=0xFE(Podcast); In Absolute mode on 0°; LED-->off; Tx pin-->p9; Rx pin-->p10; directionPin pin-->p11 on low
        Dynamixel(unsigned int);    //In Absolute mode on 0°; LED-->off; Tx pin-->p9; Rx pin-->p10; directionPin pin-->p11 on low
        Dynamixel(unsigned int,PinName,PinName,PinName,bool);
        void SetID(char newID){ID=newID;};
        void SetLED(bool);
        void SetMode(bool);
        void SetPosition(unsigned long);
        void SetVelocity(unsigned long);
        //To be tested...................
        void SetDirection(bool);
        void move(void);
};//Dynamixel
