#ifndef _fuzzy_h_
#define _fuzzy_h_

#include "mbed.h"

#define max(a, b)           (a>b? a:b)
#define min(a, b)           (a<b? a:b)
#define range(x, a, b)      (min(max(x, a), b))


extern const float FuzzyRuleKp[7][7];
extern const float FuzzyRuleKd[7][7];


typedef struct{
float quantied_e;
float quantied_ec;
float quantied_gainKp;
float quantied_gainKd;
float outKp;
float outKd;
}fuzzy_control_t;
void fuzzy_init(fuzzy_control_t *fuzzy ,float m_e,float m_ec,float gainKp, float gainKd);
void fuzzy_control(float e, float ec, fuzzy_control_t *fuzzy, const float fuzzyRuleKp[7][7],const float fuzzyRuleKd[7][7]);

extern fuzzy_control_t ankleFuzzy, kneeFuzzy;


#endif
