/************************************************************************************
//CSDN 副本2 E 0.3 EC 0.3 Kp 3 Kd 0.3
*************************************************************************************/
#include "fuzzy.h"

fuzzy_control_t ankleFuzzy, kneeFuzzy;


//模糊集合
/*
#define NL   -3
#define NM   -2
#define NS   -1
#define ZE   0
#define PS   1
#define PM   2
#define PL   3
*/
const float FuzzyRuleKp[7][7]={
    /*                  EC                     */
     /*  -0.3,   -0.2,     -0.1,    0.0,     0.1,     0.2,     0.3 */
/*-0.3*/2.680, 2.680,   2.000,  2.000,  1.000,  0.000,  0.000,
/*-0.2*/2.680, 2.680,   2.000,  1.087,  1.000, -0.086, -0.914,
/*-0.1*/2.000, 2.000,   2.000,  1.000,  0.000, -1.000, -1.000,
/* 0.0*/2.000, 2.000,   1.000,  0.000, -1.000, -2.000, -2.000,
/* 0.1*/1.000, 1.000,   0.000, -1.000, -1.000, -2.000, -2.000,
/* 0.2*/0.914, 0.086,  -1.087, -2.000, -2.000, -2.003, -2.680,
/* 0.3*/0.000, 0.000,  -2.000, -2.000, -2.000, -2.680, -2.680
};

const float FuzzyRuleKd[7][7]={
    /*                  EC                     */
     /*  -0.3,   -0.2,   -0.1,    0.0,    0.1,    0.2,   0.3 */
/*-0.3*/0.1000, -0.0784, -0.2680, -0.2680, -0.2680, -0.1675, 0.1000,
/*-0.2*/0.1000, -0.0784, -0.2680, -0.2003, -0.2003, -0.0870, 0.0086,
/*-0.1*/0.0000, -0.0914, -0.1999, -0.2000, -0.1000, -0.0914, 0.0000,
/* 0.0*/0.0000, -0.0914, -0.1000, -0.1000, -0.1000, -0.0914, 0.0000,
/* 0.1*/0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000, 0.0000,
/* 0.2*/0.2680, -0.0664,  0.1087,  0.1087,  0.1000,  0.1093, 0.2680,
/* 0.3*/0.2680,  0.2003,  0.2000,  0.2000,  0.1000,  0.1093, 0.2680
};


void fuzzy_init(fuzzy_control_t *fuzzy ,float m_e,float m_ec,float gainKp, float gainKd)
{
    fuzzy->quantied_e = m_e;
    fuzzy->quantied_ec = m_ec;
    fuzzy->quantied_gainKp = gainKp;
    fuzzy->quantied_gainKd = gainKd;
    fuzzy->outKp = 0.0f;
    fuzzy->outKd = 0.0f;
}
void fuzzy_control(float e,float ec,fuzzy_control_t *fuzzy,const float fuzzyRuleKp[7][7], const float fuzzyRuleKd[7][7])
{

     float etemp,ectemp;
     float eLefttemp,ecLefttemp;
     float eRighttemp ,ecRighttemp;

     int eLeftIndex,ecLeftIndex;
     int eRightIndex,ecRightIndex;
     e = e * fuzzy->quantied_e;
     ec = ec * fuzzy->quantied_ec;
     e = range(e,-0.3f,0.3f);
     ec = range(ec,-0.3f,0.3f);
     etemp = e > 0.3f ? 0.0f : (e < - 0.3f ? 0.0f : (e >= 0.0f ? (e >= 0.2f ? 0.25f: (e >= 0.1f ? 0.15f : 0.05f)) : (e >= -0.1f ? -0.05f : (e >= -0.2f ? -0.15f : (e >= -0.3f ? -0.25f : 0.0f)))));
     eLeftIndex = (int)((etemp-0.05f)*10 + 3.0f);        
     eRightIndex = (int)((etemp+0.05f)*10 + 3.0f);
     eLefttemp =etemp == 0.0f ? 0.0f:(10*((etemp+0.05f)-e));             
     eRighttemp=etemp == 0.0f ? 0.0f:( 10*(e-(etemp-0.05f)));
     
     ectemp = ec > 0.3f ? 0.0f : (ec < - 0.3f ? 0.0f : (ec >= 0.0f ? (ec >= 0.2f ? 0.25f: (ec >= 0.1f ? 0.15f : 0.05f)) : (ec >= -0.1f ? -0.05f : (ec >= -0.2f ? -0.15f : (ec >= -0.3f ? -0.25f : 0.0f)))));
     ecLeftIndex = (int)((ectemp-0.05f)*10 + 3.0f);        
     ecRightIndex = (int)((ectemp+0.05f)*10 + 3.0f);
     ecLefttemp =ectemp == 0.0f ? 0.0f:(10*((ectemp+0.05f)-ec));    
     ecRighttemp=ectemp == 0.0f ? 0.0f:( 10*(ec-(ectemp-0.05f)));


/*************************************反模糊*************************************/




    fuzzy->outKp = (eLefttemp * ecLefttemp * fuzzyRuleKp[eLeftIndex][ecLeftIndex]
                    + eLefttemp * ecRighttemp * fuzzyRuleKp[eLeftIndex][ecRightIndex]
                    + eRighttemp * ecLefttemp * fuzzyRuleKp[eRightIndex][ecLeftIndex]
                    + eRighttemp * ecRighttemp * fuzzyRuleKp[eRightIndex][ecRightIndex]);
                    
    fuzzy->outKd = (eLefttemp * ecLefttemp * fuzzyRuleKd[eLeftIndex][ecLeftIndex]
                    + eLefttemp * ecRighttemp * fuzzyRuleKd[eLeftIndex][ecRightIndex]
                    + eRighttemp * ecLefttemp * fuzzyRuleKd[eRightIndex][ecLeftIndex]
                    + eRighttemp * ecRighttemp * fuzzyRuleKd[eRightIndex][ecRightIndex]);

    //对解算出的模糊结果进行量化
    fuzzy->outKp = fuzzy->outKp * fuzzy->quantied_gainKp;
    fuzzy->outKd = fuzzy->outKd * fuzzy->quantied_gainKd;
}
