#include "data_board.h"

// 足底--》主控


Serial foot(PA_9, PA_10);              // tx, rx U1

unsigned int flag_foot_A = 0, flag_foot_B = 0;
unsigned int Sfootnum = 0;

uint16_t Sfootget[10] = {0};                                                    
uint16_t Sfootuse[10] = {0};

////////////////////////////////////////////////////////////////////////////////
//   Gait_now           当前相位          Gait_per_now  当前步态时刻      Gait_change 步态改变标志位    
//   Gait_num_valid     步数统计          time_portion_now    当前相位时间段
////////////////////////////////////////////////////////////////////////////////


unsigned int Gait_now_real_before = 0, Gait_now_real = 0, Gait_per_now_real = 0, time_portion_now_real=0.0f;
unsigned int Gait_reset_flag = 0;   //计时器复位标志

void gait_decode()
{
    Gait_now_real_before = Gait_now_real;
    Gait_now_real = Sfootuse[0];
    Gait_per_now_real = Sfootuse[1]*100 + Sfootuse[2]*10 + Sfootuse[3];
    time_portion_now_real = Sfootuse[4]*100000 + Sfootuse[5]*10000 + Sfootuse[6]*1000 + Sfootuse[7]*100 + Sfootuse[8]*10 + Sfootuse[9];
   
    if ( mode_flag == 8 ){
        if(Gait_now_real_before == 4 && Gait_now_real == 1  && tim.read() >= 2){
            Gait_reset_flag = 1;
            pc.printf("%01d---%03d---%06d\n",Gait_now_real,Gait_per_now_real,time_portion_now_real);
        }         
    }else if( mode_flag == 1 ){
        if((Gait_now_real_before == 4 && (Gait_now_real == 1 || Gait_now_real == 3)) && tim.read() >= 3){
            mode_flag = 2;
            Gait_reset_flag = 1;
            pc.printf("%01d---%03d---%06d\n",Gait_now_real,Gait_per_now_real,time_portion_now_real);
        }          
    }else if( mode_flag == 2 ){
        if((Gait_now_real_before == 4 && (Gait_now_real == 1 || Gait_now_real == 3)) && tim.read() >= 3){
            mode_flag = 1;
            Gait_reset_flag = 1;
            pc.printf("%01d---%03d---%06d\n",Gait_now_real,Gait_per_now_real,time_portion_now_real);
        }          
    }else{
        if((Gait_now_real_before == 4 && (Gait_now_real == 1 || Gait_now_real == 3)) && tim.read() >= 3){
            Gait_reset_flag = 1;
            pc.printf("%01d---%03d---%06d\n",Gait_now_real,Gait_per_now_real,time_portion_now_real);
        }          
    }
        
   
      
    
}

void gait_clear()
{
    for(int i = 0; i < 10; i++){
        Sfootuse[i] = 0;
    }
}


void serial_board_isr(void)
{
//    pc.printf("begin\n");
    while(foot.readable())
    {       
        uint16_t c = foot.getc();
        if(c == 'A')
        {
            flag_foot_A = 1;
            
            flag_foot_B = 0;
            Sfootnum = 0;
            for(unsigned int i = 0; i < 10; i++)
            {
                Sfootget[i] = 0;      
            }
            
            break;  
        }
        if(c == 'B')
        {
            flag_foot_B = 1;
        }
        
        if(flag_foot_A == 1)
        {
            if((flag_foot_B != 1) && (Sfootnum < 10))
            {
                Sfootget[Sfootnum] = c;    
            }
            
            Sfootnum++;
            
            if((flag_foot_B == 1) && (Sfootnum != 11))
            {    
                flag_foot_A = 0;
                flag_foot_B = 0;
                Sfootnum    = 0;     
            }
            
            if((flag_foot_B == 1) && (Sfootnum == 11))
            {
                flag_foot_A = 0;
                flag_foot_B = 0;
                Sfootnum    = 0;
                
                for(unsigned int i = 0; i < 10; i++)
                {
                    Sfootuse[i] = Sfootget[i] - '0';
                }
                
                gait_decode();
                gait_clear(); 
            } 
        }
    }
}