#include "control.h"


void control(float ankle_real_p, float knee_real_p)
{
    if(command_control_flag == 1)
        command_control();
            
    if(c_lock == 1)                                                             // 处于PC串口锁定模式 
    {
        cal_command.q_des_ankle  = SP_ankle;
        cal_command.qd_des_ankle = 0;
        cal_command.kp_ankle     = 20;
        cal_command.kd_ankle     = 1;
        cal_command.tau_ankle_ff = 0;
        
        cal_command.q_des_knee  = SP_knee;
        cal_command.qd_des_knee = 0;
        cal_command.kp_knee     = 20;
        cal_command.kd_knee     = 1;
        cal_command.tau_knee_ff = 0;        
    }
    
    if(c_lock == 0)
    {
        calculate_fuzzy(ankle_real_p, knee_real_p);
    }
    
    // 将计算得到的数值赋给控制器
    
    a_control.ankle.p_des = cal_command.q_des_ankle;
    a_control.ankle.v_des = cal_command.qd_des_ankle;
    a_control.ankle.kp    = cal_command.kp_ankle;
    a_control.ankle.kd    = cal_command.kd_ankle;
    a_control.ankle.t_ff  = cal_command.tau_ankle_ff;
        
    a_control.knee.p_des = cal_command.q_des_knee;
    a_control.knee.v_des = cal_command.qd_des_knee;
    a_control.knee.kp    = cal_command.kp_knee;
    a_control.knee.kd    = cal_command.kd_knee;
    a_control.knee.t_ff  = cal_command.tau_knee_ff;
    
}
  
    






      
        
        



