#ifndef _CALCULATE_H
#define _CALCULATE_H

#include "mbed.h"
#include "data_pc.h"
#include "data_board.h"
#include "fuzzy.h"
#include "timer.h"
#include "used_leg_message.h"



#define CT (50)


typedef struct{
float ankle_target_Kp;
float ankle_target_Kd;
float ankle_target_tff;

float knee_target_Kp;
float knee_target_Kd;
float knee_target_tff;
}target_pid;/*模糊PID的s设定值*/


extern unsigned int send_enable;
extern float pos_ankle;
extern float pos_knee;
extern target_pid tagertPID;




float position_knee(float res);
float position_ankle(float res);
void calculate_ankle_fuzzy(float ankle_target_p, float knee_target_p);
void calculate_fuzzy(float ankle_target_p, float knee_target_p);

void fuzzy_position_control_ankle(float ankle_real_p, float pos_ankle);
void fuzzy_position_control_knee(float knee_real_p, float pos_knee);

void torque_control_ankle();
void torque_control_knee();



void init_joint_angles();




#endif