#ifndef _CAN_H
#define _CAN_H

// 头文件
#include "mbed.h"
#include "math_ops.h"
#include "leg_message.h"
#include "used_leg_message.h"


// 宏定义
#define CAN_ID  0x01                                                            // Master CAN ID

#define P_MIN   -12.5f                                                          // Value Limits
#define P_MAX   12.5f
#define V_MIN   -45.0f
#define V_MAX   45.0f
#define KP_MIN  0.0f
#define KP_MAX  500.0f
#define KD_MIN  0.0f
#define KD_MAX  5.0f
#define T_MIN   -18.0f
#define T_MAX   18.0f                                                           // Value Limits


// 对象外部申明
extern CAN knee_can,ankle_can;                 // 设备的外部申明
extern CANMessage knee_rxMsg, ankle_rxMsg;     // 主控收到的CAN消息
extern CANMessage knee_txMsg, ankle_txMsg;     // 主控发送的CAN消息

// 函数外部申明
void pack_cmd(CANMessage * msg, joint_control joint);
void PackAll();
void WriteAll();
void unpack_reply(CANMessage msg, leg_state * state);



#endif