#include "data_board.h"




Serial foot(PA_9, PA_10);              // tx, rx U1

unsigned int flag_foot_A = 0, flag_foot_B = 0;
unsigned int Sfootnum = 0;

uint16_t Sfootget[10] = {0};                                                    
uint16_t Sfootuse[10] = {0};

////////////////////////////////////////////////////////////////////////////////
//   Gait_now           当前相位          Gait_per_now  当前步态时刻      Gait_change 步态改变标志位    
//   Gait_num_valid     步数统计          time_portion_now    当前相位时间段
////////////////////////////////////////////////////////////////////////////////

unsigned int Gait_num_valid = 0, Gait_now = 0, Gait_per_now = 0, Gait_cycle_now = 0, time_portion_now=0;
uint16_t Gait_per_now_int = 0, COP_Y_int = 0, COP_X_int = 0, Gait_cycle_now_int = 0, time_portion_now_int=0;


unsigned int Gait_num_valid_0before = 0, Gait_now_0before = 0;
float Gait_per_now_0before = 0.0f, COP_Y_0before = 0.0f, COP_X_0before = 0.0f, Gait_cycle_now_0before = 0.0f;

unsigned int Gait_num_valid_real = 0, Gait_now_real = 0, Gait_per_now_real = 0, Gait_cycle_now_real = 0.0f, time_portion_now_real=0.0f;


void gait_decode()
{
    Gait_now = Sfootuse[0];
    Gait_per_now = Sfootuse[1]*100 + Sfootuse[2]*10 + Sfootuse[3];
    time_portion_now = Sfootuse[4]*100000 + Sfootuse[5]*10000 + Sfootuse[6]*1000 + Sfootuse[7]*100 + Sfootuse[8]*10 + Sfootuse[9];
              
        
    Gait_num_valid_real = Gait_num_valid;
    Gait_now_real = Gait_now;
    Gait_per_now_real = Gait_per_now;
    Gait_cycle_now_real = Gait_cycle_now;
    time_portion_now_real=time_portion_now;
    
    command.printf("%01d---%03d---%06d\n",Gait_now_real,Gait_per_now_real,time_portion_now_real);
}

void gait_clear()
{
    for(int i = 0; i < 10; i++){
        Sfootuse[i] = 0;
    }
}


void serial_board_isr(void)
{
//    pc.printf("begin\n");
    while(foot.readable())
    {       
        uint16_t c = foot.getc();
        if(c == 'A')
        {
            flag_foot_A = 1;
            
            flag_foot_B = 0;
            Sfootnum = 0;
            for(unsigned int i = 0; i < 10; i++)
            {
                Sfootget[i] = 0;      
            }
            
            break;  
        }
        if(c == 'B')
        {
            flag_foot_B = 1;
        }
        
        if(flag_foot_A == 1)
        {
            if((flag_foot_B != 1) && (Sfootnum < 10))
            {
                Sfootget[Sfootnum] = c;    
            }
            
            Sfootnum++;
            
            if((flag_foot_B == 1) && (Sfootnum != 11))
            {    
                flag_foot_A = 0;
                flag_foot_B = 0;
                Sfootnum    = 0;     
            }
            
            if((flag_foot_B == 1) && (Sfootnum == 11))
            {
                flag_foot_A = 0;
                flag_foot_B = 0;
                Sfootnum    = 0;
                
                for(unsigned int i = 0; i < 10; i++)
                {
                    Sfootuse[i] = Sfootget[i] - '0';
                }
                
                gait_decode();
                gait_clear(); 
            } 
        }
    }
}