#ifndef _leg_message
#define _leg_message

// 头文件
#include <stdint.h>

// 定义结构体
struct joint_control{                                                           // 关节控制结构体
    float p_des, v_des, kp, kd, t_ff;                                           // 控制量为: p_des, v_des, kp, kd, t_ff
    };

struct leg_control{                                                             // 系统控制结构体
    joint_control ankle, knee;                                                  // 控制成员: knee, ankle关节
    };


struct joint_state{                                                             // 关节状态结构体
    float p, v, t;                                                              // 状态成员:  p\v\t
    };
    
struct leg_state{                                                               // 系统状态结构体
    joint_state ankle_state, knee_state;                                        // 状态成员: ankle_state, knee_state状态
    };


//struct cal_data_t
//{
//    float q_pf;
//    float q_df;
//
//    float qd_pf;
//    float qd_df;
//
//    int32_t flag_pf;
//    int32_t flag_df;
//    //int32_t checksum;
//};
//
struct cal_command_t
{
    float q_des_ankle;
    float q_des_knee;

    float qd_des_ankle;
    float qd_des_knee;

    float kp_ankle;
    float kp_knee;

    float kd_ankle;
    float kd_knee;

    float tau_ankle_ff;
    float tau_knee_ff;

    int32_t flag;                                                               // 进入电机模式标志位
    //int32_t checksum;
};


#endif