#include "data_pc.h"
#include "data_command.h"

Serial pc(PA_2, PA_3);                                                          // tx, rx U2 min


int pc_control = 0;                                                              // 命令帧标志位
unsigned int flag_A = 0, flag_B = 0;
unsigned int pc_num = 0;

uint16_t mode_flag_get[1] = {0};
uint16_t mode_flag_use[1] = {0};
unsigned int mode_flag = 3;

void pc_decode(){
    mode_flag = mode_flag_use[0];
}

void pc_clear(){
    mode_flag_use[0] = 0;
}

void serial_pc_isr(){
    while(pc.readable()){
        uint16_t c=pc.getc();
        if(c == 'A'){
            flag_A = 1;
            flag_B = 0;
            pc_num = 0;
            mode_flag_get[0] = 0;
            break; 
        }
        if(c == 'B'){
            flag_B = 1;
        }
        if(flag_A == 1){
            if((flag_B != 1) && (pc_num < 1))
            {
                mode_flag_get[pc_num] = c;    
            }
            pc_num++;
            
            if((flag_B == 1) && (pc_num != 2))
            {                        
                flag_A = 0;
                flag_B = 0; 
                pc_num   = 0;     
            }
            if((flag_B == 1) && (pc_num == 2))
            {                        
                flag_A = 0;
                flag_B = 0; 
                pc_num   = 0; 
                
                mode_flag_use[0] = mode_flag_get[0] - '0'; 
                pc_decode();
                
                command.printf("%d", mode_flag);                                                    // 命令帧接收成功   
                
                pc_clear();
                
            }
            pc_control = 1;                                                      
        } 
    }
}