#include "FCal.h"
#include "mbed.h"


float F[16];


///////////////////////////////标定间隔/////////////////////////////
unsigned int F_KG10_interval[KG10_Docs] = {
    5,  10, 15, 20, 25,  30, 35, 40, 45,  50, 
    55, 60, 65, 70, 75, 80,  85, 90, 95, 100, 105};

unsigned int F_KG20_interval[KG20_Docs] = {
    5,   10,  20,  30,  35,  40,  45,  50,  60,  65, 
    70,  80,  90,  95,  100, 105, 110, 115, 120, 125,
    130, 135, 140, 145, 150, 155, 160, 170, 180, 200, 205};
////////////////////////////////////////////////////////////////////


/////////////////////////////10KG////////////////////////////////
/****************************10KG_1*****************************/
float KG10_1[KG10_Docs] = 
{                                                                                                                                                           // interval = 5
    18240, 12970, 393  , 67.6 , 42.4, 30.58, 24.84, 22.1 , 20.06, 18.38,       
    17.01, 16.55, 16.01, 15.68, 15.3, 15.04, 14.48, 14.38, 14.28, 13.96,        
    13.85                                                                                                                                               // 105
};
/***************************************************************/
/****************************10KG_2*****************************/
float KG10_2[KG10_Docs] = 
{                                                                                                                                                           // interval = 5
    432  , 146.3, 79.5, 54.2 , 40.9 , 32.27, 27.15, 23.68, 21.36, 20.11,       
    19   , 17.98, 17.3, 16.84, 16.22, 16.16, 15.8 , 15.61, 15.41, 15.26,        
    15.13                                                                                                                                               // 105
};
/***************************************************************/
/****************************10KG_3*****************************/
float KG10_3[KG10_Docs] = 
{                                                                                                                                                            // interval = 5
    934  , 170.1 , 71.5 , 45.5 , 36.01, 29.73, 24.65, 22   , 20.04, 19.02,      
    18.12, 17.16 , 16.5 , 16.14, 15.83, 15.59, 15.35, 15.24, 15.06, 14.9,       
    14.76                                                                                                                                                // 105
};
/***************************************************************/
/****************************10KG_4*****************************/
float KG10_4[KG10_Docs] = 
{                                                                                                                                                            // interval = 5
    537  , 114.3 , 68   , 47.8 , 37.1 , 31.14, 26.07, 23.37, 20.7, 19.3 ,      
    17.89, 17.15 , 16.2 , 15.59, 14.96, 14.66, 14.28, 14.13, 13.9, 13.75,        
    13.59                                                                                                                                                // 105
};
/***************************************************************/
/****************************10KG_5*****************************/
float KG10_5[KG10_Docs] = 
{                                                                                                                                                            // interval = 5
    1191 , 164.4, 74.1 , 52.4 , 38.8 , 30.84, 26.09, 22.9 , 20.84, 19.04,        
    18.34, 17.71, 17.22, 16.91, 16.54, 16.32, 16.16, 15.96, 15.79, 15.64,       
    15.53                                                                                                                                                // 105
};
/***************************************************************/
/****************************10KG_6*****************************/
float KG10_6[KG10_Docs] = 
{                                                                                                                                                            // interval = 5
    900  , 181.6, 97.8 , 62.4 , 44.8 , 36.3 , 30.14, 25.85, 23.04, 21.34,       
    20.23, 19.28, 18.9 , 18.03, 17.92, 17.68, 17.19, 17.12, 16.88, 16.7 ,        
    16.62                                                                                                                                                // 105
};
/***************************************************************/
/****************************10KG_7*****************************/
float KG10_7[KG10_Docs] = 
{                                                                                                                                                            // interval = 5
    46700, 18010, 909  , 154.6, 95.5 , 50   , 32.15, 27.1 , 24.07, 22.56,        
    21.36, 20.54, 19.85, 19.48, 19.07, 18.9 , 18.51, 18.24, 17.94, 17.7 ,        
    17.62                                                                                                                                                // 105
};
/***************************************************************/
/****************************10KG_8*****************************/
float KG10_8[KG10_Docs] = 
{                                                                                                                                                            // interval = 5
    857  , 139.7, 64.4 , 40.4 , 28.56, 25.41, 22.48, 20.21, 18.34, 17.07,        
    16.46, 15.84, 15.5 , 15.29, 14.97, 14.87, 14.61, 14.43, 14.29, 14.16,        
    13.99                                                                                                                                                // 105
};
/***************************************************************/
/****************************10KG_9*****************************/
float KG10_9[KG10_Docs] = 
{                                                                                                                                                            // interval = 5
    18340, 897  , 227.2, 116  , 63.8 , 46.8 , 31.01, 28.36, 24.93, 22.18,        
    20.18, 18.57, 17.37, 16.86, 16.37, 15.88, 15.55, 15.1 , 14.63, 14.39,       
    14.14                                                                                                                                                // 105
};
/***************************************************************/
/****************************10KG_10****************************/
float KG10_10[KG10_Docs] = 
{                                                                                                                                                            // interval = 5
    305.8, 116.9, 72.7 , 51.8 , 37.7 , 30.77, 26.79, 22.98, 19.81, 18.63,       
    17.01, 16.24, 15.53, 14.88, 14.29, 13.75, 13.42, 13.15, 12.92, 12.61,       
    12.4                                                                                                                                                 // 105
};
/////////////////////////////////////////////////////////////////


//////////////////////////////20KG///////////////////////////////
/****************************20KG_1*****************************/
float KG20_1[KG20_Docs] = 
{
    6000 , 4880 , 1179 , 678  , 577  , 495  , 452  , 418  , 380  , 372  ,       
    351.5, 340.2, 330.1, 323.9, 320.8, 316.1, 312.3, 309.9, 306.9, 304.5,       
    300.3, 299.3, 296.6, 294.3, 291.7, 289.9, 288.1, 284.9, 282.8, 276.5,        
    273.6                                                                                                                                                // 205
};
/***************************************************************/
/****************************20KG_2*****************************/
float KG20_2[KG20_Docs] = 
{
    5000 , 3099 , 1048 , 599  , 469  , 398  , 344.8, 318.7, 287  , 276.8,        
    272.1, 263.6, 255.5, 252.8, 249.5, 246.2, 245.5, 243.1, 241.6, 239.2,        
    238.6, 237.6, 235.2, 234.2, 232.8, 231.4, 230.8, 229.3, 227.4, 222.9,       
    220.6                                                                                                                                                // 205
};
/***************************************************************/
/****************************20KG_3*****************************/
float KG20_3[KG20_Docs] = 
{
    5000 , 3281 , 1654 , 1075 , 937  , 810  , 714  , 633  , 559  , 517  ,       
    483  , 445  , 421  , 414  , 405  , 396  , 391  , 385  , 380  , 374  ,        
    370  , 366  , 363  , 361  , 356.1, 353.3, 350.3, 348.9, 345.7, 338.9,        
    335.7                                                                                                                                                // 205
};
/***************************************************************/
/****************************20KG_4*****************************/
float KG20_4[KG20_Docs] = 
{
    4000 , 2321 , 1403 , 917  , 686  , 582  , 521  , 476  , 422  , 402  ,        
    396  , 367  , 351  , 344.6, 339.3, 334.4, 330.3, 328.7, 325.9, 323.1,       
    322  , 318  , 317  , 316.7, 313.3, 311.8, 310.9, 306.8, 304  , 299.1,        
    297.1                                                                                                                                            // 205      
};
/***************************************************************/
/****************************20KG_5*****************************/
float KG20_5[KG20_Docs] = 
{
    20000, 17540, 1586 , 845  , 669  , 583  , 514  , 478  , 424  , 405  ,       
    396  , 372  , 352.3, 347.9, 344.2, 339.8, 337.6, 334.7, 333.1, 331.3,       
    328.1, 327  , 325.4, 324.8, 321.6, 321.1, 318.8, 316.4, 321.7, 309.4,       
    306.1                                                                                                                                            // 205
};
/***************************************************************/
/****************************20KG_6*****************************/
float KG20_6[KG20_Docs] = 
{
    9000 , 7090 , 1714 , 1066 , 777  , 689  , 623  , 531  , 477  , 438.1,       
    419  , 406  , 392  , 383.6, 375  , 362.8, 351.4, 348.6, 345  , 342.7,       
    339.9, 337.7, 335.7, 333.3, 331  , 328.6, 327.1, 324  , 320.6, 315.4,       
    312.6                                                                                                                                                // 205
};
/***************************************************************/
/****************************20KG_7*****************************/
float KG20_7[KG20_Docs] = 
{
    3000 , 1817 , 1232 , 759  , 678  , 617  , 550  , 503  , 444  , 415  ,       
    406  , 387  , 373  , 369.5, 368  , 358.7, 351.4, 347.6, 345.7, 342.7,       
    341.6, 338  , 336.4, 333.3, 332.2, 331.1, 330.5, 326.5, 322.5, 317.2,       
    315.1                                                                                                                                                // 205
};
/***************************************************************/
/****************************20KG_8*****************************/
float KG20_8[KG20_Docs] = 
{
    8000 , 5720 , 1511 , 776  , 685.5, 615  , 548.5, 462  , 414  , 386  ,       
    378  , 345.9, 319.4, 313.3, 309.1, 304.5, 301.8, 297.8, 295.7, 292  ,       
    290.4, 287.4, 286.3, 283.6, 282.8, 280.1, 279.4, 276.9, 275.1, 269.1,       
    264.3                                                                                                                                                // 205
};
/***************************************************************/
/****************************20KG_9*****************************/
float KG20_9[KG20_Docs] = 
{
    9000 , 6870 , 1685 , 1026 , 876.5, 747  , 676  , 556  , 483  , 456.5,       
    450  , 401  , 387  , 385.6, 385  , 378.5, 374  , 370.3, 368  , 360.7,       
    355.4, 352.1, 350.8, 347.1, 345.4, 343.9, 342.5, 339.9, 335.2, 328.5,       
    327.4                                                                                                                                                // 205
};
/***************************************************************/
/****************************20KG_10*****************************/
float KG20_10[KG20_Docs] = 
{
    7000 , 4580 , 1279 , 841  , 690.5, 560  , 488  , 436  , 368  , 334.8,       
    321.5, 301.9, 284.7, 279.6, 276.5, 271.4, 268.2, 264.8, 263.3, 261.7,       
    260.6, 257.8, 257  , 254.3, 253.5, 251.2, 250.9, 249.4, 248.6, 243.8,       
    242.1                                                                                                                                                // 205
};
/***************************************************************/


float do_FCal(float RES, float const *Rarray, unsigned int const *Farray, unsigned int const Docs)
{
        float Force;
        float RLowValue, RHighValue;
                float FLowValue, FHighValue;
        float K;
        unsigned int i;
        unsigned int cBottom, cTop;


        if (RES >= Rarray[0])  
        {
            return 5;
        }

        if (RES <= Rarray[Docs - 1])    
        {
            return Farray[Docs - 1];
        }

        cBottom = 0; 
        cTop    = Docs - 1;
                        

                //¶þ·Ö·¨ÕÒ ~~~ cBottom - Now - cTop
        for (i = (Docs/2); (cTop - cBottom) != 1; )      
        {
                if (RES < Rarray[i])
                {
                        cBottom = i;
                        i = (cTop + cBottom) / 2;
                }
                else if (RES > Rarray[i]) 
                {
                        cTop = i;
                        i = (cTop + cBottom) / 2;
                }
                else
                {
                                                Force = (float)Farray[i];

                        return Force;
                }
        }

        RLowValue  = Rarray[cTop];
        RHighValue = Rarray[cBottom];
                
                FLowValue  = Farray[cBottom];
                FHighValue = Farray[cTop];
                
                K = (float)(FHighValue - FLowValue)/(RHighValue - RLowValue); 
                                                                                   
                Force = (float)FHighValue - K*(RES - RLowValue);
                
                
        return Force;
}
















