#include "mbed.h"
#include "pz.h"
#include "ResCal.h"
#include "FCal.h"
#include "KpaCal.h"
#include "Moving_Average2.h"


int main() 
{
    pc.baud(115200);
    
    while(1)
    {
        ////////////////////////////原始读取/////////////////////////////////////
        a1 = c1.read();
        a2 = c2.read();
        //a3 = c3.read();
        //a4 = c4.read();
        a5 = c5.read();
        a6 = c6.read();
        a7 = c7.read();
        a8 = c8.read();
        a9 = c9.read();
        a10 = c10.read();
        a11 = c11.read();
        a12 = c12.read();
        a13 = c13.read();
        a14 = c14.read();
        a15 = c15.read();
        a16 = c16.read();
        
        ////////////////////////////滑动平均/////////////////////////////////////
        aver[0] = Moving_Average2(N, Filter[0], a1);
        aver[1] = Moving_Average2(N, Filter[1], a2);
        aver[2] = Moving_Average2(N, Filter[2], a3);
        aver[3] = Moving_Average2(N, Filter[3], a4);
        aver[4] = Moving_Average2(N, Filter[4], a5);
        aver[5] = Moving_Average2(N, Filter[5], a6);
        aver[6] = Moving_Average2(N, Filter[6], a7);
        aver[7] = Moving_Average2(N, Filter[7], a8);
        aver[8] = Moving_Average2(N, Filter[8], a9);
        aver[9] = Moving_Average2(N, Filter[9], a10);
        aver[10] = Moving_Average2(N, Filter[10], a11);
        aver[11] = Moving_Average2(N, Filter[11], a12);
        aver[12] = Moving_Average2(N, Filter[12], a13);
        aver[13] = Moving_Average2(N, Filter[13], a14);
        aver[14] = Moving_Average2(N, Filter[14], a15);
        aver[15] = Moving_Average2(N, Filter[15], a16);
        
        ////////////////////////////计算电阻/////////////////////////////////////
        R[0]  = do_ResCal(aver[0],  KG20_1_R1);         // 20KG - 1
        R[1]  = do_ResCal(aver[1],  KG20_2_R1);         // 20KG - 2
        R[2]  = do_ResCal(aver[2],  KG10_2_R1);                                     // 10KG - 2
        R[3]  = do_ResCal(aver[3],  KG20_3_R1);         // 20KG - 3
        R[4]  = do_ResCal(aver[4],  KG20_4_R1);         // 20KG - 4
        R[5]  = do_ResCal(aver[5],  KG20_6_R1);         // 20KG - 6
        R[6]  = do_ResCal(aver[6],  KG20_7_R1);         // 20KG - 7
        R[7]  = do_ResCal(aver[7],  KG10_3_R1);                                     // 10KG - 3
        R[8]  = do_ResCal(aver[8],  KG10_4_R1);                                     // 10KG - 4
        R[9]  = do_ResCal(aver[9],  KG10_5_R1);                                     // 10KG - 5
        R[10] = do_ResCal(aver[10], KG10_6_R1);                                     // 10KG - 6
        R[11] = do_ResCal(aver[11], KG10_8_R1);                                     // 10KG - 8
        R[12] = do_ResCal(aver[12], KG10_10_R1);                                    // 10KG - 10
        R[13] = do_ResCal(aver[13], KG20_8_R1);         // 20KG - 8
        R[14] = do_ResCal(aver[14], KG20_9_R1);         // 20KG - 9
        R[15] = do_ResCal(aver[15], KG20_10_R1);        // 20KG - 10
        
        ////////////////////////////计算压力/////////////////////////////////////
        F[0]  = do_FCal(R[0],  KG20_1,  F_KG20_interval, KG20_Docs);
        F[1]  = do_FCal(R[1],  KG20_2,  F_KG20_interval, KG20_Docs);
        F[2]  = do_FCal(R[2],  KG10_2,  F_KG10_interval, KG10_Docs);
        F[3]  = do_FCal(R[3],  KG20_3,  F_KG20_interval, KG20_Docs);
        F[4]  = do_FCal(R[4],  KG20_4,  F_KG20_interval, KG20_Docs);
        F[5]  = do_FCal(R[5],  KG20_6,  F_KG20_interval, KG20_Docs);
        F[6]  = do_FCal(R[6],  KG20_7,  F_KG20_interval, KG20_Docs);
        F[7]  = do_FCal(R[7],  KG10_3,  F_KG10_interval, KG10_Docs);
        F[8]  = do_FCal(R[8],  KG10_4,  F_KG10_interval, KG10_Docs);
        F[9]  = do_FCal(R[9],  KG10_5,  F_KG10_interval, KG10_Docs);
        F[10] = do_FCal(R[10], KG10_6,  F_KG10_interval, KG10_Docs);
        F[11] = do_FCal(R[11], KG10_8,  F_KG10_interval, KG10_Docs);
        F[12] = do_FCal(R[12], KG10_10, F_KG10_interval, KG10_Docs);
        F[13] = do_FCal(R[13], KG20_8,  F_KG20_interval, KG20_Docs);
        F[14] = do_FCal(R[14], KG20_9,  F_KG20_interval, KG20_Docs);
        F[15] = do_FCal(R[15], KG20_10, F_KG20_interval, KG20_Docs);
        
        ////////////////////////////计算压强/////////////////////////////////////
        char i = 0;
        for(i = 0; i < 16; i++)
            {
                Kpa[i] = do_KpaCal(F[i]);
            }
        
        char j = 0;
        for(j = 0; j < 16; j++)
            {
                Kpa_qz[j] = (unsigned int)(Kpa[j] + 0.5f) - 28;
            }
        
        ////////////////////////////技术处理/////////////////////////////////////
        Kpa_qz[0] = Kpa_qz[0];
        Kpa_qz[1] = Kpa_qz[1] - 12;
        Kpa_qz[2] = Kpa_qz[2];
        Kpa_qz[3] = Kpa_qz[3];
        Kpa_qz[4] = Kpa_qz[4];
        Kpa_qz[5] = Kpa_qz[5] - 130;
        Kpa_qz[6] = Kpa_qz[6] - 75;
        Kpa_qz[7] = Kpa_qz[7];
        Kpa_qz[8] = Kpa_qz[8];
        Kpa_qz[9] = Kpa_qz[9];
        Kpa_qz[10] = Kpa_qz[10] - 10;
        Kpa_qz[11] = Kpa_qz[11];
        Kpa_qz[12] = Kpa_qz[12];
        Kpa_qz[13] = Kpa_qz[13];
        Kpa_qz[14] = Kpa_qz[14];
        Kpa_qz[15] = Kpa_qz[15] - 59;
        
        
        
        
        ////////////////////////////////输出/////////////////////////////////////
        
        pc.printf("%04d\t%04d\t%04d\t%04d\t%04d\t%04d\t%04d\t%04d\t%04d\t%04d\t%04d\t%04d\t%04d\t%04d\t%04d\t%04d\n", Kpa_qz[0], Kpa_qz[1], Kpa_qz[2], Kpa_qz[3], Kpa_qz[4], Kpa_qz[5], Kpa_qz[6], Kpa_qz[7], Kpa_qz[8], Kpa_qz[9], Kpa_qz[10], Kpa_qz[11], Kpa_qz[12], Kpa_qz[13], Kpa_qz[14], Kpa_qz[15]);
        
    }
}
