#include "mbed.h"
#include "Moving_Average2.h"



// Source是不断变化的
float Moving_Average2(unsigned int NN2, float* FILTER2, float Source2)
{
    
    float AVER2 = 0.0f; 
    float SUM2 = 0.0f; 
    unsigned char i2;
    
    
    FILTER2[NN2] = Source2;    // 将接受到的数据放在均值滤波数组的“最后（倒数第2个）”元素里面

    
    // 把第一次进入的 Source 赋值给 FILTER[0] ~ FILTER[N-1]
    if(FILTER2[NN2+1] == 0)   // FILTER[N+1]等于0，表示第一次进入该函数
    {
        for(i2 = 0; i2 < NN2; i2++)
        {
            FILTER2[i2] = Source2;
        }

        FILTER2[NN2+1] = 1;   // 设置标记，已经进入过该函数，以后不再全部赋值   
    }
    

    for(i2 = 0; i2 < NN2; i2++)
    {
        FILTER2[i2] = FILTER2[i2 + 1];
        SUM2 += FILTER2[i2];
    }
    
    AVER2 = SUM2 / NN2;
    SUM2 = 0;

    return AVER2;
}