/*
mbed IoT Gateway demo

This is a demo program to read data from a JeeNode and upload to Pachube.

http://www.skpang.co.uk/catalog/mbed-iot-gateway-board-p-1051.html

Jan 2012 skpang.co.uk
*/
#include "mbed.h"
#include "RF12B.h"
#include "PachubeV2CSV.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
 
#define API_KEY "F8Gcwdhx2PvIdUrcGa84hbgBK6NC88yYUp1FxHG6f4E"
#define FEED_ID 40980
#define STREAM_ID "1"

PachubeV2CSV web(API_KEY);
EthernetNetIf eth;

DigitalOut myled(LED1);

DigitalOut led(p25);
RF12B radiolink(p11, p12, p13, p14, p18);

Serial pc(USBTX, USBRX); // tx, rx

int main() {
   const int feed_id = FEED_ID;
   const std::string stream_id = STREAM_ID;
   float payload;
 
   char val1_text[32];
      
    led = 1;
    pc.baud(115200);
    printf("RF12B test with Pachube\r\n");
  
    eth.setup();
   
    radiolink.init(2,2,1);   //id = 2, band 869, group 1

    led = 0;
    
    while(1) {
   
                 
    if (radiolink.rf12_recvDone() && (radiolink.check_crc() == 0)) // && rf12_crc == 0 && rf12_len == sizeof payload)
    {
     led = 1;
        // Copy the received data into payload:
        memcpy(&payload, (uint8_t*) radiolink.get_data(), sizeof(payload));

        // Print it out:
        printf("  payload: %f ", payload);
        sprintf(val1_text, "%f", payload);
     
        printf("updateDataStream(%d)\n", web.updateDataStream(feed_id, stream_id, std::string(val1_text)));
         
        led = 0; 
   }
         myled = 1;
      //  wait(0.1);
        myled = 0;
     
    }
}
