#include "mbed.h"
#include "ecu_simulator.h"
#include "globals.h"


// Use a timer to see if things take too long
Timer CANTimer;  
namespace mbed { 


ecu_sim::ecu_sim(int can_speed)
{
   can2.frequency(can_speed);
}

void ecu_sim::canspeed(int can_speed)
{
    can2.frequency(can_speed);
}



#define TIMEOUT 200
unsigned char ecu_sim::request(void)
{
    char can_msg[8];
   

    
    
    if ((can2.read(can_MsgRx)) && (can_MsgRx.id == PID_REQUEST) ){
        led2 = 1;
        if(can_MsgRx.data[1] == MODE3) // Request trouble codes
        {
             if(ecu.dtc == false){
                 can_msg[0] = 0x02; 
                 can_msg[1] = MODE3_RESPONSE;    
                 can_msg[2] = 0x00;  
             }else{
                 can_msg[0] = 0x06; 
                 can_msg[1] = MODE3_RESPONSE;    
                 can_msg[2] = 0x02;  
                 can_msg[3] = 0x01;  
                 can_msg[4] = 0x00;                
                 can_msg[5] = 0x02;
                 can_msg[6] = 0x00;                
             }
             can2.write(CANMessage(PID_REPLY, can_msg, 8));
        }

        if(can_MsgRx.data[1] == MODE4) // Clear trouble codes, clear Check engine light
        {
            ecu.dtc = false;  
            led4 = 0;
            
            can_msg[0] = 0x00; 
            can_msg[1] = MODE4_RESPONSE;   
            can2.write(CANMessage(PID_REPLY, can_msg, 8)); 
        }
        
        if(can_MsgRx.data[1] == MODE1)
        {
            can_msg[1] = MODE1_RESPONSE;
            switch(can_MsgRx.data[2])
            {   /* Details from http://en.wikipedia.org/wiki/OBD-II_PIDs */
                case PID_SUPPORTED:
                    can_msg[0] = 0x06;  
                    can_msg[2] = PID_SUPPORTED; 
                    can_msg[3] = 0xE8;
                    can_msg[4] = 0x19;
                    can_msg[5] = 0x30;
                    can_msg[6] = 0x12;
                    can_msg[5] = 0x00;
                    can2.write(CANMessage(PID_REPLY, can_msg, 8));    
                    
                    break;
                
                case MONITOR_STATUS:
                    can_msg[0] = 0x05;  
                    can_msg[2] = MONITOR_STATUS; 
                    
                    if(ecu.dtc == true) can_msg[3] = 0x82;
                        else can_msg[3] = 0x00;
                    
                    can_msg[4] = 0x07;
                    can_msg[5] = 0xFF;
                    can2.write(CANMessage(PID_REPLY, can_msg, 8));    
                    break;
                        
                case ENGINE_RPM:              //   ((A*256)+B)/4    [RPM]
                    can_msg[0] = 0x04;  
                    can_msg[2] = ENGINE_RPM; 
                    can_msg[3] = (ecu.engine_rpm & 0xff00) >> 8;
                    can_msg[4] = ecu.engine_rpm & 0x00ff;
                    can2.write(CANMessage(PID_REPLY, can_msg, 8));              
                    break;
                               
                case ENGINE_COOLANT_TEMP:     //     A-40              [degree C]
                    can_msg[0] = 0x03;  
                    can_msg[2] = ENGINE_COOLANT_TEMP; 
                    can_msg[3] = ecu.coolant_temp;
                    can2.write(CANMessage(PID_REPLY, can_msg, 8));
                    break;
                               
                case VEHICLE_SPEED:         // A                  [km]
                    can_msg[0] = 0x03;  
                    can_msg[2] = VEHICLE_SPEED; 
                    can_msg[3] = ecu.vehicle_speed;
                    can2.write(CANMessage(PID_REPLY, can_msg, 8));
                    break;
    
                case MAF_SENSOR:               // ((256*A)+B) / 100  [g/s]
                    can_msg[0] = 0x04;  
                    can_msg[2] = MAF_SENSOR; 
                    can_msg[3] = (ecu.maf_airflow & 0xff00) >> 8;
                    can_msg[4] =  ecu.maf_airflow & 0x00ff;
                    can2.write(CANMessage(PID_REPLY, can_msg, 8));                
                    break;
    
                case O2_VOLTAGE:            // A * 0.005   (B-128) * 100/128 (if B==0xFF, sensor is not used in trim calc)
                    can_msg[0] = 0x04;  
                    can_msg[2] = O2_VOLTAGE; 
                    can_msg[3] = ecu.o2_voltage & 0x00ff;
                    can_msg[4] = (ecu.o2_voltage & 0xff00) >> 8;
                    can2.write(CANMessage(PID_REPLY, can_msg, 8));                
                    break;;
                   
                case THROTTLE:            //
                    can_msg[0] = 0x03;  
                    can_msg[2] = THROTTLE; 
                    can_msg[3] = ecu.throttle_position;
                    can2.write(CANMessage(PID_REPLY, can_msg, 8));         
                    break;
              }//switch
        }
    
              
 
    pc.printf("\n\r%x %x %x %x %x %x %x %x %x",can_MsgRx.id,can_MsgRx.data[0],
                                           can_MsgRx.data[1],
                                           can_MsgRx.data[2],
                                           can_MsgRx.data[3],
                                           can_MsgRx.data[4],
                                           can_MsgRx.data[5],
                                           can_MsgRx.data[6],
                                           can_MsgRx.data[7]);
    led2 = 0;
   }
    
    return 0;

}

   
} // namespace mbed 