/*

mbed Can-Bus ECU simulator

v1.0 December 2014

********************************************************************************

WARNING: Use at your own risk, sadly this software comes with no guarantees.
This software is provided 'free' and in good faith, but the author does not
accept liability for any damage arising from its use.

********************************************************************************

*/

#include "mbed.h"
#include "ecu_simulator.h"
#include "globals.h"
#include "TextLCD.h"

TextLCD lcd(p18, p19, p20, p17, p16, p15, p14); // rs, rw, e, d0, d1, d2, d3

DigitalIn click(p21);   // Joystick inputs
DigitalIn right(p22);
DigitalIn down(p23);
DigitalIn left(p24);
DigitalIn up(p25);

ecu_sim sim(CANSPEED_500);     //Create object and set CAN speed
ecu_t ecu;

void update_menu(void);
void update_param(unsigned char dir);

// Menu defines
#define L0_MAIN_MENU   0
#define L0_RPM         1
#define L0_THROTTLE    2
#define L0_SPEED       3
#define L0_COOLANT     4
#define L0_MAF         5
#define L0_O2          6
#define L0_DTC         7

#define INC            0
#define DEC            1

#define CAN250         0
#define CAN500         1
unsigned char menu_state;
unsigned char canspeed;

int main() 
{
    pc.baud(115200);

    //Enable Pullup 
    click.mode(PullUp);
    right.mode(PullUp);
    down.mode(PullUp);
    left.mode(PullUp);
    up.mode(PullUp);

    printf("\n\nECU Simulator v1.0 \n"); 
      
    led1 = 1;
    wait(0.1);
    led2 = 1;
    wait(0.1);
    led3 = 1;
    wait(0.1);
    led4 = 1;
    wait(0.2);
    led1 = 0; led2 = 0; led3 = 0; led4 = 0;
       
    lcd.cls();
    lcd.locate(0,0);                // Set LCD cursor position
    lcd.printf("ECU Simulator v1.0");
    lcd.locate(0,1);
    lcd.printf("www.skpang.co.uk");
    
    wait(1);
    lcd.cls();
    
    lcd.printf("<- Params ->");
    lcd.locate(0,1);
    lcd.printf("500kb/s");
    
    canspeed = CAN500;
    menu_state = L0_MAIN_MENU;
    ecu.dtc = false;
    
    wait(0.2);
    led1 = 1;
    
    while(1) {  // Main CAN loop

        sim.request();
        
        if(!down){
            update_param(DEC);
        }
         
        if(!up){
            update_param(INC);
        }
        
        if(!left){
           if(menu_state != L0_MAIN_MENU) menu_state--;
           update_menu(); 
        }
        
        if(!right){
           if(menu_state != L0_DTC) menu_state++;
           update_menu(); 
        }

    }
}
void update_param(unsigned char dir)
{
    char buffer[20];
    lcd.locate(0,1);  
    switch(menu_state)
    {
        case L0_MAIN_MENU:
            if(dir == INC){
                sim.canspeed(CANSPEED_500); 
                lcd.printf("500kb/s");
                canspeed = CAN500;
            }else {
                sim.canspeed(CANSPEED_250); 
                lcd.printf("250kb/s");
                canspeed = CAN250;
            }
                
            break;

        case L0_RPM:
            if(dir == INC){
                ecu.engine_rpm = ecu.engine_rpm +10;
            } else ecu.engine_rpm = ecu.engine_rpm - 10;
    
            sprintf(buffer,"%d RPM   ", (int)((((ecu.engine_rpm & 0xff00) >> 8) * 256) + (ecu.engine_rpm & 0x00ff)) / 4);  
            lcd.printf(buffer);   
            break;
            
        case L0_THROTTLE:
            if(dir == INC){
                ecu.throttle_position++;
            } else ecu.throttle_position--;
            
            sprintf(buffer,"%d %%   ", (int)ecu.throttle_position);  
            lcd.printf(buffer);   
            break;
            
        case L0_SPEED:
            if(dir == INC){
                ecu.vehicle_speed++;
            } else ecu.vehicle_speed--;
     
            sprintf(buffer,"%d km/h  ",(int) ecu.vehicle_speed);  
            lcd.printf(buffer); 
            break;
            
        case L0_COOLANT:
            if(dir == INC){
                ecu.coolant_temp++;
            } else ecu.coolant_temp--;
     
            sprintf(buffer,"%d C  ",(int) ecu.coolant_temp - 40);  
            lcd.printf(buffer); 
            break;             
            
        case L0_MAF:
            if(dir == INC){
                ecu.maf_airflow = ecu.maf_airflow +10;
            } else ecu.maf_airflow = ecu.maf_airflow - 10;
            
            sprintf(buffer,"%d g/s   ", (int)((((ecu.maf_airflow & 0xff00) >> 8) * 256) + (ecu.maf_airflow & 0x00ff)) / 100); 
            lcd.printf(buffer);   
            break;
            
        case L0_O2:
            if(dir == INC){
                ecu.o2_voltage = ecu.o2_voltage +10;
            } else ecu.o2_voltage = ecu.o2_voltage - 10;
            
            sprintf(buffer,"%d   ", (int)ecu.o2_voltage);  
            lcd.printf(buffer);   
            break;
            
         case L0_DTC:
            if(dir == INC){
                ecu.dtc = true;
                led4 = 1;
            } else {
                ecu.dtc = false;
                led4 = 0;
            }
            
            sprintf(buffer,"%d   ", (int)ecu.dtc);  
            lcd.printf(buffer);   
            break;    
            
    }
   
   wait(0.1);   //Delay for auto repeat
    
    
}
void update_menu(void)
{
    char buffer[20];
    lcd.cls();
    lcd.locate(0,0);     
   
    switch(menu_state)
    {
        case L0_MAIN_MENU:
            lcd.printf("CAN speed");
            lcd.locate(0,1);  
            if(canspeed == CAN500) lcd.printf("500kb/s");
                else lcd.printf("250kb/s");
            break;
            
        case L0_RPM:
            lcd.printf("Engine RPM");
            lcd.locate(0,1);
            sprintf(buffer,"%d RPM   ", (int) ((((ecu.engine_rpm & 0xff00) >> 8) * 256) + (ecu.engine_rpm & 0x00ff)) / 4);  
            lcd.printf(buffer);   
            break;
            
        case L0_THROTTLE:
            lcd.printf("Throttle pos");
            lcd.locate(0,1);
            sprintf(buffer,"%d %   ", ecu.throttle_position);  
            lcd.printf(buffer);   
            break;
            
        case L0_SPEED:
            lcd.printf("Vehicle speed");
            lcd.locate(0,1);  
            sprintf(buffer,"%d kph  ", ecu.vehicle_speed);  
            lcd.printf(buffer); 
            break;
        
        case L0_COOLANT:
            lcd.printf("Coolant temp");
            lcd.locate(0,1);  
            sprintf(buffer,"%d C  ",(int) ecu.coolant_temp - 40);  
            lcd.printf(buffer); 
            break;
            
        case L0_MAF:
            lcd.printf("MAF air flow ");
            lcd.locate(0,1);
            sprintf(buffer,"%d g/s   ", ecu.maf_airflow);  
            lcd.printf(buffer);   
            break;
            
        case L0_O2:
            lcd.printf("Oxygen sensor v.");
            lcd.locate(0,1);  
            sprintf(buffer,"%d   ", ecu.o2_voltage);  
            lcd.printf(buffer);   
            break;
            
        case L0_DTC:
            lcd.printf("DTC");
            lcd.locate(0,1);  
            sprintf(buffer,"%d   ", ecu.dtc);  
            lcd.printf(buffer);   
            break;
            
    }
   
   while(!left);    //Wait for key to be released
   while(!right);
   wait(0.05);
    
}



