#include "mbed.h"
#include "SerialLCD.h"
#include "SDFileSystem.h"
#include "MSCFileSystem.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"

DigitalOut myled(LED1);
SerialLCD lcd(p9,p10);
DigitalOut led1 (LED1);
DigitalOut led2 (LED2);
DigitalOut led3 (LED3);
DigitalOut led4 (LED4);

//locate    (    int     column,int     row     )        
DigitalIn click(p21);   // Joystick inputs
DigitalIn right(p22);
DigitalIn down(p23);
DigitalIn left(p24);
DigitalIn up(p25);

SDFileSystem sd(p5, p6, p7, p13, "sd");
MSCFileSystem fs("fs");
AnalogIn ain(p20);
#include "HTTPServer.h"

EthernetNetIf eth;  
HTTPServer svr; 
void sd_demo(void);
void eth_demo(void);
void usb_demo(void);
 
int main() {
    wait(2);        // Wait for LCD to startup
    lcd.cls();
    lcd.printf("U-USB:D-ETH:L-SD");
//    lcd.locate(0,0);
    lcd.printf("");
    while(1)    // Wait until option is selected by the joystick
    {
   
        if(down == 0) eth_demo();
        if(left == 0) sd_demo();
               
        if(up == 0) usb_demo();
        
    }
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}

void eth_demo(void)
{

 printf("Setting up23423...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
   
  }
  printf("Setup OK\n");
  
  svr.addHandler<SimpleHandler>("/"); //Default handler
  svr.bind(80);
  
  printf("Listening..d.\n");
 
  
  
  printf("more...");
  
  
  Timer tm;
  tm.start();
  //Listen indefinitely
  while(true)
  {
    Net::poll();
    if(tm.read()>.5)
    {
      led1=!led1; //Show that we are alive
      tm.start();
    }
  }
}

void sd_demo(void)
{
 lcd.cls();
    lcd.printf("SD demo");
    wait(2);      
    lcd.cls();
    
    FILE *fp = fopen("/sd/sdtest2.txt", "w");
    if(fp == NULL) {
        lcd.cls();
        lcd.printf("Could not open file for write\n");
    }
    fprintf(fp, "Hello fun SD Card World! testing 1234");
    fclose(fp); 
    lcd.locate(0,1);
    lcd.printf("Writtern to SD card");
        
    while(1)
    {
        led2 = 1;
        wait(0.1);
        led2 = 0;
        wait(0.1);
   
    }
    

}


void usb_demo(void)
{
  FILE *fp = fopen("/fs/data.csv", "w");
    for (int i=0; i<100; i++) {
        fprintf(fp,"%.2f\n",ain.read());
        wait(0.05);
        }
    
    
    fclose(fp); 
    
   while(1)
    {
        led2 = 1;
        wait(0.1);
        led2 = 0;
        wait(0.1);
   
    }



}