#ifndef _RF12B_H
#define _RF12B_H

#include "mbed.h"
#define RF12_433MHZ     1
#define RF12_868MHZ     2
#define RF12_915MHZ     3

#define rf12_grp        rf12_buf[0]
#define rf12_hdr        rf12_buf[1]
#define rf12_len        rf12_buf[2]
#define rf12_data       (rf12_buf + 3)

#define RF12_HDR_CTL    0x80
#define RF12_HDR_DST    0x40
#define RF12_HDR_ACK    0x20
#define RF12_HDR_MASK   0x1F

#define RF12_MAXDATA    66
// maximum transmit / receive buffer: 3 header + data + 2 crc bytes
#define RF_MAX   (RF12_MAXDATA + 5)
#define PACKET_LEN 16

// shorthand to simplify sending out the proper ACK when requested
#define RF12_WANTS_ACK ((rf12_hdr & RF12_HDR_ACK) && !(rf12_hdr & RF12_HDR_CTL))
#define RF12_ACK_REPLY (rf12_hdr & RF12_HDR_DST ? RF12_HDR_CTL : \
            RF12_HDR_CTL | RF12_HDR_DST | (rf12_hdr & RF12_HDR_MASK))
 
// New for mbed 
#define RF12_WANTS_ACK_MBED ((radiolink.get_hdr() & RF12_HDR_ACK) && !(radiolink.get_hdr() & RF12_HDR_CTL))
#define RF12_ACK_REPLY_MBED (radiolink.get_hdr() & RF12_HDR_DST ? RF12_HDR_CTL : \
            RF12_HDR_CTL | RF12_HDR_DST | (radiolink.get_hdr() & RF12_HDR_MASK))
                       
            
//enum rfmode_t{RX, TX};

class RF12B {
public:
    /* Constructor */
    RF12B(PinName SDI,
          PinName SDO,
          PinName SCK,
          PinName NCS,
          PinName NIRQ);
   
     
    /* Initialises the RF12B module */
    void init(uint8_t id, uint8_t band, uint8_t g);
        
 
    /* Returns the packet length if data is available in the receive buffer, 0 otherwise*/
   unsigned int available();
   void rf12_sendStart (uint8_t hdr, const void* ptr, uint8_t len);
   void rf12_sendStart2 (uint8_t hdr); 
   uint8_t  rf12_recvDone (void);
   void rf12_recvStart (void);
   uint16_t check_crc(void);
   uint8_t length(void);
   uint8_t* get_data(void);
   uint8_t get_hdr(void);
   
protected:

    /* SPI module */
    SPI spi;
    
    /* Other digital pins */
    DigitalOut NCS;
    InterruptIn NIRQ;
    DigitalIn NIRQ_in;

    volatile uint16_t rf12_crc; // running crc value
    volatile unsigned char rf12_buf[RF_MAX];  // recv/xmit buf, including hdr & crc bytes  
    volatile  uint8_t nodeid;              // address of this node
    volatile  uint8_t group;               // network grou
    volatile uint8_t rxfill;     // number of data bytes in rf12_buf
    volatile int8_t rxstate;     // current transceiver state
 

    /* Write a command to the RF Module */
    unsigned int writeCmd(unsigned int cmd);
    
    /* Sends a byte of data across RF */
    void send(unsigned char data);
    
    /* Interrupt routine for data reception */
    void rxISR();
    

    uint16_t _crc16_update(uint16_t crc, uint8_t data);
    
    uint16_t rf12_xfer (uint16_t cmd);    
    uint8_t rf12_byte(uint8_t out);
};

#endif /* _RF12B_H */