#include "mbed.h"
#include "SDFileSystem.h"
 
/*
FRDM KL25Z with Seeed SD Card Shield V4
Connections have to be added between the SD Card Shield
digital connector pins and the SPI connector pins as follows:
Signal  Digital SPI
MOSI    D11     4
MISO    D12     1
SCK     D13     3
/CS     D4
*/

//SDFileSystem sd(PTD2, PTD3, PTD1, PTA4, "sd"); // MOSI, MISO, SCK, CS
SDFileSystem sd(D11, D12, D13, D4, "sd"); // MOSI, MISO, SCK, CS
Serial pc(USBTX, USBRX);
 
int main() {
    pc.printf("Hello World!\n");   
 
    mkdir("/sd/mydir", 0777);
    
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        pc.printf("Could not open file for write\n");
    }
    fprintf(fp, "Hello fun SD Card World!");
    fclose(fp); 
 
    pc.printf("Goodbye World!\n");
}
