#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"
#include "MCP3221.h"
#include "Peter.h"

#define MCP3221_REF 5.12 /* MCP3221 ADC reference (supply) voltage */

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
DigitalOut led1(LED1);
MCP3221 adc(PB_9, PB_8, MCP3221_REF); // sda, scl, reference (supply) voltage

int main()
{
    TS_StateTypeDef TS_State;
    uint8_t text[30];

    led1 = 1;

    // Display bitmap image
    lcd.Clear(LCD_COLOR_WHITE);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.DrawBitmap(0, 0, (uint8_t *)peter_file);

    // Display circle
    lcd.SetTextColor(LCD_COLOR_RED);
    lcd.FillCircle(50, 200, 40);

    // Set display text colours
    lcd.SetBackColor(LCD_COLOR_DARKGREEN);
    lcd.SetTextColor(LCD_COLOR_LIGHTGRAY);

    while(1) {

        // Display touch message
        ts.GetState(&TS_State);
        if (TS_State.touchDetected) {
            lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"  TOUCH DETECTED!  ", CENTER_MODE);
        } else {
            lcd.DisplayStringAt(0, LINE(5), (uint8_t *)" NO TOUCH DETECTED ", CENTER_MODE);
        }

        // Read and scale ADC result
        sprintf((char*)text, " ADC=%.3f ", adc.read());
//        sprintf((char*)text, " ADC=%.3f ", 1.234);
        lcd.DisplayStringAt(0, LINE(8), (uint8_t *)&text, CENTER_MODE);

        led1 = !led1;
    }
}
