#ifndef ANDANTE_PROTOCOL_H
#define ANDANTE_PROTOCOL_H

#include "mbed.h"

#define ANDANTE_BUFFER_SIZE            0x8F

#define ANDANTE_PROTOCOL_COMMAND_RESPONSE_TIMEOUT_MS   20

#define ANDANTE_PROTOCOL_HEADER_0      0xFF
#define ANDANTE_PROTOCOL_HEADER_1      0xFF

// Errors
#define ANDANTE_ERRBIT_NONE            0x00
#define ANDANTE_ERRBIT_VOLTAGE         0x01
#define ANDANTE_ERRBIT_ANGLE           0x02
#define ANDANTE_ERRBIT_OVERHEAT        0x04
#define ANDANTE_ERRBIT_RANGE           0x08
#define ANDANTE_ERRBIT_CHECKSUM        0x10
#define ANDANTE_ERRBIT_OVERLOAD        0x20
#define ANDANTE_ERRBIT_INSTRUCTION     0x40

// Extra errors
#define ANDANTE_ERRBIT_WRITE_TIMEOUT   0xFD
#define ANDANTE_ERRBIT_READ_TIMEOUT    0xFE
#define ANDANTE_ERRBIT_MASTER_CHECKSUM 0xFF


//Instruction Control
#define ANDANTE_SPEED_CONTROL   0x01
#define ANDANTE_FRONT_ANGLE     0x02
#define ANDANTE_REAR_ANGLE      0x04

//Instruction Sensor


struct ANDANTE_PROTOCOL_PACKET
{
    uint8_t robotId;
    uint8_t length;    
    uint8_t instructionErrorId;   
    uint8_t parameter[ANDANTE_BUFFER_SIZE];
    uint8_t checkSum;
};

enum ANDANTE_PROTOCOL_ENCODER_DECODER_STATE
{
    WAIT_ON_HEADER_0,
    WAIT_ON_HEADER_1,
    WAIT_ON_ROBOT_ID,   
    WAIT_ON_LENGTH,
    WAIT_ON_INSTRUCTION_ERROR_ID,
    WAIT_ON_PARAMETER,
    WAIT_ON_CHECK_SUM
};

#endif // ANDANTE_PROTOCOL_H