#include "MMA8451Q.h"
#include "mbed.h"
#include "USBMouseKeyboard.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

DigitalOut myled(LED1);
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
USBMouse joystick;
AnalogIn ainX(PTB0);
AnalogIn ainY(PTB1);
Serial serialPort(PTD3, PTD2); // tx, rx
int ledState = 0;
int x = 128, y = 128, xOld = 0, yOld = 0;
int updateFlag = 0;

void invertLed() {
    if(ledState == 0) ledState = 1;
    else ledState = 0;
    myled = ledState;
}

void rxIrq() {
    serialPort.scanf("%d %d",&x,&y);
    invertLed();
    updateFlag = 1;
}

int main(void) {
    joystick.move(128, 128);


    // IF you want to get the data from serial port, uncomment this part
    // serial data rate is 9600 bps. send data to PTD2
    // give two integers separated by space. First one is X and the second one is Y.
    // 128 128 is at center, 0 0 is some corner and 255 255 is the diagonal corner.

    serialPort.attach(&rxIrq);
    while (true) {
        if(updateFlag) {
            updateFlag = 0;
            xOld = x;
            yOld = y;
            joystick.move(x, y);
            
        }
        else 
        {
            joystick.move(xOld, yOld);
        }
        wait(0.08);
    }


        // IF you are using the built-in acceleration sensor of the FRDM-KL25Z, uncomment this part
/*
    while (true) {
        x = (acc.getAccXX() + 4096)/32;
        y = (acc.getAccYY() + 4096)/32;
        x = x + 128;
        y = y + 128;
        wait(0.1);
    }
*/
        
        
        
        // IF you are using the analog input of the FRDM-KL25Z, uncomment this part
/*
    while (true) {
        x = ainX.read() * 256;
        y = ainY.read() * 256;
        x = x + 128;
        y = y + 128;
        wait(0.1);
    }
*/

}
