#include "mbed.h"
#include "DHT.h"

Serial pc(USBTX, USBRX);
Serial esp(PTC17, PTC16); //FRDM K64F 

DHT sensor(D4, DHT11); 
DigitalIn pirInputPin(D2); 

Timer t1;

int  count,ended,timeout,getcount,replycount;
char replybuff[1024];
char cmdbuff[255];

void SendCMD(),getreply(),getMotionSensor(),gettemp(), ESPconfig();
void sendUbidotsData(int sensor, float value);


int main()
{
    pc.baud(115200);  
    esp.baud(115200);   
    ESPconfig();
    while(1){
    wait(2);
    gettemp();
    wait(2);
    getMotionSensor();
    }
    
}



//configuration of esp8266
void ESPconfig()
{
    timeout=1000;getcount=600;
    wait(1);
    strcpy(cmdbuff,"AT\r\n");
    SendCMD();
    timeout=1;
    getreply();
    wait(1);
    
    pc.printf("Reset & get Firmware\r\n");
    strcpy(cmdbuff,"AT+RST\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(replybuff);

    wait(2);

    pc.printf("\nGet Version\r\n");
    strcpy(cmdbuff,"AT+GMR\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(replybuff);

    wait(3);

    // set CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    pc.printf("\nSetting Mode\r\n");
    strcpy(cmdbuff, "AT+CWMODE=1\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(replybuff);

    wait(2);

    // set CIPMUX to 0=Single,1=Multi
    pc.printf("\nSetting Connection Mode\r\n");
    strcpy(cmdbuff, "AT+CIPMUX=1\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(replybuff);

   
    wait(2);

    pc.printf("\nConnecting to AP\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n","ssid","password");
    strcpy(cmdbuff, "AT+CWJAP=\"");
    strcat(cmdbuff, "galaxy");
    strcat(cmdbuff, "\",\"");
    strcat(cmdbuff, "123456789");
    strcat(cmdbuff, "\"\r\n");
    SendCMD();
    timeout=10;
    getreply();
    pc.printf(replybuff);

    wait(5);

   

    pc.printf("\nGet Connection Status\r\n");
    strcpy(cmdbuff, "AT+CIPSTATUS\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(replybuff);
    
    wait(1);

}
//temperature sensor reads the temp
void gettemp()
{   
float temperature = 0.0f;
   int error = 0;
    
    wait(2.0f); 
    error = sensor.readData(); 
    if (error == 0) { 
        temperature = sensor.ReadTemperature(FARENHEIT);
        pc.printf("Temperature in Farenheit %3.2f\n",temperature);   
    }
    else{
        pc.printf("Error: %d\n",error);
    }
   
   sendUbidotsData(2, temperature); 
   wait(2);            
}

//pir sensor detects if there is motion
void getMotionSensor(){
    pc.printf("get motion sensor");
    int val = pirInputPin.read(); // Continuously Read output of PIR sensor on D2 pin
     if (val==0) // val=0 means there is a motion 
     {
        for(int i =0;i<3 && val==0;i++)
        {
            val = pirInputPin.read();
            wait(1);
        }
        if (val==0)
          sendUbidotsData(1, 1.0);  
    }
     else
        wait(2);
}

//post dat ato ubidots website
//pir=1,temp=2
void sendUbidotsData(int sensor, float value){
    char postData[255];
    char valueChar[10];
    char valLenChar[7];
    int valLength = sprintf(valueChar,"%3.1f",value);
    valLength = valLength+13;
    sprintf(valLenChar,"%ld",valLength);
    
   if(sensor == 1)
      strcpy(postData, "POST /api/v1.6/variables/variable_id1/values/?token=token_id HTTP/1.1\r\n");
   else{
    strcpy(postData, "POST /api/v1.6/variables/variable_id2/values/?token=token_id HTTP/1.1\r\n");
    }
    strcat(postData, "Host: things.ubidots.com\r\n");
    strcat(postData, "Content-Type: application/json\r\n");
    strcat(postData, "Content-Length: ");
    strcat(postData, valLenChar);
    strcat(postData, "\r\n\r\n");
    strcat(postData, "{\"value\": \"");
    strcat(postData, valueChar);
    strcat(postData, "\"}\r\n\r\n");
    
    timeout=1000;getcount=600;
    
    pc.printf("\nStart TCP\r\n");
    strcpy(cmdbuff, "AT+CIPSTART=4,\"TCP\",\"things.ubidots.com\",80\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(replybuff);
    
    wait(5);

    pc.printf("\nConnecting\r\n");
    sprintf(cmdbuff, "AT+CIPSEND=4,%d\r\n",strlen(postData));//strlen(postData)
    SendCMD();
    wait(3);
    timeout=5;
    getreply();
    pc.printf(replybuff);
    
    wait(2);

    pc.printf("\nPOST Request\r\n");
    strcpy(cmdbuff, postData);
    SendCMD();
    wait(7);
    timeout=5;
    getreply();
    pc.printf(replybuff);
    
    wait(5);
    pc.printf("\nClose TCP\r\n");
    strcpy(cmdbuff, "AT+CIPCLOSE\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(replybuff);

    wait(2);    
}


// ESP Command data send
void SendCMD()
{
    esp.printf("%s", cmdbuff);      
}  

void getreply()
{    
    memset(replybuff, '\0', sizeof(replybuff));
    t1.reset(); t1.start();replycount=0;
    while(t1.read_ms()< timeout && replycount < getcount) {
        if(esp.readable()) {
            replybuff[replycount] = esp.getc();replycount++;
            }
        }
    t1.stop();      
}