#include "mbed.h"
#include "N5110.h"
#define dp23 P0_0
#define PI 3.14

DigitalOut prviRed(dp16), drugiRed(dp15), treciRed(dp17), cetvrtiRed(dp27);
DigitalIn prvaKolona(dp9), drugaKolona(dp10), trecaKolona(dp11), cetvrtaKolona(dp13);
N5110 displej(dp4, dp25, dp23, dp26, dp2, dp6, dp18);
DigitalOut enable(dp14);
DigitalOut led(dp24);
Timer timer,timerAlarm, timerDebounc;
InterruptIn taster(dp1);
Serial pc(USBTX,USBRX);

Ticker tikerSat;
bool podesavanje = 0, podesenAlarm=0;
int ukljuciAlarm=0;


//GLOBALNE VARIJABLE
int p=42,q=24; //koordinate centra
int dh=15, dm=20, ds=19; //duzina kazaljke 
int sati=0, minute=0, sekunde=0;
int dan=1, mjesec=1, godina=15;
char izbor=' ', a=' ';
int buff[6];
int i=0, k=0;


//DEFINICIJE FUNKCIJA
void nacrtajKazaljkuSat(int h, int min);
void nacrtajKazaljkuMin(int min, int sek);
void nacrtajKazaljkuSek(int sek);
char ocitajTastaturu();
void analogniSat();
void podesavanjeF();





void ukljuciAlarmF(){  
        led = 1; wait(0.5);
        
        pc.printf("alarm");
        podesenAlarm = 0;
    }

int main() 
{
    enable=1; led=0;
    displej.init();
    displej.refresh();
    taster.rise(&podesavanjeF); //kada je taster pritisnut poziva se funkcija za podesavanje
    tikerSat.attach(&analogniSat, 1.0); //tiker svake sekunde poziva funkciju analogni sat

    while(1){
        if ( ukljuciAlarm==1 && podesenAlarm == 1) ukljuciAlarmF();
        }

        


}

        
void analogniSat()
{ 
    sekunde++; 
    if (ukljuciAlarm>0) ukljuciAlarm--;
        if ( sekunde == 60 ) { sekunde = 0; minute++;}
            if ( minute == 60 ) { minute = 0; sati++;}
                if ( sati == 24 ) { sati = 0; }
                    if (podesavanje == 1) { return; } //ukoliko traje podesavanje iscrtavanje sata ne treba da se desi
                    displej.clear();
                    displej.refresh();
                    displej.drawCircle(42,24,22,0);
                    nacrtajKazaljkuSat(sati,minute);
                    nacrtajKazaljkuMin(minute,sekunde);
                    nacrtajKazaljkuSek(sekunde);
                    
                    displej.printChar(char('0'+dan/10),0,5);
                    displej.printChar(char('0'+dan%10),6,5);
                    displej.printChar('.',12,5);
                    displej.printChar(char('0'+mjesec/10),18,5);
                    displej.printChar(char('0'+mjesec%10),24,5);
                    displej.printChar('/',64,5);
                    displej.printChar(char('0'+godina/10),70,5);
                    displej.printChar(char('0'+godina%10),76,5);
                    
                    
                    displej.refresh();
}
    
void podesavanjeF()
{
    podesavanje = 1; //podesavanje pocinje, koristi se u funkciji AnalogniSat
    displej.clear(); //obrisi sat
    displej.refresh();
    //ispisi meni:
    displej.printString("Menu 1, 2, 3",0,0); //displej.refresh();
    displej.printString("1 - set time",0,1); //displej.refresh();
    displej.printString("2 - set alarm",0,2);// displej.refresh();
    displej.printString("3 - set date",0,3); //displej.refresh();
    //displej.printString("Form 00/00/00",0,4);
    displej.refresh();
   
    izbor=' ';
    timerDebounc.start();
    while( izbor == ' ' || izbor=='n' ){      
        if(timerDebounc.read_ms() > 220) //za debouncing
        { 
            izbor = ocitajTastaturu(); 
            timerDebounc.reset();
        }
    }
    timerDebounc.stop();
    
    displej.clear(); //obrisi sat
    displej.printString("Form 00/00/00",0,0);
    displej.printString("* za brisanje",0,1);
    displej.refresh();
    
    k=0; //za ispisivanje formata tj pomjeranje za 6 piksela
    if (izbor=='1' || izbor=='2' || izbor=='3' )
    {
            i=0;
            //ocitavanje sati, minuta i sekundi, odnosno dana, mjeseci i godina
            while ( i<6 ) //ZAHTIJEVAMO UNOS 6 CIFARA
            { 
                a=' ';
                timerDebounc.start();
                while( a==' ' || a=='n' ){      
                    if(timerDebounc.read_ms() > 150) //za debouncing
                    { 
                        a = ocitajTastaturu(); 
                        timerDebounc.reset();
                    }
                }
                timerDebounc.stop();
                
                displej.printChar(a,k,3); //ispisi unijetu cifru 
                displej.refresh();
                            
                buff[i]=int(a)-48; //unijetu cifru smijestamo u niz
                i++; k+=6; //k+6 jer char zauzima 6 piksela
                if ( i==2 || i==4 ) { displej.printChar(':',k,3); k+=6;} 
                
                if(a=='#'){  displej.clear(); displej.refresh(); // displej.printString("Form 00/00/00",0,0);
                             displej.refresh(); i=0; k=0;} //ako korisnik ponisti unos vracamo se na pocetak
            }
        //NAKON UNESENIH 6 CIFARA:
            if (izbor == '1') //podesi globalne varijable
            {
                    sati = 10*buff[0] +  buff[1];
                    minute = 10*buff[2] +  buff[3];
                    sekunde = 10*buff[4] +  buff[5];
            }
            else if (izbor == '2') //racunamo za koliko sekundi ce se alarm ukljuciti:
            {
                    ukljuciAlarm = 3600*(10*buff[0] +  buff[1]) + 60*(10*buff[2] +  buff[3]) + 10*buff[4] +  buff[5];
                    podesenAlarm = 1;
            }
            else //Datum
            {
                    dan = 10*buff[0] +  buff[1];
                    mjesec = 10*buff[2] +  buff[3];
                    godina = 10*buff[4] +  buff[5];
            }
    }        
    else //AKO NISU UNIJETI 1 2 ILI 3
    { 
        displej.clear();
        displej.printString("Pogresan unos",0,0);
        displej.refresh();
    }
    podesavanje=0;
}   
    
    
    

void nacrtajKazaljkuSat(int h, int min){
    float ugao;
    //1 sat odgovara 360/12 stepeni, a jednoj minuti 30/60 stepeni
    ugao = (h % 12) * (360/12) - 90; //3 sata predstavlja 0 stepeni pa oduzimamo 90
    ugao = ugao + min * (30/60);
    ugao=(ugao*PI)/180; //pretvaramo u radijane
    float x=p+dh*cos(ugao);
    float y=q+dh*sin(ugao);
    displej.drawLine(p,q,x,y,1);
    displej.refresh();
    }

void nacrtajKazaljkuMin(int min, int sek){
    float ugao;
    //1 min odgovara 360/60 stepeni, a jednoj sekundi 6/60 stepeni
    ugao=min*(360/60) - 90; //3 sata predstavlja 0 stepeni pa oduzimamo 90
    ugao=ugao + sek * (6/60);
    ugao=(ugao*PI)/180; //pretvaramo u radijane
    float x=p+dm*cos(ugao);
    float y=q+dm*sin(ugao);
    displej.drawLine(p,q,x,y,1);
    displej.refresh();
    }
    
void nacrtajKazaljkuSek(int sek){
    float ugao;
    //1 sek odgovara 360/60 stepeni
    ugao = sek * (360/60) - 90; //3 sata predstavlja 0 stepeni pa oduzimamo 90
    ugao=(ugao*PI)/180; //pretvaramo u radijane
    float x=p+ds*cos(ugao);
    float y=q+ds*sin(ugao);
    displej.drawLine(p,q,x,y,1);
    displej.refresh();
    }
 
char ocitajTastaturu(){
    prviRed = 0; drugiRed = 0; treciRed = 0; cetvrtiRed = 0; 
    
    prviRed = 1;
    if(prvaKolona == 1) return '1';   
    else if(drugaKolona == 1) return '2';  
    else if(trecaKolona == 1) return '3';    
    else if(cetvrtaKolona == 1) return '0';  
    prviRed = 0;
    
    drugiRed = 1;
    if(prvaKolona == 1) return '4';
    else if(drugaKolona == 1) return '5';
    else if(trecaKolona == 1) return '6';
    else if(cetvrtaKolona == 1) return '*';
    drugiRed = 0;
    
    treciRed = 1;
    if(prvaKolona == 1) return '7';
    else if(drugaKolona == 1) return '8';
    else if(trecaKolona == 1) return '9';
    else if(cetvrtaKolona == 1) return 'n';
    treciRed = 0;
    
    cetvrtiRed = 1;
    if(prvaKolona == 1) return 'n';
    else if(drugaKolona == 1) return 'n';
    else if(trecaKolona == 1) return 'n';
    else if(cetvrtaKolona == 1) return 'n';
    cetvrtiRed = 0;
 
    return 'n';
}



