#include "mbed.h"
#include "TSISensor.h"

Serial pc(USBTX, USBRX); 
PwmOut ledice[3] = {LED1, LED2, LED3};

TSISensor tsi;
Ticker ticker;
int i = 0;

double uzmiBroj(){
    char niz[2];
    niz[0] = pc.getc();
    niz[1] = pc.getc();
    
    return (niz[0]-'0')*10 + niz[1] - '0';
}

void iskljuci(){
    ledice[0] = 1;
    ledice[1] = 1;
    ledice[2] = 1;    
}

void ispisuj(){
    i++;
    pc.printf("Ocitavam %d. mjerenje: %.3f \n", i , tsi.readPercentage());
}
void procitajZnak(){
    switch(pc.getc())
    {
       //Pocinje mjerenje
       case'P':
            ticker.attach(ispisuj,1.0);
            break;
        //Zaustavlja mjerenje
        case'Z':
            ticker.detach();
            i = 0;
            break;
       //Upali plavu
       case'B':
        iskljuci();
            ledice[2] = 1.0 - uzmiBroj()/100.0;
            break;
       //Upali zelenu
       case'G':
            iskljuci();
            ledice[1] = 1.0 - uzmiBroj()/100.0;
             break;
       //Upali crvenu
       case'R':
            iskljuci();
            ledice[0] = 1.0 - uzmiBroj()/100.0;
            break;
        
        
    }   
}
 
int main() {    
    ledice[0] = 1;
    ledice[1] = 1;
    ledice[2] = 1;   
    
    while(1){
        procitajZnak();
    }
}