#include "mbed.h"
#include "N5110.h"
#define dp23 P0_0
#include <string>

DigitalOut enable (dp14);
Timer t;

int modigre=0;  //0 regularno, 1 meni
InterruptIn taster2(dp1); //za pauzu
AnalogIn VRx(dp11);    //izlaz za x potenciometar(dzojstik)
AnalogIn VRy(dp10); //izlaz za y potenciometar (dzojstik)
InterruptIn SW(dp9);      //interni taster dzojstika
Serial pc(USBTX,USBRX);

//sirina display-a je 84x48
N5110 lcd(dp4,dp24,dp23,dp25,dp2,dp6,dp18);   //deklaracija pinova za display

int xTrenutne=0;        //horizontalna koordinata
int yTrenutne=0;        //vertikalna koordinata
int mapa[8][14]= {
    {0,0,1,1,1,1,1,1,0,0,1,0,0,0},
    {0,0,1,1,1,1,0,0,0,0,1,0,0,0},
    {0,1,0,0,0,0,0,1,0,0,1,0,0,0},
    {0,1,0,0,0,0,0,1,0,0,1,0,0,0},
    {0,1,1,1,1,0,0,0,0,0,0,0,1,1},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,1,1,0,0,0,1,0,0,0,0},
    {0,0,0,1,1,1,0,0,0,1,0,0,0,0}
};

int brojPromasaja=0;
int brojPoteza=0;
int brojPogodaka=0; //kao highscore
int opcija=1;
int highscores[5]={31,33,35,36,40};

//funkcija za iscrtavanje ploce 14x8 kvadratica na displayu
void iscrtajMrezu()
{
    for(int x=0; x<84; x++) {
        for(int y=0; y<48; y++) {
            if((x==0 || x%6!=0) && y%6==0) {
                lcd.setPixel(x,y);
            }

            else if (x%6==0)  {
                lcd.setPixel(x,y);
            }
        }

    }
    lcd.refresh();
}


void promijeniMod()
{
    if(t.read_ms()>400)
    {
        lcd.clear();
    if(modigre==0) modigre=1;
    else if(modigre==1) modigre=0;
    }
    
    t.reset();
}


void iscrtajPlusic(int x, int y)
{
    for(int j=1; j<6; j++)
        for(int i=1; i<6; i++) {
            if(i==3 or j==3)
                lcd.setPixel(x+i,y+j);
        }
    lcd.refresh();
}

void obrisiPlusic(int x , int y)
{
    for(int j=1; j<6; j++)
        for(int i=1; i<6; i++) {
            if(i==3 or j==3)
                lcd.clearPixel(x+i,y+j);
        }
    lcd.refresh();
}


int daLiJePogodak (int red, int kolona)
{
    //vracat ce 0 za nepostavljeno, 1 za postavljeno, 2 za vec pogodjeno i 3 za nepogodjeno(a gadjano)

    return mapa[red][kolona];
}

void pogodak(int x, int y)
{
    for(int j=1; j<6; j++) {
        for(int i=1; i<6; i++) {
            lcd.setPixel(x+i,y+j);
        }
    }
    lcd.refresh();
}

void promasaj (int x, int y)
{
    for(int j=1; j<6; j++)
        for(int i=1; i<6; i++) {
            if(i==j || j==6-i)
                lcd.setPixel(x+i,y+j);
        }

    lcd.refresh();
}

void vratiMapu()
{ 
    iscrtajMrezu();
    for(int i=0; i<8; i++) {
        for(int j=0; j<14; j++) {
            if(mapa[i][j]==2)pogodak(6*j,6*i);
            else if(mapa[i][j]==3)promasaj(6*j,6*i);
            else continue;
        }
    }
    lcd.refresh();

}

void prikaziMapu()        //funkcija za peek
{
    lcd.clear();
    iscrtajMrezu();
    for(int i=0; i<8; i++) {
        for(int j=0; j<14; j++) {
            if(mapa[i][j]==1 || mapa[i][j]==2) pogodak(6*j,6*i);
            else continue;
        }
    }
    lcd.refresh();
    wait(5);
    opcija=1;
    lcd.clear();
    modigre=0;
}

void highscore()
{
    lcd.clear();
    
    lcd.printString("1.",0,0);
    char sc[4];
    snprintf(sc, sizeof sc, "%d", highscores[0]);
    lcd.printString(sc,20,0);
    
    lcd.printString("2.",0,1);
    snprintf(sc, sizeof sc, "%d", highscores[1]);
    lcd.printString(sc,20,1);
    
    lcd.printString("3.",0,2);
    snprintf(sc, sizeof sc, "%d", highscores[2]);
    lcd.printString(sc,20,2);
    
    lcd.printString("4.",0,3);
    snprintf(sc, sizeof sc, "%d", highscores[3]);
    lcd.printString(sc,20,3);
        
    lcd.printString("5.",0,4);
    snprintf(sc, sizeof sc, "%d", highscores[4]);
    lcd.printString(sc,20,4);
    
    lcd.refresh();
    wait(5);
    opcija=1;
}

void noviHighscore()
{
    if(brojPogodaka==31)
    {
    if(brojPoteza<highscores[4] && brojPoteza>=highscores[3])
    {
        lcd.printString("Cestitamo, 5.",0,3);
        lcd.printString(" ste!",0,4);
        highscores[4]=brojPoteza;
    }
    
    else if(brojPoteza<highscores[3] && brojPoteza>=highscores[2])
    {
        lcd.printString("Cestitamo, 4.",0,3);
        lcd.printString(" ste!",0,4);
        highscores[4]=highscores[3];
        highscores[3]=brojPoteza;
    }
    
    else if(brojPoteza<highscores[2] && brojPoteza>=highscores[1])
    {
       lcd.printString("Cestitamo, 3.",0,3);
        lcd.printString(" ste!",0,4);
        highscores[4]=highscores[3];
        highscores[3]=highscores[2];
        highscores[2]=brojPoteza;
    }
    
    else if(brojPoteza<highscores[1] && brojPoteza>=highscores[0])
    {
        lcd.printString("Cestitamo, 2.",0,3);
        lcd.printString(" ste!",0,4);
        highscores[4]=highscores[3];
        highscores[3]=highscores[2];
        highscores[2]=highscores[1];
        highscores[1]=brojPoteza;
    }
    
    else if(brojPoteza<highscores[0])
    {
        lcd.printString("Cestitamo, 1.",0,3);
        lcd.printString(" ste!",0,4);
        highscores[4]=highscores[3];
        highscores[3]=highscores[2];
        highscores[2]=highscores[1];
        highscores[1]=highscores[0];
        highscores[0]=brojPoteza;
    }}
    
    else return;
}

  

void pomjeriStrelicu()
{
  if(opcija==1) {lcd.printString("->",2,0);}
  else if(opcija==2) {lcd.printString("->",2,1);}
  else if(opcija==3) {lcd.printString("->",2,2);}
  else if(opcija==4) {lcd.printString("->",2,3);}
  lcd.refresh();
  }
  
void ocitajJoystickMeni()
{
    if(VRy > 2.0/3.0) {
            if(opcija==4)opcija=1;
            else opcija++;
        } 
        
    else if(VRy < 1.0/3.0) {
            if(opcija==1)opcija=4;
            else opcija--;
        } 
        
        pomjeriStrelicu();
        
        
    }

void novaIgra()
{
    lcd.clear();
    brojPoteza=0;
    brojPogodaka=0;
    brojPromasaja=0;

    for(int i=0; i<8; i++)
        for(int j=0; j<14; j++) {
            if(mapa[i][j]==2) mapa[i][j]=1;
            else if(mapa[i][j]==3) mapa[i][j]=0;
        }
        modigre=0;
}
  //funkcija za kraj igre
void krajIgre()
{
    lcd.clear();
    lcd.printString("KRAJ",15,0);
    lcd.printString("SCORE: ",2,1);

    char potezi[4];
    snprintf(potezi, sizeof potezi, "%d", brojPoteza);
    lcd.printString(potezi,50,1);
    
    noviHighscore();
    
    lcd.refresh();
    wait(5);
    novaIgra();
}

void odaberiOpciju()
{    
    if(t.read_ms()>400) 
    {
        if(opcija==1) {
            novaIgra();
        } 
        
        else if(opcija==2)  highscore();


        else if(opcija==3)
        {
            krajIgre();
            modigre=0;
        }

        else if(opcija==4) prikaziMapu();
    }
        
        t.reset();   

}


void meni()
{
        lcd.clear();
        lcd.printString("  NI",10,0);
        lcd.printString("  HS",10,1);
        lcd.printString("  KRAJ",10,2);
        lcd.printString("  PEEK",10,3);
        lcd.printString("SCORE:",10,5);
        char potezi[4];
        snprintf(potezi, sizeof potezi, "%d", brojPoteza);
        lcd.printString(potezi,50,5);
    }
    

void gadjaj()
{
    if(t.read_ms()>500) {
        int p=daLiJePogodak(yTrenutne/6,xTrenutne/6);

        if(p==0) {
            //obrisiPlusic(xTrenutne,yTrenutne);
            promasaj(xTrenutne,yTrenutne);
            mapa[yTrenutne/6][xTrenutne/6]=3;
            brojPromasaja++;
            brojPoteza++;
        }

        else if(p==1) {
            //obrisiPlusic(xTrenutne,yTrenutne);
            pogodak(xTrenutne,yTrenutne);
            obrisiPlusic(xTrenutne,yTrenutne);
            mapa[yTrenutne/6][xTrenutne/6]=2;
            brojPogodaka++;
            brojPoteza++;
        }

        t.reset();
    }
}
    

void ocitajJoystick()
{
    if(VRx > 2.0/3.0) {     //za ocitanje pomjeranja desno
        if(xTrenutne == 78) return;
        else {
            if(mapa[yTrenutne/6][xTrenutne/6]==0 || mapa[yTrenutne/6][xTrenutne/6]==1)
                obrisiPlusic(xTrenutne,yTrenutne);
                else  if(mapa[yTrenutne/6][xTrenutne/6]==2){iscrtajPlusic(xTrenutne,yTrenutne);}
                else if(mapa[yTrenutne/6][xTrenutne/6]==3 ){obrisiPlusic(xTrenutne,yTrenutne);  promasaj(xTrenutne,yTrenutne);}
                
            xTrenutne+=6;
        }
    }
    if(VRx < 1.0/3.0) {     //za pomjeranje lijevo
        if(xTrenutne == 0) return;
        else {
            if(mapa[yTrenutne/6][xTrenutne/6]==0 || mapa[yTrenutne/6][xTrenutne/6]==1)
                obrisiPlusic(xTrenutne,yTrenutne);
                else  if(mapa[yTrenutne/6][xTrenutne/6]==2){iscrtajPlusic(xTrenutne,yTrenutne);}
                else if(mapa[yTrenutne/6][xTrenutne/6]==3 ){obrisiPlusic(xTrenutne,yTrenutne);  promasaj(xTrenutne,yTrenutne);}
            xTrenutne-=6;
        }
    }

    if(VRy > 2.0/3.0) {     //za pomjeranje gore
        if(yTrenutne == 42) return;
        else {
            if(mapa[yTrenutne/6][xTrenutne/6]==0 || mapa[yTrenutne/6][xTrenutne/6]==1)
                obrisiPlusic(xTrenutne,yTrenutne);
                else  if(mapa[yTrenutne/6][xTrenutne/6]==2){iscrtajPlusic(xTrenutne,yTrenutne);}
                 else if(mapa[yTrenutne/6][xTrenutne/6]==3 ){obrisiPlusic(xTrenutne,yTrenutne);  promasaj(xTrenutne,yTrenutne);}
            yTrenutne+=6;
        }
    }
    if(VRy < 1.0/3.0) {     //za pomjeranje dole
        if(yTrenutne == 0) return;
        else {
            if(mapa[yTrenutne/6][xTrenutne/6]==0 || mapa[yTrenutne/6][xTrenutne/6]==1)
                obrisiPlusic(xTrenutne,yTrenutne);
                else  if(mapa[yTrenutne/6][xTrenutne/6]==2){iscrtajPlusic(xTrenutne,yTrenutne);}
                 else if(mapa[yTrenutne/6][xTrenutne/6]==3 ){obrisiPlusic(xTrenutne,yTrenutne);  promasaj(xTrenutne,yTrenutne);}
            yTrenutne-=6;
        }
    }
}

/*void prikaziScore()
{

    lcd.printString("Vas dosadasnji broj poteza je:",0,0);
    char potezi[4];
    snprintf(potezi, sizeof potezi, "%d", brojPoteza);

    lcd.printString(potezi,70,0);

    lcd.printString("Od toga broj pogodjenih dijelova broda(od 31):",0,1);

    char pogodaka[3];
    snprintf(pogodaka, sizeof pogodaka, "%d", brojPogodaka);

}*/

void meniIligadjaj()
{
    if(t.read_ms()>400)
    {
        if(modigre==0) gadjaj();
        else if(modigre==1) odaberiOpciju();
    }
    
    t.reset();
}

int main()
{
    SW.mode(PullUp);
    enable=1;
    lcd.init();
    t.start();
    
    //dodati dio za serijsko citanje matrice sa aplikacije
    
    taster2.rise(&promijeniMod);
    SW.rise(&meniIligadjaj);
    modigre=0;
    
    while(1)
    {
        //char matrica[112];
        
        for(int i=0; i<112;i++)
        //if(pc.readable()) matrica[i]=pc.getc();
        
        if (modigre==0) {
            //iscrtajMrezu();
            vratiMapu();
            ocitajJoystick();
            iscrtajPlusic(xTrenutne,yTrenutne);
        } 
        
        else if (modigre==1) {
            meni();
            ocitajJoystickMeni();
            wait(0.1);
        }
        
      }  
    }
