#include "mbed.h"
#include "N5110.h"
#include "vector"
#include "math.h"
#define stupnjevi 0.0122718

AnalogIn senzor(PTC2);
Serial pc(USBTX, USBRX);
BusOut motor(PTB3, PTB2, PTB1, PTB0);
//N5110::N5110(PWR, CE,    RST,  DC,  MOSI,  CLK, LED)
N5110 lcd (PTA5, PTA12, PTD4, PTA4, PTC6, PTC5, PTC8);

// koeficijenti kvadratne jednadzbe gdje je aa = a * a ...
double b = 0.0767230595885;
double bb = b*b;
double a =  0.000477315282116;
double aa = 2*a;
double aaaa = 4*a;
double c = 3.86108667055;

int smijer = 1;
int korak = 1;
int brzina = 5000;
short int y, x;
static bool radi = false;
// klasa za rad sa tockama 
struct tacka
{
    short int x, y;

};
int referentnaTacka = 0, broj = 0, granica = 512, predznak = 1, zeljeniUgao = -1; 
// PRAVA KROZ 2 TACKE : TACKA (0,0) I TACKA IZ VEKTORA

tacka kruznica[512];
short int brojacK = 0; 

tacka zadnjeTacke[5];
short int tacke = 0; 
bool unesenUgao = false;
void ispisiUdaljenost(int udaljenost) {
    
    char udaljen[2];
    udaljen[0] = int(udaljenost/10) + '0';
    udaljen[1] = int(udaljenost)%10 + '0';
    lcd.printChar(udaljen[0], 0, 4);
    lcd.printChar(udaljen[1], 4, 4);
}

void ispisiKut(int kut)
{
    char ugao[3];
    ugao[0] = int(kut/100) + '0';
    ugao[1] = int(kut/10)%10 + '0';
    ugao[2] = (int(kut)%100)%10 + '0';
    lcd.printChar(ugao[0], 0,5);
    lcd.printChar(ugao[1], 4,5);
    lcd.printChar(ugao[2], 9,5); 
}

void skeniraj(double kut) 
{

    double srednjaVrijednost = 0; 
    for(int i = 0; i < 15; i++) 
    { 
        srednjaVrijednost += senzor*3.3; wait_us(500);
    }
    srednjaVrijednost /= 15;
    
    double udaljenost = (b - sqrt(bb - aaaa * (c - srednjaVrijednost)))/aa +10; //mjerenje udaljenosti (vjerojatno je presporo)


    if(udaljenost > 80) udaljenost = 80;    //radar nam treba prikazivati predmete na udaljenosti od 10cm do 80cm
    if(udaljenost < 10) udaljenost = 10;    //pa se ovdje ogranicavamo kako ne bi doslo do ludih vrijednosti
    
    //pc.printf("Kut: %.2f\n", kut * stupnjevi );
    y = int(sin(kut * stupnjevi) * udaljenost * 0.2875) + 23;  //(23 piksela)/(80 cm)
    x = int(cos(kut * stupnjevi) * udaljenost * 0.2875) + 60;

    zadnjeTacke[tacke].x = x;
    zadnjeTacke[tacke].y = y;
    tacke++; 
    if(tacke == 5) tacke = 0; 
    lcd.setPixel(x, y); 
    lcd.refresh();
    
    
    ispisiUdaljenost(udaljenost);
    ispisiKut(kut*0.703125);

    wait(0.05);
}

void motorcina(int brzina, int smijer) //funkcija za rotaciju motora
{

    if(smijer == 1) 
    {
        for (int i = 0; i < korak; i++)
            for(int j = 0; j < 8; j++) 
            {
                if(j == 0) motor = 1;
                if(j == 1) motor = 3;
                if(j == 2) motor = 2;
                if(j == 3) motor = 6;
                if(j == 4) motor = 4;
                if(j == 5) motor = 12;
                if(j == 6) motor = 8;
                if(j == 7) motor = 9;
                wait_us(brzina);
            }
    } 
    else 
    {
        for(int i = 0; i < korak; i++)
            for(int j = 7; j >= 0; j--) 
            {
                if(j == 0) motor = 1;
                if(j == 1) motor = 3;
                if(j == 2) motor = 2;
                if(j == 3) motor = 6;
                if(j == 4) motor = 4;
                if(j == 5) motor = 12;
                if(j == 6) motor = 8;
                if(j == 7) motor = 9;
                wait_us(brzina);
            }
    }
}

void iscrtajKruznicu()  //funkcija koja iscrtava kruznicu
{
    lcd.clear();
    for(short int i = 0; i <512; i++) {
        lcd.setPixel(kruznica[i].x, kruznica[i].y);
        lcd.refresh();
    }
}

void formirajKruznicu() //funkcija koja trazi tocke kruznice (centar (60, 23))
{
    for(double kut(0); kut<512; kut++)
    {

        y = int(sin(kut * stupnjevi) * 23) + 23;  //(23 piksela)/(80 cm)
        x = int(cos(kut * stupnjevi) * 23) + 60;
        
        kruznica[brojacK].x = x;
        kruznica[brojacK].y = y; 
        brojacK++; 
    }
    brojacK = 0; 
}

void getCommand()
{
    if(pc.readable()) {
        char c = pc.getc();
        
        /*if(c == 'x' || c == 'X') 
        {
            radi = false;
            brzina = 10000;
            smijer = 0;
            referentnaTacka = 0;
            broj = 0;
            granica = 512;
            predznak = 1;
            zeljeniUgao = -1; 
        } 
*/
        if (c == 'l' || c == 'L')
        {
                smijer = 1;
                pc.printf("Motor se okrece u smijeru kazaljke na satu.\n");
                //korak = -korak;
                referentnaTacka = broj; 
                predznak = 1;
                            radi = true;
        }
    
        else if(c == 'd' || c == 'D')   
        {
            smijer = 0;
            pc.printf("Motor se okrece u smijeru suprotnom od kazaljke na satu\n");
            referentnaTacka = broj; 
            predznak = -1;
            radi = true;

        }

        else if(c == '1') 
        {
            radi = true;
        } 

        else if(c == '0')
        {
            radi = false;
        }

        else if (c == 'k' || c == 'K')  
        {
            pc.printf("Korak motora je: %d\n", korak);
            pc.printf("Unesite novi korak motora (maksimalno 10 i formata CC): ");
            char d = pc.getc();
            char j = pc.getc();
            korak = (d-'0')*10 + (j-'0');
            
            if(korak < 1 && korak > 11)
            {
                pc.printf("Vrijednost koraka motora nije ispravno unesena. Unesite ponovo.\n");
                pc.printf("Unesite novi korak motora (maksimalno 10): ");
                pc.scanf("%d", &korak);
            }
        }
        else if(c == 'u' || c == 'U')
        {
            pc.printf("Unesite zeljeni ugao (u granicama od 0 do 360 formata CCC): ");
            char s = pc.getc();
            char d = pc.getc(); 
            char j = pc.getc(); 
            zeljeniUgao = (s - '0')*100 + (d - '0') * 10 + (j - '0');
            unesenUgao = true;
            //radi = false; 
        }
        else if (c == 'b' || c == 'B')  
        {
            
            pc.printf("Trenutna brzina motora je: %d\n", brzina);
            pc.printf("Nova brzina motora (u formatu CCCC): ");
            here: 
            char h = pc.getc();
            char s = pc.getc();
            char d = pc.getc(); 
            char j = pc.getc();
            brzina = (h - '0')*1000 + (s - '0')*100 + (d- '0') * 10 + (j - '0');
            pc.printf("Nova brzina: %d", brzina);
            if(brzina < 1000)
            {
                pc.printf("Brzina motora mora biti veca od 999! Unesite ponovo brzinu.\n");
                pc.printf("Nova brzina morora je: ");
                goto here;
            }        
        }
    }
}
void pomjeriZaUgao()    
{
    referentnaTacka = broj;
    for(broj = referentnaTacka;radi && unesenUgao && (broj < zeljeniUgao*1.0/stupnjevi && broj >= 0); broj += korak * predznak)
    {
        lcd.drawLine(60, 23, kruznica[broj].x, kruznica[broj].y, 1);
        motorcina(1000, smijer);
        skeniraj(broj * korak);
        lcd.drawLine(60, 23, kruznica[broj].x, kruznica[broj].y, 0);
        lcd.setPixel(kruznica[broj].x, kruznica[broj].y);
        for(int a = 0; a < 5; a++) lcd.setPixel(zadnjeTacke[a].x, zadnjeTacke[a].y); 
        lcd.refresh();
    }
    radi = false;
    unesenUgao = false; 
}

int main()
{
    lcd.init();
    formirajKruznicu();
    iscrtajKruznicu();  
    pc.attach(&getCommand);
    

    pc.printf("Tipka 1 - Pokreni motor\n");
    pc.printf("Tipka 0 - Zaustavi motor\n");
    pc.printf("Tipka d - Okretanje motora u smijeru kazaljke na satu\n");
    pc.printf("Tipka l - Okretanje motora u smijeru suprotnom od smijera kazaljke na satu\n");
    pc.printf("Tipka b - Promijeni brzinu\n");
    pc.printf("Tipka u - Skeniraj za zadani ugao");
    while(1) {

             //ovo radimo samo da bismo imali neku kontrolu nad motorom
        
            //for(broj = referentnaTacka; broj>=0 )
            //if (smijer != 0)
            
                for(broj = referentnaTacka;radi && (broj < 512 && broj >= 0); broj += korak * predznak)
                {
                    lcd.drawLine(60, 23, kruznica[broj].x, kruznica[broj].y, 1);
                    motorcina(brzina, smijer);
                    skeniraj(broj * korak);
                    lcd.drawLine(60, 23, kruznica[broj].x, kruznica[broj].y, 0);
                    lcd.setPixel(kruznica[broj].x, kruznica[broj].y);
                    for(int a = 0; a < 5; a++) lcd.setPixel(zadnjeTacke[a].x, zadnjeTacke[a].y); 
                    lcd.refresh();
                    //pc.printf("%d\n", broj);
                if(unesenUgao) pomjeriZaUgao();
                }
                if(broj < 0) referentnaTacka=511;
                if(broj >= 511) referentnaTacka = 0;
            }
    }
