#include "mbed.h"
#include "N5110.h"

#define dp23 P0_0

//kada posmatramo segment vodoravno
#define SIRINA 11
#define VISINA 5

//ref. koordinata cifre je krajnji lijevi piksel gornjeg segmenta
//definisemo i za svaku cifru
#define xPrva 5
#define xDruga 24
#define xTreca 48
#define xCetvrta 67
#define yCifra 7

int xTrenutnaCifra = 67;

//Nokia displej
N5110 display(dp4,dp26,dp23,dp25,dp2,dp6,dp18);     //dp24(pwmout) s dp26

//Džojstik
AnalogIn VRx(dp11);
AnalogIn VRy(dp10);

//digitalni izlaz za aktivaciju LED buffera
DigitalOut enable (dp14);

InterruptIn taster1(dp1);
PwmOut buzz(dp24);                                               //STAVITI NOVI PIN, UMJESTO DP1, novi oslobodjeni pin
Timer tVrijeme;         //debounce kada je taster pritisnut
Timer modTimer;              // pomaže da oderedimo mod rada
Timer tDzojstik;
bool tasterP = false;   //da li je taster pritisnut, pomocu nje cemo manipulirati ulazom i izlazom iz nekog moda
bool vrijemeMod = false;//oznacavamo da li smo u nekom modu
bool alarmMod = false;
Ticker dvotacka;        //prikaz dvotacke
Ticker talarm;          //attachat ce se funkcija alarm, pozivati svaku sekundu u minuti u kojoj je aktivan alarm
bool alarmInverse = false;  //varijabla pomocu koje prebacujemo sa normal na inverse mode displaya
bool dvoTacka = false;  //varijabla pomocu koje ili ispisujemo ili brisemo dvotacku
static int prviBroj;    //varijable u kojima se nalazi trenutno vrijeme
static int drugiBroj;
static int treciBroj;
static int cetvrtiBroj;
static int prviAlarm;   //varijable u kojima se nalazi vrijeme namjestenog alarma
static int drugiAlarm;
static int treciAlarm;
static int cetvrtiAlarm;
Ticker mjeri;           //pomocu njega cemo mjeriti vrijeme
Ticker blinkanje;      //omogućava da cifra blinka u alarm i vrijeme modu
bool blink = false;


//funkcije za iscrtavanje segmenata
void crtajLinijuDesno(int x, int y, int duzina)
{
    for(int i = x; i <= x + duzina; i++) {
        display.setPixel(i,y);
    }
}

void crtajLinijuDolje(int x, int y, int duzina)
{
    for(int i = y; i <= y + duzina; i++) {
        display.setPixel(x,i);
    }
}

void segmentVodoravno(int x, int y)
{
    crtajLinijuDesno(x+2, y-2, SIRINA-4);
    crtajLinijuDesno(x+1, y-1, SIRINA-2);
    crtajLinijuDesno(x, y, SIRINA);
    crtajLinijuDesno(x+1, y+1 ,SIRINA-2);
    crtajLinijuDesno(x+2, y+2 ,SIRINA-4);
}

void segmentUspravno(int x, int y)
{
    crtajLinijuDolje(x-2, y+2, SIRINA-4);
    crtajLinijuDolje(x-1, y+1, SIRINA-2);
    crtajLinijuDolje(x, y, SIRINA);
    crtajLinijuDolje(x+1, y+1 ,SIRINA-2);
    crtajLinijuDolje(x+2, y+2 ,SIRINA-4);
}

//funkcija za iscrtavanje dvotacke
void crtajDvotacku()
{
    if(!dvoTacka) {
        for(int i = 41; i < 43; i++) {
            for(int j = 16; j < 25; j++) {
                if(j < 18 || j > 22)
                    display.setPixel(i,j);
                display.refresh();
            }
        }
        dvoTacka = true;
    } else if(dvoTacka) {
        for(int i = 41; i < 43; i++) {
            for(int j = 16; j < 25; j++) {
                if(j < 18 || j > 22)
                    display.clearPixel(i,j);
                display.refresh();
            }
        }
        dvoTacka = false;
    }
}

//funkcije koje iscrtavaju određeni broj pomoću segmenata
void crtajNula(int x, int y)
{
    segmentVodoravno(x,y); //gornji
    segmentVodoravno(x, y + 26); //donji
    segmentUspravno(x-1, y+1); //gornji lijevi
    segmentUspravno(x-1, y+14); //donji lijevi
    segmentUspravno(x+12, y+1);  //gornji desni
    segmentUspravno(x+12, y+14); //donji desni
}

void crtajJedan(int x, int y)
{
    segmentUspravno(x+12, y+1);  //gornji desni
    segmentUspravno(x+12, y+14); //donji desni
}

void crtajDva(int x, int y)
{
    segmentVodoravno(x, y); //gornji
    segmentVodoravno(x, y + 26); //donji
    segmentUspravno(x-1, y+14); //donji lijevi
    segmentUspravno(x+12, y+1);  //gornji desni
    segmentVodoravno(x, y+13); //srednji
}

void crtajTri(int x, int y)
{
    segmentVodoravno(x, y); //gornji
    segmentVodoravno(x, y + 26); //donji
    segmentUspravno(x+12, y+1);  //gornji desni
    segmentUspravno(x+12, y+14); //donji desni
    segmentVodoravno(x, y+13); //srednji
}

void crtajCetiri(int x, int y)
{
    segmentUspravno(x-1, y+1); //gornji lijevi
    segmentUspravno(x+12, y+1);  //gornji desni
    segmentUspravno(x+12, y+14); //donji desni
    segmentVodoravno(x, y+13); //srednji
}

void crtajPet(int x, int y)
{
    segmentVodoravno(x, y); //gornji
    segmentVodoravno(x, y + 26); //donji
    segmentVodoravno(x, y+13); //srednji
    segmentUspravno(x-1, y+1); //gornji lijevi
    segmentUspravno(x+12, y+14); //donji desni
}

void crtajSest(int x, int y)
{
    segmentVodoravno(x, y); //gornji
    segmentVodoravno(x, y + 26); //donji
    segmentVodoravno(x, y+13); //srednji
    segmentUspravno(x-1, y+1); //gornji lijevi
    segmentUspravno(x-1, y+14); //donji lijevi
    segmentUspravno(x+12, y+14); //donji desni
}

void crtajSedam(int x, int y)
{
    segmentVodoravno(x, y); //gornji
    segmentUspravno(x+12, y+1);  //gornji desni
    segmentUspravno(x+12, y+14); //donji desni
}

void crtajOsam(int x, int y)
{
    segmentVodoravno(x,y); //gornji
    segmentVodoravno(x, y+13); //srednji
    segmentVodoravno(x, y + 26); //donji
    segmentUspravno(x-1, y+1); //gornji lijevi
    segmentUspravno(x-1, y+14); //donji lijevi
    segmentUspravno(x+12, y+1);  //gornji desni
    segmentUspravno(x+12, y+14); //donji desni
}

void crtajDevet(int x, int y)
{
    segmentVodoravno(x,y); //gornji
    segmentVodoravno(x, y+13); //srednji
    segmentVodoravno(x, y + 26); //donji
    segmentUspravno(x-1, y+1); //gornji lijevi
    segmentUspravno(x+12, y+1);  //gornji desni
    segmentUspravno(x+12, y+14); //donji desni
}

//funkcije koje brisu broj na trenutnoj cifri
void brisiLinijuDesno(int x, int y, int duzina)
{
    for(int i = x; i <= x + duzina; i++) {
        display.clearPixel(i,y);
    }
}

void brisiLinijuDolje(int x, int y, int duzina)
{
    for(int i = y; i <= y + duzina; i++) {
        display.clearPixel(x,i);
    }
}

void segmentVodoravnoBrisi(int x, int y)
{
    brisiLinijuDesno(x+2, y-2, SIRINA-4);
    brisiLinijuDesno(x+1, y-1, SIRINA-2);
    brisiLinijuDesno(x, y, SIRINA);
    brisiLinijuDesno(x+1, y+1 ,SIRINA-2);
    brisiLinijuDesno(x+2, y+2 ,SIRINA-4);
}

void segmentUspravnoBrisi(int x, int y)
{
    brisiLinijuDolje(x-2, y+2, SIRINA-4);
    brisiLinijuDolje(x-1, y+1, SIRINA-2);
    brisiLinijuDolje(x, y, SIRINA);
    brisiLinijuDolje(x+1, y+1 ,SIRINA-2);
    brisiLinijuDolje(x+2, y+2 ,SIRINA-4);
}

void brisi(int x, int y)
{
    segmentVodoravnoBrisi(x,y); //gornji
    segmentVodoravnoBrisi(x, y+13); //srednji
    segmentVodoravnoBrisi(x, y + 26); //donji
    segmentUspravnoBrisi(x-1, y+1); //gornji lijevi
    segmentUspravnoBrisi(x-1, y+14); //donji lijevi
    segmentUspravnoBrisi(x+12, y+1);  //gornji desni
    segmentUspravnoBrisi(x+12, y+14); //donji desni
}

void ispisiPom(int broj, int pozicija)
{
    switch(broj) {
        case 0:
            crtajNula(pozicija, yCifra);
            break;
        case 1:
            crtajJedan(pozicija, yCifra);
            break;
        case 2:
            crtajDva(pozicija, yCifra);
            break;
        case 3:
            crtajTri(pozicija, yCifra);
            break;
        case 4:
            crtajCetiri(pozicija, yCifra);
            break;
        case 5:
            crtajPet(pozicija, yCifra);
            break;
        case 6:
            crtajSest(pozicija, yCifra);
            break;
        case 7:
            crtajSedam(pozicija, yCifra);
            break;
        case 8:
            crtajOsam(pozicija, yCifra);
            break;
        case 9:
            crtajDevet(pozicija, yCifra);
    }
}


//funkcija upravljanja dzojstikom za vrijemeMod
void dzojstikVrijeme()
{
    if(tDzojstik.read()<0.5) return;
    if (VRx<1.0/3.0) {      //&& VRy>1.0/3.0 && VRy<2.0/3.0
        switch(xTrenutnaCifra) {
            case 67:
                xTrenutnaCifra = 48;
                break;
            case 48:
                xTrenutnaCifra = 24;
                break;
            case 24:
                xTrenutnaCifra = 5;
                break;
            case 5:
                break;
        }
    } else if (VRx>2.0/3.0) {       //&& VRy>1.0/3.0 && VRy<2.0/3.0
        switch(xTrenutnaCifra) {
            case 5:
                xTrenutnaCifra = 24;
                break;
            case 24:
                xTrenutnaCifra = 48;
                break;
            case 48:
                xTrenutnaCifra = 67;
                break;
            case 67:
                break;
        }
    }

    if (VRy<1.0/3.0) {
        switch(xTrenutnaCifra) {
            case 67:
                cetvrtiBroj--;
                if(cetvrtiBroj<0) cetvrtiBroj = 0;
                break;
            case 48:
                treciBroj--;
                if(treciBroj<0) treciBroj = 0;
                break;
            case 24:
                drugiBroj--;
                if(drugiBroj<0) drugiBroj = 0;
                break;
            case 5:
                prviBroj--;
                if(prviBroj<0) prviBroj = 0;
        }

    } else if (VRy>2.0/3.0) {
        switch(xTrenutnaCifra) {
            case 67:
                cetvrtiBroj++;
                if(cetvrtiBroj>9) cetvrtiBroj = 9;
                break;
            case 48:
                treciBroj++;
                if(treciBroj>5) treciBroj = 5;
                break;
            case 24:
                drugiBroj++;
                if(prviBroj == 2 && drugiBroj>3) drugiBroj = 3;
                if(drugiBroj>9) drugiBroj = 9;
                break;
            case 5:
                prviBroj++;
                if(drugiBroj>3 && prviBroj>1) prviBroj = 1;
                if(prviBroj>2) prviBroj = 2;
        }
    }
    tDzojstik.reset();
    tDzojstik.start();
}

//funkcija upravljanja dzojstikom za alarmMod

void dzojstikAlarm()
{
    if(tDzojstik.read()<0.5) return;
    if (VRx<1.0/3.0) {
        switch(xTrenutnaCifra) {
            case 67:
                xTrenutnaCifra = 48;
                break;
            case 48:
                xTrenutnaCifra = 24;
                break;
            case 24:
                xTrenutnaCifra = 5;
                break;
            case 5:
                break;
        }
    } else if (VRx>2.0/3.0) {
        switch(xTrenutnaCifra) {
            case 5:
                xTrenutnaCifra = 24;
                break;
            case 24:
                xTrenutnaCifra = 48;
                break;
            case 48:
                xTrenutnaCifra = 67;
                break;
            case 67:
                break;
        }
    }

    if (VRy<1.0/3.0) {
        switch(xTrenutnaCifra) {
            case 67:
                cetvrtiAlarm--;
                if(cetvrtiAlarm<0) cetvrtiAlarm = 0;
                break;
            case 48:
                treciAlarm--;
                if(treciAlarm<0) treciAlarm = 0;
                break;
            case 24:
                drugiAlarm--;
                if(drugiAlarm<0) drugiAlarm = 0;
                break;
            case 5:
                prviAlarm--;
                if(prviAlarm<0) prviAlarm = 0;
        }

    } else if (VRy>2.0/3.0) {
        switch(xTrenutnaCifra) {
            case 67:
                cetvrtiAlarm++;
                if(cetvrtiAlarm>9) cetvrtiAlarm = 9;
                break;
            case 48:
                treciAlarm++;
                if(treciAlarm>5) treciAlarm = 5;
                break;
            case 24:
                drugiAlarm++;
                if(prviAlarm == 2 && drugiAlarm>3) drugiAlarm = 3;
                if(drugiAlarm>9) drugiAlarm = 9;
                break;
            case 5:
                prviAlarm++;
                if(drugiAlarm>3 && prviAlarm>1) prviAlarm = 1;
                if(prviAlarm>2) prviAlarm = 2;
        }
    }
    tDzojstik.reset();
    tDzojstik.start();
}


//prikaz moda
void crtajA()
{
    display.setPixel(40, 30);
    display.setPixel(41, 30);
    display.setPixel(42, 30);
    display.setPixel(40, 31);
    display.setPixel(42, 31);
    display.setPixel(40, 32);
    display.setPixel(41, 32);
    display.setPixel(42, 32);
    display.setPixel(40, 33);
    display.setPixel(42, 33);
    display.setPixel(40, 34);
    display.setPixel(42, 34);
}

void crtajV()
{
    display.setPixel(39, 31);
    display.setPixel(43, 31);
    display.setPixel(39, 32);
    display.setPixel(43, 32);
    display.setPixel(40, 33);
    display.setPixel(42, 33);
    display.setPixel(41, 34);
}

void brisiMod()
{
    for(int i = 39; i < 44; i++)
        for(int j = 30; j < 35; j++)
            display.clearPixel(i, j);
}


void blinkaj()
{
    //vrijeme mod
    if(vrijemeMod && !blink) {
        blink = true;

        switch(xTrenutnaCifra) {
            case 67:
                ispisiPom(cetvrtiBroj, 67);
                break;
            case 48:
                ispisiPom(treciBroj, 48);
                break;
            case 24:
                ispisiPom(drugiBroj, 24);
                break;
            case 5:
                ispisiPom(prviBroj, 5);
        }
    } else if(vrijemeMod && blink) {
        blink = false;

        switch(xTrenutnaCifra) {
            case 67:
                brisi(xCetvrta, yCifra);
                break;
            case 48:
                brisi(xTreca, yCifra);
                break;
            case 24:
                brisi(xDruga, yCifra);
                break;
            case 5:
                brisi(xPrva, yCifra);
        }
    }

    //alarm mod
    if(alarmMod && !blink) {
        blink = true;

        switch(xTrenutnaCifra) {
            case 67:
                ispisiPom(cetvrtiAlarm, 67);
                break;
            case 48:
                ispisiPom(treciAlarm, 48);
                break;
            case 24:
                ispisiPom(drugiAlarm, 24);
                break;
            case 5:
                ispisiPom(prviAlarm, 5);
        }
    } else if(alarmMod && blink) {
        blink = false;

        switch(xTrenutnaCifra) {
            case 67:
                brisi(xCetvrta, yCifra);
                break;
            case 48:
                brisi(xTreca, yCifra);
                break;
            case 24:
                brisi(xDruga, yCifra);
                break;
            case 5:
                brisi(xPrva, yCifra);
        }
    }
}

void odrediMod()
{
    if(modTimer.read()>2 && vrijemeMod == false) {
        alarmMod = true;
        tDzojstik.reset();
        tDzojstik.start();
    } else if(alarmMod == false) {
        vrijemeMod = true;
        tDzojstik.reset();
        tDzojstik.start();
    }
    modTimer.reset();

    if(alarmMod) {
        if(!tasterP) {
            if(tVrijeme.read() > 0.2) { //debouncing
                tVrijeme.reset();
                tasterP = true;
                crtajA();

                prviAlarm = prviBroj;
                drugiAlarm = drugiBroj;
                treciAlarm = treciBroj;
                cetvrtiAlarm = cetvrtiBroj;

                blinkanje.attach(&blinkaj, 1); //atachiramo blinkanje cifre koja se mijenja, povecati interval blinkanja ako bude potrebe
            }
        } else {
            blinkanje.detach();
            tasterP = false;
            alarmMod = false;
            brisiMod();
        }

    }

    else if(vrijemeMod) {
        if(!tasterP) {
            if(tVrijeme.read() > 0.2) { //debouncing
                tVrijeme.reset();
                tasterP = true;
                crtajV();

                blinkanje.attach(&blinkaj, 1); // povecati interval ako bude potrebno
            }
        }

        else {
            blinkanje.detach();
            tasterP = false;
            vrijemeMod = false;
            brisiMod();
        }
    }

}

void tasterPritisnut() // koristimo kao pomoc za određivanje moda
{
    modTimer.start();
}

//funkcija za paljenje alarma
void alarm()
{
    if(!alarmInverse) {
        display.inverseMode();
        buzz = 0.5;
        //podesiti frekvenciju
        alarmInverse = true;
    } else {
        display.normalMode();
        buzz = 0;  //podesiti frekvenciju
        alarmInverse = false;
    }
    display.refresh();
}

//funkcija za mjerenje vremena
void mjeriVrijeme()
{
    cetvrtiBroj++;
    if(cetvrtiBroj>9) {
        cetvrtiBroj = 0;
        treciBroj++;
        if(treciBroj>5) {
            treciBroj = 0;
            drugiBroj++;
            if(drugiBroj>9 || prviBroj == 2 && drugiBroj>3) {
                drugiBroj = 0;
                prviBroj++;
                if(prviBroj>2) {
                    prviBroj = 0;
                }
            }
        }
    }

    if(!alarmMod) {
        brisi(xPrva, yCifra);
        brisi(xDruga, yCifra);
        brisi(xTreca, yCifra);
        brisi(xCetvrta, yCifra);

        ispisiPom(prviBroj, xPrva);
        ispisiPom(drugiBroj, xDruga);
        ispisiPom(treciBroj, xTreca);
        ispisiPom(cetvrtiBroj, xCetvrta);
    }

    if(prviBroj == prviAlarm && drugiBroj == drugiAlarm && treciBroj == treciAlarm && cetvrtiBroj == cetvrtiAlarm) {
        talarm.attach(&alarm, 1);
        prviAlarm = -1;
        drugiAlarm = -1;
        treciAlarm = -1;
        cetvrtiAlarm = -1;
    } else {
        talarm.detach();
        display.normalMode();
        buzz = 0;
    }

    display.refresh();
}

int main()
{
    enable = 1;
    display.init();
    buzz.period_us(500);

    prviAlarm = -1;
    drugiAlarm = -1;
    treciAlarm = -1;
    cetvrtiAlarm = -1;

    //vratiti na nulu kad se zavrsi testiranje
    prviBroj = 1;
    drugiBroj = 9;
    treciBroj = 2;
    cetvrtiBroj = 2;

    ispisiPom(prviBroj, xPrva);
    ispisiPom(drugiBroj, xDruga);
    ispisiPom(treciBroj, xTreca);
    ispisiPom(cetvrtiBroj, xCetvrta);

    tVrijeme.start();
    taster1.rise(&tasterPritisnut);
    taster1.fall(&odrediMod); //ovjde se postavlja funckija za određivanje moda tj. mjericemo vrijeme koje prodje od pritiska tastera do pustanja
    dvotacka.attach(&crtajDvotacku, 1);
    mjeri.attach(&mjeriVrijeme, 60);

    while(1) {
        if(alarmMod) dzojstikAlarm();
        else if(vrijemeMod) dzojstikVrijeme();
    }
}
