#include "mbed.h"
#define dp23 P0_0
#include "N5110.h"
#include "math.h"
#define DUZINA_CHAR 6
#define VISINA_CHAR 8
#define ENTER 13
#define BACKSPACE 8
#define DELETE 127
#define NOVALINIJA 10


InterruptIn SWtaster (dp9);

AnalogIn X (dp11), Y (dp10);


int tackaPostoji=0;
int bafer[84*6];
Serial pc(USBTX,USBRX);

Ticker tikerOcitaj;
DigitalOut enable(dp14);

int funkcija=1;
bool crtaj=false;
N5110 displej (dp4, dp24, dp23, dp25, dp2, dp6, dp18);

int buffer[1];
int korx=24;
int kory=48;
int stariix=korx;
int stariiy=kory;
int kliknutPuta=0;
int cursorX=0;
int cursorY=0;

// enter = 13
// backspace = 08
// delete = 127

Timer dibauns;

double minx=0.2,srednjex= 0.7,maxx= 3, miny=0.3, srednjey=0.6, maxy=3;

void enter();
void karakter(char c);
void backspace();

void karakter(char c)
{
    displej.refresh();
    if(cursorX < 84 - DUZINA_CHAR) {
        displej.printChar(c, cursorX, cursorY);
        cursorX += DUZINA_CHAR;
    } else {
        enter();
        displej.printChar(c, cursorX, cursorY);
        cursorX += DUZINA_CHAR;

    }
    displej.refresh();

}

void enter()
{
    cursorX = 13;
    if(cursorY == 5) cursorY = 0;
    else cursorY++;
}

void deletee()
{
    cursorX = 13;
    cursorY = 0;
    displej.clear();
    displej.refresh();
}

void backspace()
{
    if(cursorX == 0 && cursorY == 0) return;
    if(cursorX == 0) {
        cursorY--;
        cursorX = 83;
    }
    int startX = cursorX - DUZINA_CHAR; //+ 1;
    int startY = VISINA_CHAR * cursorY;
    for(int i = 0; i < VISINA_CHAR; i++)
        for(int j = 0; j < DUZINA_CHAR; j++)
            displej.clearPixel(startX + j, startY + i);

    if(startX < 0) startX = 0;
    cursorX = startX;
    displej.refresh();
}

void iscrtajPocetniEkran()
{

    displej.refresh();


 //   char nizx[]= {4,3,2,1,8,9,9,9,10,11,11,11,11,10,1,1,1,1,2,3,4,4,4,4,3,2,8,8,9,10,11,11,10,9,9,10,9,10,1,1,2,3,4,4,3,2,9,10,8,8,8,8,9,10,9,10,11,11,11,11,2,8,8,8,9,9,11,11,11,11,11,1,1,1,2,2,2,2,2,4,4,4,4,4,8,8,8,9,9,9,10,10,10,11,11,11,1,2,3,3,3,3,3,3,4,5,10,10,10,10,10,10,9,8,11,12,'a'};
  //  char nizy[]= {2,3,4,5,4,1,2,3,2,1,2,3,4,5,10,11,12,13,10,10,10,11,12,13,13,13,11,12,10,10,11,12,13,13,12,12,11,11,19,20,18,18,19,20,21,21,17,17,18,19,20,21,18,18,20,20,18,19,20,21,27,27,28,29,27,29,25,26,27,28,29,36,37,35,33,34,35,36,37,33,34,35,36,37,34,35,36,34,35,36,34,35,36,36,35,34,44,45,46,45,44,43,42,41,45,44,46,45,44,43,42,41,42,43,42,43,'a'};
    for(int i=0; i<48; i++) {

        displej.setPixel(6,i);
        displej.setPixel(13,i);
    }

    for(int i=0; i<14; i++) {
        displej.setPixel(i,7);
        displej.setPixel(i,15);
        displej.setPixel(i,23);
        displej.setPixel(i,31);
        displej.setPixel(i,41);
    }

  /*  for(int i=0;; i++) {

        if(nizx[i]=='a') break;
        displej.setPixel(int(nizx[i]),int(nizy[i]));
    }*/

    displej.refresh();
    
    // x od 0 do 6
    // y od 0 do 7
    //crtanje linije
        displej.setPixel(4,2);
        displej.setPixel(3,3);
        displej.setPixel(2,4);
        displej.setPixel(1,5);

    //x od 7 do 13
    //y od 0 do 7
    //crtanje kose linije
        displej.setPixel(8,4);
        displej.setPixel(9,1);
        displej.setPixel(9,2);
        displej.setPixel(9,3);
        displej.setPixel(10,2);
        displej.setPixel(11,1);
        displej.setPixel(11,2);
        displej.setPixel(11,3);
        displej.setPixel(11,4);
        displej.setPixel(10,5);

    //x od 0 do 6
    //y od 8 do 15
    //crtanje praznog pravougaonika

        displej.setPixel(1,10);
        displej.setPixel(1,11);
        displej.setPixel(1,12);
        displej.setPixel(1,13);
        displej.setPixel(2,10);
        displej.setPixel(3,10);
        displej.setPixel(4,10);
        displej.setPixel(4,11);
        displej.setPixel(4,12);
        displej.setPixel(4,13);
        displej.setPixel(3,13);
        displej.setPixel(2,13);

    //x od 7 do 13
    //y od 8 do 15
    //crtanje a

        displej.setPixel(8,11);
        displej.setPixel(8,12);
        displej.setPixel(9,10);
        displej.setPixel(10,10);
        displej.setPixel(11,11);
        displej.setPixel(11,12);
        displej.setPixel(10,13);
        displej.setPixel(9,13);
        displej.setPixel(9,12);
        displej.setPixel(10,12);
        displej.setPixel(9,11);
        displej.setPixel(10,11);

    //x od 0 do 6
    //y od 16 do 23
    //crtanje kruznice


        displej.setPixel(1,19);
        displej.setPixel(1,20);
        displej.setPixel(2,18);
        displej.setPixel(3,18);
        displej.setPixel(4,19);
        displej.setPixel(4,20);
        displej.setPixel(3,21);
        displej.setPixel(2,21);

    //x od 7 do 13
    //y od 16 do 23
    //iscrtavanje slova A

    displej.setPixel(9,17);
        displej.setPixel(10,17);
        displej.setPixel(8,18);
        displej.setPixel(8,19);
        displej.setPixel(8,20);
        displej.setPixel(8,21);
        displej.setPixel(9,18);
        displej.setPixel(10,18);
        displej.setPixel(9,20);
        displej.setPixel(10,20);
        displej.setPixel(11,18);
        displej.setPixel(11,19);
        displej.setPixel(11,20);
        displej.setPixel(11,21);

    //x od 0 do 6
    //y od 24 do 31
    //iscrtavanje tacke

        displej.setPixel(2,27);

    //x od 7 do 13
    //y od 24 do 31
    //iscrtavanje cl - opcija za brisanje ekrana

        displej.setPixel(8,27);
        displej.setPixel(8,28);
        displej.setPixel(8,29);
        displej.setPixel(9,27);
        displej.setPixel(9,29);
        displej.setPixel(11,25);
        displej.setPixel(11,26);
        displej.setPixel(11,27);
        displej.setPixel(11,28);
        displej.setPixel(11,29);

    //x od 0 do 6
    //y od 32 do 39
    //iscrtavanje dl - opcija gumice

       displej.setPixel(1,36);
        displej.setPixel(1,37);
        displej.setPixel(1,35);
        displej.setPixel(2,33);
        displej.setPixel(2,34);
        displej.setPixel(2,35);
        displej.setPixel(2,36);
        displej.setPixel(2,37);
        displej.setPixel(4,33);
        displej.setPixel(4,34);
        displej.setPixel(4,35);
        displej.setPixel(4,36);
        displej.setPixel(4,37);

    //x od 7 do 13
    //y od 32 do 39
    //crtanje punog pravougaonika
        displej.setPixel(8,34);
        displej.setPixel(8,35);
        displej.setPixel(8,36);
        displej.setPixel(9,34);
        displej.setPixel(9,35);
        displej.setPixel(9,36);
        displej.setPixel(10,34);
        displej.setPixel(10,35);
        displej.setPixel(10,36);
        displej.setPixel(11,36);
        displej.setPixel(11,35);
        displej.setPixel(11,34);


    //x od 0 do 6
    //y od 40 do 47
    //crtanje strelice dolje - opcija importovanja

        displej.setPixel(1,44);
        displej.setPixel(2,45);
        displej.setPixel(3,46);
        displej.setPixel(3,45);
        displej.setPixel(3,44);
        displej.setPixel(3,43);
        displej.setPixel(3,42);
        displej.setPixel(3,41);
        displej.setPixel(4,45);
        displej.setPixel(5,44);

    //x od 7 do 13
    //y od 40 do 47
    //crtanje strelice gore - opcija exportovanja


        displej.setPixel(10,46);
        displej.setPixel(10,45);
        displej.setPixel(10,44);
        displej.setPixel(10,43);
        displej.setPixel(10,42);
        displej.setPixel(10,41);
        displej.setPixel(9,42);
        displej.setPixel(8,43);
        displej.setPixel(11,42);
        displej.setPixel(12,43);

        displej.refresh();
    
}

int binarno(int num)
{
    int broj=0;
    int k=1;
    int n=1;
    while(num!=0) {
        n=num%10;
        broj=broj+n*k;
        k*=2;
        num/=10;

    }
    return broj;
}
int decimalno(int n)
{
    int k=1;
    int ostatak=0;
    int broj=0;
    while(n!=0) {
        ostatak=n%2;
        broj+=ostatak*k;
        k*=10;
        n/=2;
    }
    return broj;
}
void ucitajUBafer()
{
    for(int i=0; i<84; i++) {
        for(int j=0; j<6; j++) {
            int broj=0;
            broj+=displej.getPixel(i,j*8+7);
            broj+=displej.getPixel(i,j*8+6)*10;
            broj+=displej.getPixel(i,j*8+5)*100;
            broj+=displej.getPixel(i,j*8+4)*1000;
            broj+=displej.getPixel(i,j*8+3)*10000;
            broj+=displej.getPixel(i,j*8+2)*100000;
            broj+=displej.getPixel(i,j*8+1)*1000000;
            broj+=displej.getPixel(i,j*8)*10000000;
            bafer[i*6+j]=binarno(broj);

        }
    }
}

void iscitajIzBafera()
{
    for(int i=0; i<84; i++) {
        for(int j=0; j<6; j++) {
            int broj=decimalno(bafer[i*6+j]);
            if(broj%10==0) displej.clearPixel(i,j*8);
            else displej.setPixel(i,j*8);
            broj/=10;
            if(broj%10==0) displej.clearPixel(i,j*8+1);
            else displej.setPixel(i,j*8+1);
            broj/=10;
            if(broj%10==0) displej.clearPixel(i,j*8+2);
            else displej.setPixel(i,j*8+2);
            broj/=10;
            if(broj%10==0) displej.clearPixel(i,j*8+3);
            else displej.setPixel(i,j*8+3);
            broj/=10;
            if(broj%10==0) displej.clearPixel(i,j*8+4);
            else displej.setPixel(i,j*8+4);
            broj/=10;
            if(broj%10==0) displej.clearPixel(i,j*8+5);
            else displej.setPixel(i,j*8+5);
            broj/=10;
            if(broj%10==0) displej.clearPixel(i,j*8+6);
            else displej.setPixel(i,j*8+6);
            broj/=10;
            if(broj%10==0) displej.clearPixel(i,j*8+7);
            else displej.setPixel(i,j*8+7);
        }

    }
    displej.refresh();
}

void pravougaonik(int p1, int k1, int p2, int k2)
{
    int duzinaX=p2-p1;
    int duzinaY=k2-k1;
    if(duzinaY<0) duzinaY*=(-1); //duzina mora biti pozitivna
    if(duzinaX<0) duzinaX*=(-1); //duzina mora biti pozitivna
    if(p1<p2 && k1<k2) { //prva tacka je dolje lijevo u odnosu na drugu
        for(int i=0; i<duzinaX; i++) {
            displej.clearPixel(p1+i, k1);
            displej.clearPixel(p2-i, k2);
        }
        for(int i=0; i<duzinaY; i++) {
            displej.clearPixel(p1, k1+i);
            displej.clearPixel(p2, k2-i);
        }
        for(int i=0; i<duzinaX; i++) {
            displej.setPixel(p1+i, k1);
            displej.setPixel(p2-i, k2);
        }
        for(int i=0; i<duzinaY; i++) {
            displej.setPixel(p1, k1+i);
            displej.setPixel(p2, k2-i);
        }
    } else if(p1<p2 && k1>k2) { //prva tacka je gore lijevo u odnosu na drugu
        for(int i=0; i<duzinaX; i++) {
            displej.clearPixel(p1+i, k1);
            displej.clearPixel(p2-i, k2);
        }
        for(int i=0; i<duzinaY; i++) {
            displej.clearPixel(p1, k1-i);
            displej.clearPixel(p2, k2+i);
        }
        for(int i=0; i<duzinaX; i++) {
            displej.setPixel(p1+i, k1);
            displej.setPixel(p2-i, k2);
        }
        for(int i=0; i<duzinaY; i++) {
            displej.setPixel(p1, k1-i);
            displej.setPixel(p2, k2+i);
        }
    } else if(p1>p2 && k1<k2) { //prva tacka se nalazi desno dolje u odnosu na drugu
        for(int i=0; i<duzinaX; i++) {
            displej.clearPixel(p1-i, k1);
            displej.clearPixel(p2+i, k2);
        }
        for(int i=0; i<duzinaY; i++) {
            displej.clearPixel(p1, k1+i);
            displej.clearPixel(p2, k2-i);
        }
        for(int i=0; i<duzinaX; i++) {
            displej.setPixel(p1-i, k1);
            displej.clearPixel(p2+i, k2);
        }
        for(int i=0; i<duzinaY; i++) {
            displej.setPixel(p1, k1+i);
            displej.clearPixel(p2, k2-i);
        }

    } else { //prva tacka se nalazi gore desno u odnosu na drugu
        for(int i=0; i<duzinaX; i++) {
            displej.clearPixel(p1-i, k1);
            displej.clearPixel(p2+i, k2);
        }
        for(int i=0; i<duzinaY; i++) {
            displej.clearPixel(p1, k1-i);
            displej.clearPixel(p2, k2+i);
        }
        for(int i=0; i<duzinaX; i++) {
            displej.setPixel(p1-i, k1);
            displej.setPixel(p2+i, k2);
        }
        for(int i=0; i<duzinaY; i++) {
            displej.setPixel(p1, k1-i);
            displej.setPixel(p2, k2+i);
        }

    }
    // if(tackaPostoji == 1) displej.setPixel(p1,k1);
    displej.refresh();
}

void pravougaonikclear(int p1, int k1, int p2, int k2)
{
    int duzinaX=p2-p1;
    int duzinaY=k2-k1;
    if(duzinaY<0) duzinaY*=(-1); //duzina mora biti pozitivna
    if(duzinaX<0) duzinaX*=(-1); //duzina mora biti pozitivna
    if(p1<p2 && k1<k2) { //prva tacka je dolje lijevo u odnosu na drugu
        for(int i=0; i<duzinaX; i++) {
            displej.clearPixel(p1+i, k1);
            displej.clearPixel(p2-i, k2);
        }
        for(int i=0; i<duzinaY; i++) {
            displej.clearPixel(p1, k1+i);
            displej.clearPixel(p2, k2-i);
        }
        for(int i=0; i<duzinaX; i++) {
            displej.clearPixel(p1+i, k1);
            displej.clearPixel(p2-i, k2);
        }
        for(int i=0; i<duzinaY; i++) {
            displej.clearPixel(p1, k1+i);
            displej.clearPixel(p2, k2-i);
        }
    } else if(p1<p2 && k1>k2) { //prva tacka je gore lijevo u odnosu na drugu
        for(int i=0; i<duzinaX; i++) {
            displej.clearPixel(p1+i, k1);
            displej.clearPixel(p2-i, k2);
        }
        for(int i=0; i<duzinaY; i++) {
            displej.clearPixel(p1, k1-i);
            displej.clearPixel(p2, k2+i);
        }
        for(int i=0; i<duzinaX; i++) {
            displej.clearPixel(p1+i, k1);
            displej.clearPixel(p2-i, k2);
        }
        for(int i=0; i<duzinaY; i++) {
            displej.clearPixel(p1, k1-i);
            displej.clearPixel(p2, k2+i);
        }
    } else if(p1>p2 && k1<k2) { //prva tacka se nalazi desno dolje u odnosu na drugu
        for(int i=0; i<duzinaX; i++) {
            displej.clearPixel(p1-i, k1);
            displej.clearPixel(p2+i, k2);
        }
        for(int i=0; i<duzinaY; i++) {
            displej.clearPixel(p1, k1+i);
            displej.clearPixel(p2, k2-i);
        }
        for(int i=0; i<duzinaX; i++) {
            displej.clearPixel(p1-i, k1);
            displej.clearPixel(p2+i, k2);
        }
        for(int i=0; i<duzinaY; i++) {
            displej.clearPixel(p1, k1+i);
            displej.clearPixel(p2, k2-i);
        }

    } else { //prva tacka se nalazi gore desno u odnosu na drugu
        for(int i=0; i<duzinaX; i++) {
            displej.clearPixel(p1-i, k1);
            displej.clearPixel(p2+i, k2);
        }
        for(int i=0; i<duzinaY; i++) {
            displej.clearPixel(p1, k1-i);
            displej.clearPixel(p2, k2+i);
        }
        for(int i=0; i<duzinaX; i++) {
            displej.clearPixel(p1-i, k1);
            displej.clearPixel(p2+i, k2);
        }
        for(int i=0; i<duzinaY; i++) {
            displej.setPixel(p1, k1-i);
            displej.clearPixel(p2, k2+i);
        }

    }
    //  if(tackaPostoji == 1) displej.clearPixel(p1,k1);
    displej.refresh();
}


void punipravougaonik(int p1, int k1, int p2, int k2)
{
    if(p1<p2 && k1<k2) { //prva tacka je dolje lijevo u odnosu na drugu

        for(int i=p1; i<=p2; i++) {
            for(int j=k1; j<=k2; j++) {
                displej.setPixel(i, j);
                displej.refresh();
            }
        }
        for(int i=p1; i<=p2; i++) {
            for(int j=k1; j<=k2; j++) {
                displej.setPixel(i, j);
                displej.refresh();
            }
        }

    } else if(p1<p2 && k1>k2) { //prva tacka je gore lijevo u odnosu na drugu
        for(int i=p1; i<=p2; i++) {
            for(int j=k2; j<=k1; j++) {
                displej.setPixel(i, j);
                displej.refresh();
            }
        }
        for(int i=p1; i<=p2; i++) {
            for(int j=k1; j<=k2; j++) {
                displej.setPixel(i, j);
                displej.refresh();
            }
        }

    } else if(p1>p2 && k1<k2) { //prva tacka gore lijevo u odnosu na drugu
        for(int i=p2; i<=p1; i++) {
            for(int j=k1; j<=k2; j++) {
                displej.clearPixel(i, j);
                displej.refresh();
            }
        }
        for(int i=p2; i<=p1; i++) {
            for(int j=k1; j<=k2; j++) {
                displej.setPixel(i, j);
                displej.refresh();
            }
        }
    } else { //prva tacka se nalazi gore desno u odnosu na drugu

        for(int i=p2; i<=p1; i++) {
            for(int j=k2; j<=k1; j++) {
                displej.clearPixel(i, j);
                displej.refresh();
            }
        }
        for(int i=p2; i<=p1; i++) {
            for(int j=k2; j<=k1; j++) {
                displej.setPixel(i, j);
                displej.refresh();
            }
        }
    }
    displej.refresh();
}

void punipravougaonikclear(int p1, int k1, int p2, int k2)
{
    if(p1<p2 && k1<k2) { //prva tacka je dolje lijevo u odnosu na drugu

        for(int i=p1; i<=p2; i++) {
            for(int j=k1; j<=k2; j++) {
                displej.clearPixel(i, j);
                displej.refresh();
            }
        }
        for(int i=p1; i<=p2; i++) {
            for(int j=k1; j<=k2; j++) {
                displej.clearPixel(i, j);
                displej.refresh();
            }
        }

    } else if(p1<p2 && k1>k2) { //prva tacka je gore lijevo u odnosu na drugu
        for(int i=p1; i<=p2; i++) {
            for(int j=k2; j<=k1; j++) {
                displej.clearPixel(i, j);
                displej.refresh();
            }
        }
        for(int i=p1; i<=p2; i++) {
            for(int j=k1; j<=k2; j++) {
                displej.clearPixel(i, j);
                displej.refresh();
            }
        }

    } else if(p1>p2 && k1<k2) { //prva tacka gore lijevo u odnosu na drugu
        for(int i=p2; i<=p1; i++) {
            for(int j=k1; j<=k2; j++) {
                displej.clearPixel(i, j);
                displej.refresh();
            }
        }
        for(int i=p2; i<=p1; i++) {
            for(int j=k1; j<=k2; j++) {
                displej.clearPixel(i, j);
                displej.refresh();
            }
        }
    } else { //prva tacka se nalazi gore desno u odnosu na drugu

        for(int i=p2; i<=p1; i++) {
            for(int j=k2; j<=k1; j++) {
                displej.clearPixel(i, j);
                displej.refresh();
            }
        }
        for(int i=p2; i<=p1; i++) {
            for(int j=k2; j<=k1; j++) {
                displej.clearPixel(i, j);
                displej.refresh();
            }
        }
    }
    displej.refresh();
}
void import(int p1, int k1, int p2, int k2)
{
    return;
}
void eksport (int p1, int k1, int p2, int k2)
{
    return;
}
void gumica(int p1, int k1, int p2, int k2)
{
    displej.clearPixel(p2, k2);
}

void krivalinija(int p1, int k1, int p2, int k2)
{
    displej.setPixel(p2, k2);
}

void izbrisiSve()
{
    displej.clear();
    iscrtajPocetniEkran();
}

void linija(int p1, int k1, int p2, int k2)
{
    if(p1 > p2) {
        int temp;
        temp = p1;
        p1 = p2;
        p2 = temp;
        temp = k1;
        k1 = k2;
        k2 = temp;
    }
    for(int i = p1 + 1; i <= p2; i++) {
        int j;
        j = ( ((float)(k2 - k1) / (float)(p2 - p1))*(float)(i - p1) + k1 +0.5);
        displej.setPixel(i, j);
        displej.refresh();
    }
    //wait(5);
    // displej.clear();
    tackaPostoji = 0;
    p1 = 0;
    p2 = 0;
    k1 = 0;
    k2 = 0;


}
void linijaclear(int p1, int k1, int p2, int k2)
{
    if(p1 > p2) {
        int temp;
        temp = p1;
        p1 = p2;
        p2 = temp;
        temp = k1;
        k1 = k2;
        k2 = temp;
    }
    for(int i = p1 + 1; i <= p2; i++) {
        int j;
        j = ( ((float)(k2 - k1) / (float)(p2 - p1))*(float)(i - p1) + k1 +0.5);
        displej.clearPixel(i, j);
        displej.refresh();
    }
    //wait(5);
    // displej.clear();
    tackaPostoji = 0;
    p1 = 0;
    p2 = 0;
    k1 = 0;
    k2 = 0;


}


void krug(float x0, float y0, float x1, float y1)
{
    int x =sqrt((x0-x1)*(x0-x1) + (y0-y1)*(y0-y1));
    int y = 0;
    int odlukagotova2 = 1 - x;   // Decision criterion divided by 2 evaluated at x=r, y=0

    while(x >= y) {
        displej.setPixel( x + x0,  y + y0);
        displej.setPixel( y + x0,  x + y0);
        displej.setPixel(-x + x0,  y + y0);
        displej.setPixel(-y + x0,  x + y0);
        displej.setPixel(-x + x0, -y + y0);
        displej.setPixel(-y + x0, -x + y0);
        displej.setPixel( x + x0, -y + y0);
        displej.setPixel( y + x0, -x + y0);
        y++;
        if (odlukagotova2<=0) {
            odlukagotova2 += 2 * y + 1;   // Change in decision criterion for y -> y+1
        } else {
            x--;
            odlukagotova2 += 2 * (y - x) + 1;   // Change for y -> y+1, x -> x-1
        }
    }
}


void punikrug(float x0, float y0, float x1, float y1)
{
    int radius=sqrt((x0-x1)*(x0-x1) + (y0-y1)*(y0-y1));
    int x = sqrt((x0-x1)*(x0-x1) + (y0-y1)*(y0-y1));
    int y = 0;
    int xPromjena = 1 - (radius << 1);
    int yPromjena = 0;
    int radiusgreska = 0;

    while (x >= y) {
        for (int i = x0 - x; i <= x0 + x; i++) {
            displej.setPixel(i, y0 + y);
            displej.setPixel(i, y0 - y);
        }
        for (int i = x0 - y; i <= x0 + y; i++) {
            displej.setPixel(i, y0 + x);
            displej.setPixel(i, y0 - x);
        }

        y++;
        radiusgreska += yPromjena;
        yPromjena += 2;
        if (((radiusgreska << 1) + xPromjena) > 0) {
            x--;
            radiusgreska += xPromjena;
            xPromjena += 2;
        }
    }
}

void punikrugclear(float x0, float y0, float x1, float y1)
{
    int radius=sqrt((x0-x1)*(x0-x1) + (y0-y1)*(y0-y1));
    int x = sqrt((x0-x1)*(x0-x1) + (y0-y1)*(y0-y1));
    int y = 0;
    int xPromjena = 1 - (radius << 1);
    int yPromjena = 0;
    int radiusgreska = 0;

    while (x >= y) {
        for (int i = x0 - x; i <= x0 + x; i++) {
            displej.clearPixel(i, y0 + y);
            displej.clearPixel(i, y0 - y);
        }
        for (int i = x0 - y; i <= x0 + y; i++) {
            displej.clearPixel(i, y0 + x);
            displej.clearPixel(i, y0 - x);
        }

        y++;
        radiusgreska += yPromjena;
        yPromjena += 2;
        if (((radiusgreska << 1) + xPromjena) > 0) {
            x--;
            radiusgreska += xPromjena;
            xPromjena += 2;
        }
    }
}

void krugclear(float x0, float y0, float x1, float y1)
{
    int x =sqrt((x0-x1)*(x0-x1) + (y0-y1)*(y0-y1));
    int y = 0;
    int odlukagotova2 = 1 - x;   // Decision criterion divided by 2 evaluated at x=r, y=0

    while(x >= y) {
        displej.clearPixel( x + x0,  y + y0);
        displej.clearPixel( y + x0,  x + y0);
        displej.clearPixel(-x + x0,  y + y0);
        displej.clearPixel(-y + x0,  x + y0);
        displej.clearPixel(-x + x0, -y + y0);
        displej.clearPixel(-y + x0, -x + y0);
        displej.clearPixel( x + x0, -y + y0);
        displej.clearPixel( y + x0, -x + y0);
        y++;
        if (odlukagotova2<=0) {
            odlukagotova2 += 2 * y + 1;   // Change in decision criterion for y -> y+1
        } else {
            x--;
            odlukagotova2 += 2 * (y - x) + 1;   // Change for y -> y+1, x -> x-1
        }
    }
}
void tekst(int p1, int k1)
{

    cursorX=p1;
    cursorY=k1/8;
while(crtaj){
    if(pc.readable()) {
        displej.refresh();
        char c = pc.getc();
        if(c == ENTER) enter();
        else if(c == '1') backspace();
        else if(c == '2') deletee();
        else karakter(c);
    }
}

}

void tacka(int p1, int k1)
{
    displej.setPixel(p1, k1);
}

bool odrediKoordinate(float x,float y)
{
// x od 0 do 6
// y od 0 do 7
//crtanje linije
    if(x>=0 && x<=6 && y>=0 && y<=7) {
        funkcija=1;
        return true;
    }

    //x od 7 do 13
//y od 0 do 7
//crtanje kose linije
    else  if(x>=7 && x<=13 && y>=0 && y<=7) {
        funkcija=2;
        return true;
    }
//x od 0 do 6
//y od 8 do 15
//crtanje praznog pravougaonika
    else if(x>=0 && x<=6 && y>=8 && y<=15) {
        funkcija=3;
        return true;
    }
//x od 7 do 13
//y od 8 do 15
//crtanje kruga
    else if(x>=7 && x<=13 && y>=8 && y<=15) {
        funkcija=4;
        return true;
    }
//x od 0 do 6
//y od 16 do 23
//crtanje kruznice

    else if(x>=0 && x<=6 && y>=16 && y<=23) {
        funkcija=5;
        return true;
    }
//x od 7 do 13
//y od 16 do 23
//iscrtavanje slova A

    else if(x>=7 && x<=13 && y>=16 && y<=23) {
        funkcija=6;
        return true;
    }

//x od 0 do 6
//y od 24 do 31
//iscrtavanje tacke
    else if(x>=0 && x<=6 && y>=24 && y<=31) {
        funkcija=7;
        return true;
    }

//x od 7 do 13
//y od 24 do 31
//iscrtavanje cl - opcija za brisanje ekrana

    else if(x>=7 && x<=13 && y>=24 && y<=31) {
        funkcija=8;
        return true;
    }

//x od 0 do 6
//y od 32 do 39
//iscrtavanje dl - opcija gumice


    else if(x>=0 && x<=6 && y>=32 && y<=39) {
        funkcija=9;
        return true;
    }

//x od 7 do 13
//y od 32 do 39
//crtanje punog pravougaonika

    else if(x>=7 && x<=13 && y>=32 && y<=39) {
        displej.printString("TU SMO", 15, 15);
        {
            funkcija=10;
            return true;
        }
    }


//x od 0 do 6
//y od 40 do 47
//crtanje strelice dolje - opcija importovanja

    else if(x>=0 && x<=6 && y>=40 && y<=47) {
        funkcija=11;
        return true;
    }

//x od 7 do 13
//y od 40 do 47
//crtanje strelice gore - opcija exportovanja

    else if(x>=7 && x<=13 && y>=40 && y<=47) {
        funkcija=12;
        return true;
    }

    else return false ;
}

int pocetnax=0;
int pocetnay=0;
bool izabranaFunkcija=false;
void pritisnutLijevo(int x,int y)
{
    if(odrediKoordinate(x,y)==false) {
        crtaj=true;
        pocetnax=x;
        pocetnay=y;
        displej.refresh();
    } else {
        if(funkcija==8)   {
            displej.clear();
            iscrtajPocetniEkran();
            displej.refresh();
        }

    }

}
void Pritisnuto()
{

    if (dibauns.read() > 0.2) {

        if(crtaj==true) crtaj=false;
        else pritisnutLijevo(korx,kory);
    }
    dibauns.reset();
}
int starox=0;
int staroy=0;
void Crtaj (int x, int y)
{
    if (x < 3 || x > 81) return;
    if (y < 3 || y > 45) return;

//for (int i = 0; i < 13; ++i)
    // displej.clearPixel (xx + mijenjajx[i], yy + mijenjajy[i]);
    displej.clearPixel(starox,staroy);
    iscrtajPocetniEkran();
    displej.refresh();
//       displej.setXYAddress (0, 0);

    //for (int i = 0; i < 13; ++i)
    //  displej.setPixel (x + mijenjajx[i], y + mijenjajy[i]);
    displej.setPixel(x,y);
    starox=x;
    staroy=y;
    displej.refresh();
}

void IspisCrtaj ()
{

    double ulazx = X, ulazy = Y;
    if (ulazx <= minx) {
        if(korx<=3) korx=3;
        else korx=korx-1;
    } else if (ulazx <= srednjex) {}
    else { //(ulazx > maxx)
        if(korx>=81) korx=81;
        else korx=korx+1;
    }


    if (ulazy <=miny) {
        if(kory<=3) kory=3;
        else kory=kory-1;
    } else if (ulazy <= srednjey) {}
    else { //if (ulazy <= maxy)
        if(kory>=45) kory=45;
        else kory=kory+1;
    }

    Crtaj (korx, kory);
    displej.refresh();
    /*   int x2 = 0, x1 = 0, x0 = 0, y0 = 0, y1 = 0, y2 = 0;
       // double dec = int((ulazx-(int)ulazx)* 100.0 );//+ 0.5) / 100.0);
       int dec= int(ulazx*100);
       x0= (int)dec % 10;
       x1 = ((int)dec / 10) % 10;
       x2 = (int)ulazx;
       //  double dec1 = int((ulazy-(int)ulazy)* 100.0 );//
       int dec1= int(ulazy*100);
       y0= (int)dec1 % 10;
       y1 = ((int)dec1 / 10) % 10;
       y2 = (int)ulazy;*/


}

int main()
{
    enable = 1;
    SWtaster.mode (PullUp);
    dibauns.start();
    SWtaster.rise (&Pritisnuto);
    displej.init();

    iscrtajPocetniEkran();
  
   tikerOcitaj.attach (&IspisCrtaj, 0.1);
    korx=30;
    kory=30;
    //IspisCrtaj();

    while(1) {
        if(crtaj) {
                
            if(funkcija==1) {
                int starox=pocetnax;
                int staroy=pocetnay;
                int kursorxpom;
                int kursorypom;
                while(crtaj) {
                    kursorxpom=korx;
                    kursorypom=kory;
                    if(kursorxpom<13) kursorxpom=13;
                    linija(pocetnax,pocetnay,kursorxpom,kursorypom);
                  linijaclear(pocetnax,pocetnay,starox,staroy);
                   starox=kursorxpom;
                    staroy=kursorypom;
                    
                }

                //  wait(0.05); displej.clear(); iscrtajPocetniEkran();
                linija(pocetnax,pocetnay,korx,kory);
            } else if(funkcija==2) {
                while(crtaj) {

                    krivalinija(pocetnax,pocetnay,korx,kory);
                }

            }

            else if(funkcija==3) {
                int starox=pocetnax;
                int staroy=pocetnay;
                int kursorxpom;
                int kursorypom;
                while(crtaj) {
                    kursorxpom=korx;
                    kursorypom=kory;
                    if(kursorxpom<13) kursorxpom=13;
                    pravougaonik(pocetnax,pocetnay,kursorxpom,kursorypom);
                    pravougaonikclear(pocetnax,pocetnay,starox,staroy);
                    starox=kursorxpom;
                    staroy=kursorypom;
                }
                pravougaonik(pocetnax,pocetnay,starox,staroy);
            } else if(funkcija==4) {
                int starox=pocetnax;
                int staroy=pocetnay;
                int kursorxpom;
                int kursorypom;

                while(crtaj) {
                    kursorxpom=korx;
                    kursorypom=kory;
                    if(kursorxpom<13) kursorxpom=13;
                    //    float korijen= sqrt(( kursorxpom- x)*( kursorxpom- x) + ( kursorypom- y)*( kursorypom- y));
                    punikrug(pocetnax,pocetnay,korx, kory);
                    //   korijen= math::sqrt(( starox- x)*( starox- x) + ( staroy- y)*( staroy- y));
                    punikrugclear(pocetnax,pocetnay,starox,staroy);
                    starox=kursorxpom;
                    staroy=kursorypom;
                }
                //float korijen= math::sqrt(( starox- x)*( starox- x) + ( staroy- y)*( staroy- y));

                punikrug(pocetnax,pocetnay,korx, kory);
            } else if(funkcija==5) {
                int starox=pocetnax;
                int staroy=pocetnay;
                int kursorxpom;
                int kursorypom;
                while(crtaj) {
                    kursorxpom=korx;
                    kursorypom=kory;
                    if(kursorxpom<13) kursorxpom=13;

                    krug(pocetnax,pocetnay,kursorxpom,kursorypom);
                    krugclear(pocetnax,pocetnay,starox,staroy);
                    starox=kursorxpom;
                    staroy=kursorypom;
                }
                krug(pocetnax,pocetnay,korx,kory);
            }

            else if(funkcija==6) {
  tekst(pocetnax,pocetnay);
              
                  
                   
            } else if(funkcija==7) {
                displej.setPixel(pocetnax,pocetnay);
                displej.refresh();
                crtaj=false;
            } else if(funkcija==9) {
                while(crtaj) {
                    displej.clearPixel(korx,kory);
                    displej.refresh();
                }
            }

            else if(funkcija==10) {
                int starox=pocetnax;
                int staroy=pocetnay;
                int kursorxpom;
                int kursorypom;
                while(crtaj) {
                    kursorxpom=korx;
                    kursorypom=kory;
                    if(kursorxpom<13) kursorxpom=13;
                    punipravougaonik(pocetnax,pocetnay,kursorxpom,kursorypom);
                    punipravougaonikclear(pocetnax,pocetnay,starox,staroy);
                    starox=kursorxpom;
                    staroy=kursorypom;
                }
                punipravougaonik(pocetnax,pocetnay,starox,staroy);
            } else if(funkcija==11) {
                displej.printString("Otvorite formu", 13, 1);
                displej.clear();
                displej.refresh();
                while(1) {
            
            int br=0;
          
            if(pc.readable()) {
        displej.printString("pirmio",10,1);
   displej.refresh();
                char c = pc.getc();
                bafer[br] = c+48;
                br++;

            }
            if(br == 5) break;
        }
        displej.printString("pirmio",10,1);
        displej.refresh();
        iscitajIzBafera();
                
            } else if(funkcija==12) {
                displej.printString("Otvorite formu", 13, 1);
                displej.refresh();
                wait(3);
                displej.clear();
                iscrtajPocetniEkran();
                displej.refresh();
            }

            }

        }

     }
