#include "mbed.h"
#include "MMA8451Q.h"
#include "TextLCD.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

TextLCD lcd(PTB8, PTB9, PTB10, PTB11, PTE2, PTE3); // rs, e, d4-d7
float acx=0,acy=0,acz=0, filtro=0;
float faroin1, faroin2, faroout;
int main(void) {
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED_RED);
    PwmOut gled(LED_GREEN);
    PwmOut bled(LED_BLUE);
    
    PwmOut acx(PTD4);
    PwmOut acy(PTA12);
    PwmOut acz(PTA4);
    
    AnalogIn faroin1(PTB3); 
    AnalogIn faroin2(PTB2);
    DigitalOut faroout(PTA13);
    
    Serial pc(USBTX, USBRX); // tx, rx
    lcd.locate(0,0);
    lcd.printf("Medicion");
    lcd.locate(0,1);
    lcd.printf("Acelerometro");
    wait(2);
    lcd.locate(0,0);
    lcd.printf("x=       y=");
    lcd.locate(0,1);
    lcd.printf("z=            ");
    while (true) {

        rled = 1.0 - abs(acc.getAccX());
        gled = 1.0 - abs(acc.getAccY());
        bled = 1.0 - abs(acc.getAccZ());
        
        if (faroin1 > 0.5 or faroin2 > 0.5) {
        faroout = 1;
        filtro=((acc.getAccX()+(2*filtro))/3);
            if (acc.getAccX() > 0) {
            acx=0.5 + (filtro*2);
            acy=0.5 - (filtro*2);
            }
                else {
                acx=0.5 + (filtro*2);
                acy=0.5 - (filtro*2);       
                }
            if (acx > 1 or acy > 1) {
                acx=1;
                acy=1;
                }
                else if (acx<0 or acy<0) {
                    acx=0;
                    acy=0;
                    }
              }
        else {
        faroout = 0;
        acx=0.5;
        acy=0.5;
        }


        //acz=0.0 + (acc.getAccZ());
        
        
        lcd.locate(2,0);
        lcd.printf("     ");
        lcd.locate(2,0);
/*
        lcd.printf("%2.2f",acx);
        lcd.locate(11,0);
        lcd.printf("     ");
        lcd.locate(11,0);
        lcd.printf("%2.2f",acy);
        lcd.locate(2,1);
        lcd.printf("     ");
        lcd.locate(2,1);
        lcd.printf("%2.2f",acz);
*/        
        wait(0.2);
        //pc.printf(("%f  %f  %f ,"),acc.getAccX(),acc.getAccY(),acc.getAccZ());
        pc.printf(("%f  %f  %f"),acx.read(),acy.read(),faroin1.read());
        //pc.printf(("%f  %f  ,"),acx.read(),acy.read());
        //faroin2.read()
        wait(0.2); //287 o 289 fluke
    }
}
