#include "mbed.h"
#include "HX711.h"
#include "ESP8266.h"

ESP8266 esp(PTC4,PTC3,9600);
DigitalIn hx711input(D5);
DigitalOut green(LED2);
DigitalOut red(LED1);
Serial pc(USBTX, USBRX);    // USB Serial Terminal

HX711 scale(D5,D13);
char rs[100],rcv[100];
int averageSamples = 100;
float calibration_factor = 1000;
int main(void)
{
    pc.baud(9600);
    pc.printf("Starting Scale\r\n");
    //wait(0.2f);
   // pc.printf("HX711 calibration sketch\r\n");
    //wait(0.2f);
    pc.printf("Remove all weight from scale\r\n");
    //wait(0.2f);
    pc.printf("After readings begin, place known weight on scale\r\n");
    //wait(0.2f);
    
      
    scale.setScale(0);
    scale.tare(); //Reset the scale to 0
    
    //long zero_factor = scale.averageValue(averageSamples); //Get a baseline reading
   // pc.printf("Zero factor: %.4f\r\n" , zero_factor); //This can be used to remove the need to tare the scale. Useful in permanent scale projects.
    
     while (true) {
          scale.setScale(calibration_factor); 
         float weight = scale.getGram();
         
         
        //float raw = scaleRaw.read();
        if (weight >5 && weight <10)
        weight = 50;
        else if (weight >10 && weight <15)
        weight = 100;
        else if (weight >15 && weight <25)
        weight = 100;
        else if (weight >25 && weight <30)
        weight = 200;
        else if (weight >30 && weight <50)
        weight = 300;
        else if (weight >50 && weight <70)
        weight = 400;
        else if (weight >70 && weight <75)
        weight = 500;
        else if (weight >145 && weight <150)
        weight = 1000;
        
        pc.printf("Reading: %.2f gms \r\n", weight);
        pc.printf(" calibration_factor: %.2f\r\n", calibration_factor);
        if(pc.readable()) {
            char temp = pc.getc();
            if(temp == '+' || temp == 'a')
               calibration_factor += 10;
            else if(temp == '-' || temp == 'z')
                calibration_factor -= 10;
            }
       sprintf(rs,"&pr=%.3f", weight);
       esp.SendCMD(rs);
       esp.RcvReply(rcv, 1000);
        //pc.printf("%s", rcv);
        wait(1);
       /* if(hx711input > 2000)
        {
            green = !green;
            wait(0.2);
        }
        else 
        {   red=!red;
           wait(0.2);
            }
        //pc.printf("Raw Value: %.7f\n", raw);*/
        // wait(0.2);
    }
}