#include "mbed.h"
#include "BNO055.h"

Serial pc(USBTX, USBRX);
BNO055 sensor(I2C_SDA,I2C_SCL);
DigitalOut led(LED1);

int main() {
    pc.baud(115200);
    pc.printf("BNO055 Hello World\r\n\r\n");
    led = 1;
// Reset the BNO055
    sensor.reset();
    
    
// Check that the BNO055 is connected and flash LED if not
    while (!sensor.check()){
            sensor.reset();
            led = !led;
            if(led){
                pc.printf("Toujours rien !");
            }
            else{
                pc.printf("Ya pas le module...\n\r");
            }
            wait(0.5);
    }
    //switching to configmode, AMG , need 19ms for doing that.
    // sensor.setmode(7); //config mode
    /*
    pc.printf("Module found.\n\r");
    pc.printf("\n\r Sensor informations\n\r");
    pc.printf("Chip          ID: %0z\r\n",sensor.ID.id);
    pc.printf("Accelerometer ID: %0z\r\n",sensor.ID.accel);
    pc.printf("Gyroscope     ID: %0z\r\n",sensor.ID.gyro);
    pc.printf("Magnetometer  ID: %0z\r\n\r\n",sensor.ID.mag);
    pc.printf("Firmware version v%d.%0d\r\n",sensor.ID.sw[0],sensor.ID.sw[1]);
    pc.printf("Bootloader version v%d\r\n\r\n",sensor.ID.bootload);
*/
    pc.printf("| Calib | Acceleration X | Acceleration Y | Acceleration Z | \n\r");
  
    pc.printf("\r\n");
    while (true) {
        sensor.setmode(OPERATION_MODE_NDOF);
        sensor.get_calib();
        sensor.get_accel();
        sensor.get_lia();
        pc.printf("%5.3f, %5.3f, %5.3f ",sensor.accel.x/100,sensor.accel.y/100,sensor.accel.z/100);
        pc.printf("| %5.3f, %5.3f, %5.3f \n\r",sensor.lia.x/100,sensor.lia.y/100,sensor.lia.z/100);
        
        wait(0.5);
    }
    
    
    
    /*
    float movex = 0.0;
    float movey = 0.0;
    float temps = 0.0;
    clock_t begin;
    clock_t end;
    int taille_moyenne = 10;
    float accels[2][taille_moyenne];
    float accelx = 0.0;
    float accely = 0.0;
    int indice=0;
    
    begin = clock();
    while (true) {
        // get and read th accelerations for x and y
        sensor.setmode(OPERATION_MODE_NDOF);
        sensor.get_calib();
        sensor.get_accel();
        
        end = clock();
        temps = (end-begin)/(double) CLOCKS_PER_SEC;
        pc.printf("Temps ecoule: %5.3f\n\r",temps);
        
        // Kind of shift register but the values stays in place.
        // The indice follow a cycle and point the oldest value (to overwrite).
        accels[0][indice] = sensor.accel.x/100;
        accels[1][indice] = sensor.accel.y/100;
        
        indice++;
        if(indice >taille_moyenne-1){indice=0;}
        
        // Mean of the accelertions.
        // Can be optimized by substracting the old value and addind the new one
        // (most values didn't change)
        accelx = 0;
        accely = 0;
        for(int i=0; i < taille_moyenne; i++){
            accelx += accels[0][i];
            accely += accels[1][i];
        }
        accelx = accelx/taille_moyenne;
        accely = accely/taille_moyenne;
        
        
        // Threshold values found experimentally. On a table, accels varies to 
        // 0.15 max (approximate level precision).
        if(abs(sensor.accel.x) > 0.1){
            movex = movex + (0.5 * pow((end-begin),2.0) * accelx)/100;
        }
        if(abs(sensor.accel.y) > 0.1){
            movey = movey + (0.5 * pow((end-begin),2.0) * accely)/100;
        }
        
        pc.printf("Acceleration x = %5.3f, Acceleration y = %5.3f\n\r", accelx, accely);
        pc.printf("Deplacement x = %5.3f, Deplacement y = %5.3f\n\r", movex, movey);
        
        begin = clock();
        wait(0.1);
    }
    */
}
