
#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPServer.h"

LocalFileSystem local("local");

DigitalOut led1(LED1);

void http_thread (void const* arg);                   //

int main() {
   
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    Thread httpsvr( &http_thread );

    while (true) {

        led1 = 1-led1;
        
        Thread::wait (1000);
        
    }
    
}

//////////////////////////////////////////////////////////////////////////////////////////////////////
//                                            HTTP THREAD                                           //
//////////////////////////////////////////////////////////////////////////////////////////////////////

void http_thread (void const* arg) {

    HTTPServer svr (80, "/local/");    // esto incluye el init

    // osThreadSetPriority( Thread::gettid() ,  osPriorityBelowNormal );

    while (1) {

        svr.poll();

    }
}
