/*
Copyright (c) 2013 Pablo Gindel (palmer@pablogindel.com)
Based on original code by Henry Leinen (henry[dot]leinen [at] online [dot] de)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/


#ifndef __HTTPSERVER_H__
#define __HTTPSERVER_H__

#include "mbed.h"
#include "EthernetInterface.h"
#include <vector>
#include <string>
#include <map>

#define BUFFER_SIZE     256       // all-purpose buffer
#define TIMEOUT         500
#define OK              0
#define ERROR           -1
#define EMPTY           -2
#define MIN_LONG        3
#define CHUNK_SIZE      256

#define DEBUG 2
#include "debug.h"

enum RequestType {
     HTTP_RT_GET,        /*!< GET request */
     HTTP_RT_POST,       /*!< POST request */
};

/** HTTPMessage contains all the details of the request received by external HTTP client. */
 struct HTTPMsg {
     // Specifies the request type received
     RequestType request;
     // The uri associated with the request.
     std::string uri;
     // Contains the HTTP/1.1 or HTTP/1.0 version requested by client.
     std::string version;
     // Map of headers provided by the client in the form <HeaderName>:<HeaderValue>
     std::map<std::string, std::string> headers;
     // Map of arguments that came with the uri string
     std::map<std::string, std::string> uri_args;
     // length of the body data section
     int body_length;
};

struct RequestConfig {
     const char* request_string;
     RequestType request_type;
};

class HTTPServer {

private:
    TCPSocketServer socketServer;
    TCPSocketConnection *cliente;
    HTTPMsg *msg;
    std::string path;
    char buffer [BUFFER_SIZE];
    int pollConnection ();
    int receiveLine ();
    int parseRequest ();
    int parseHeader ();
    int parseUriArgs (char *uri_buffer);
    void handleRequest ();
    int handleGetRequest();
    int handlePostRequest();
    void startResponse (int returnCode, int nLen);
    void handleError (int errorCode);

    int tcpsend (const char* text, int param) {
        sprintf (buffer, text, param);
        return tcpsend (buffer, strlen (buffer));
    }

    int tcpsend (const char* text) {
        return tcpsend ((char*)text, strlen (text));
    }

    /*int tcpsend (char* buf, int len) {
        int sent = 0;
        while (sent<len) {
            sent += cliente->send (buf+sent, len-sent);
            if (sent == ERROR) {
                WARN("Unsent bytes left !");
                return ERROR;
            }
        }
        return OK;
    }*/

    int tcpsend (char* buf, int len) {
        if (cliente->send_all (buf, len) != len) {
            WARN("Unsent bytes left !");
            return ERROR;
        }
        return OK;
    }

public:
        /** Constructor for HTTPServer objects.  */
        HTTPServer (int port, const char* _path);

        /** Destructor for HTTPServer objects.  */
        ~HTTPServer();

        int poll();
};


void url_decode (char *str);



#endif //__HTTPSERVER_H__
