#include "mbed.h"
#define POSMAX 50       // en milimetros
#define POSDRAW 30      // en milimetros
#define BAUD 9600      // Configuracion de baudios
#define MEM_SIZE 10
#define MEM_TYPE uint32_t

#define CM_EJECUTAR 0xff
#define CM_GUARDAR 0xfe
#define CM_VERTEX2D 0xfd
#define CM_DRAW 0xfc
#define CM_NODRAW 0xfb
#define CM_STOP 0xfa
#define CM_END 0xf0

PwmOut ServoX(PB_3); //D3
PwmOut ServoY(PB_4); //D5
PwmOut ServoZ(PB_10); //D6

MEM_TYPE buffer[MEM_SIZE];
Serial pc(USBTX,USBRX); // Comunicación Serial

uint8_t  posx_old=0;     // posición anterior del eje X
uint8_t  posy_old=0;     // posición anterior del eje Y
uint8_t  ss_time=100;     // tiempo  de espera para moverse 1 mm en microsegundos
int mem_head;
int mem_tail;
uint8_t full;

uint8_t mem_put(MEM_TYPE data)
{
    if (full)
        return 1;
    buffer[mem_head] = data;
    mem_head += 1;
    if (mem_head == MEM_SIZE)
        full =1;

    return 0;
}
uint8_t mem_get(MEM_TYPE* data)
{
    if (mem_head == 0)
        return 1; 
    if (mem_head == mem_tail)
        return 1; 
 
    *data = buffer[mem_tail];
    mem_tail += 1;

    return 0;
}
void mem_free()
{
 mem_head=0;
 full=0;
} 
void sstime(uint8_t x, uint8_t y)
{
    double dx=abs(x-posx_old);
    double dy=abs(y-posy_old);
    double dist= sqrt(dx*dx+dy*dy);
    wait_ms((int)(ss_time*dist));
    posx_old = x;
    posy_old= y;
   
}
int coord2pulse(float coord)      // conversión de coordenadas en Y
{
    if(0 <= coord <= POSMAX)
        return int(700+coord*1900/50);
    return 700;
}
void vertex2d(uint8_t x, uint8_t y)     // Funcion de llamado de conversiones  X y Y
{                                   
    int pulseX = coord2pulse(x);
    int pulseY = coord2pulse(y);
    ServoX.pulsewidth_us(pulseX);
    ServoY.pulsewidth_us(pulseY);
    sstime(x,y);
    wait_ms(ss_time);
}
void draw() // Función para enviarle la posicion  de dibujo a Z, lo mueve hacia abajo. 
    {
    int pulseZ=coord2pulse(POSDRAW);    
    ServoZ.pulsewidth_us(pulseZ);
    pc.printf(" Dibujando...");
    wait_ms(ss_time*2);
    }
void nodraw() // Función para enviarle la posicion de no dibujar a  Z, lo mueve hacia arriba. 
    {     
    int pulseZ=coord2pulse(0);    
    ServoZ.pulsewidth_us(pulseZ);
    pc.printf(" Dibujo Terminado...");
    wait_ms(ss_time*2);
    }
void ejecutar(){
    pc.printf("se esta ejecutando el dibujo...");    
    // ubicar acà el codigo
}
void guardar(){
    pc.printf("se inicia el comado de guardar..");    
    // ubicar acà el codigo
    
}
void init_serial()      // configuracion de  baudios a pc
{
    pc.baud(BAUD);    
}
void init_servos()      // configuracion de  periodo
{
    ServoX.period_ms(20);
    ServoY.period_ms(20);
    ServoZ.period_ms(20);  
}
void init_draw(float x, float y)
{
    vertex2d (x,y);
    wait_ms(ss_time);
    draw();
}
void home()
{
    nodraw();
    vertex2d(0,0);
    pc.printf("Posicion Home");
    wait_ms(ss_time);
}
void put_sstime(uint8_t vtime)
{
    ss_time=vtime;
   
}


int main() {

    init_servos();
    init_serial();
    int posx=0;
    int posy=0;
    draw();
    while(1)
    {
        wait(1);
        vertex2d(posx,posy);
        posx+=5;
        posy+=5;
        if (posx > POSMAX and posy > POSMAX)
        {  
            posx=0;
            posy=0;
            nodraw();
        }

     }

}

