#include "MQ135.h"
#include "mbed.h"

MQ135::MQ135(PinName pin) : _pin(pin) 
{
    _pin = A0;
}
void MQ135::initialize()
{
    mqR = 22000;
    rO = 41763;
    a = 116.6020682;
    b = -2.769034857;
    adc_limit = 65535;
    }
float MQ135::getPPM() 
{
     Serial pc(USBTX,USBRX);
    float adcRaw=_pin.read_u16();
    pc.printf("adc: %f\n\r", adcRaw);

    rS = ((adc_limit  * mqR) / adcRaw) - mqR;
    pc.printf("Rs: %d\n\r", rS);
    rSrO = (float)rS / (float)rO;
    pc.printf("RsrO: %f\n\r", rSrO);
    float ppm = a * pow(rSrO, b);
    pc.printf("ppm: %f\n\r", ppm);
    return ppm;
}
int MQ135::air_quality()
{
     Serial pc(USBTX,USBRX);
     float adcRaw=_pin.read_u16()/64;
    //Aire limpio
    if(adcRaw <= 55)
        {
        pc.printf("Aire limpio \n\r");
        pc.printf("\n\r");
        return 0;
        }
        
    //Dioxido de carbono bajo (Respiracion humana)
    if( adcRaw >= 56 && adcRaw <= 73)
        {
        pc.printf("Aire con un poco de CO2 \n\r");
        pc.printf("\n\r");
        return 1;
        }
        
    //Dioxido de carbono
    if( adcRaw >= 74 && adcRaw <= 350)
        {
        pc.printf("Dioxido de carbono CO2 \n\r");
        pc.printf("\n\r");
        return 2;
        }
        
    //Gas propano y butano
    if(adcRaw >= 400)
        {
        pc.printf("Propano butano \n\r");
        pc.printf("\n\r");
        return 3;
        }
}
long MQ135::getRs(){
    return rS;
}
    
float MQ135::getRsRo(){
    return rSrO;
}