#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

RawSerial   Computer(SERIAL_TX, SERIAL_RX,9600);      // tx, rx
RawSerial   Gsm(PA_0,PA_1,19200);
DigitalOut  led(LED2);
DigitalOut  ResetSIM900(PA_10);
DigitalOut  EnableSIM900(PB_0);
char c;

DigitalOut myled(LED1);

void Interrupt_Sim900()
{
    if(Gsm.readable()) {
        c=Gsm.getc();
        Computer.putc(c);
    }
}

void Interrupt_Computer()
{
       c=Computer.getc();
       Gsm.putc(c);
}

int main()
{
    Gsm.attach(&Interrupt_Sim900);
    Computer.attach(&Interrupt_Computer);
    Computer.printf("Commmandos AT\n");
    ResetSIM900=0;
    EnableSIM900=1;
    wait(1);
    EnableSIM900=0;
    while(1) {
        wait(1);
        led = !led;
    }
}
