#include "synthesizer.h"

Serial pc(SERIAL_TX, SERIAL_RX);
//RawSerial pc(SERIAL_TX, SERIAL_RX);
RawSerial midi(PB_6, PB_7);  // tx, rx USART1 when use I2C_LCD

LCD lcd(PB_9,PB_8);
DigitalOut myled(LED1);
DigitalOut generating(PC_10);

DigitalIn SW1(PC_0,PullUp);
DigitalIn SW2(PC_1,PullUp);
DigitalIn SW3(PC_2,PullUp);
DigitalIn SW4(PC_3,PullUp);
DigitalIn SW5(PA_0,PullUp);
DigitalIn SW6(PA_1,PullUp);
DigitalIn SW7(PB_0,PullUp);
DigitalIn SW8(PC_12,PullUp);


STR_VOICE voice[VOICEMAX];
GENERATOR sgen[PRGGENMAX * 64];
GENERATOR dgen[PRGGENMAX * VOICEMAX];
GENERATOR_TEMP dgen_temp[PRGGENMAX * VOICEMAX];

STR_VOICE *voice_ptr  = &voice[0];
GENERATOR *gen ;// = &sgen[PresetVoiceNum - 1] set by Menu PresetVoice
GENERATOR *pgen = &dgen[0]; 
GENERATOR_TEMP *pgen_temp  = &dgen_temp[0]; 

KeyState_TypeDef keystate;

#ifdef REVERVE16BIT
extern S16 reverve_buf[22000];
extern S16 *reverve_wtemp;
#else
extern S8 reverve_buf[44000];
extern S8 *reverve_wtemp;
#endif


extern uint8_t com[16];
extern uint8_t *com_ptr;

volatile int TimerCount10mS;
volatile int KeyValDiv;

U32 PresetVoiceAmount;
U32 SGenAmount;

int menu_index;
volatile U8 key;

extern int gen_encount;
extern U8 PresetVoiceNum;
extern U8 MidiChannel;
extern U16 MasterVolume;
extern S8 MasterTune;
extern U8 midi_base_ch;
extern char lcd_string[];
extern char str[];

extern U8 selectsw;
extern MenuListDef MenuList[];
extern int rch_pol;

extern volatile U8 *midi_rdptr;
extern volatile U8 *midi_wrptr;
extern volatile U8 midi_receivebuf[];

extern volatile U8 *param_wrptr;
extern volatile U8 param_receivebuf[PARAM_BUFSIZE];

extern S16 * DMA_Buffer;
extern __IO BUFFER_StateTypeDef BufferOffset;

WaveDef Wave[100];// ={
#if 0
/*Name[16]      ,startadr   ,p1     ,p2     ,cycle */    
{"SineWave"         ,0      ,50     ,150    ,0},
{"SawWave"          ,0      ,100    ,200    ,0},
{"Saw1kWave"          ,0      ,1    ,101    ,0},
{"SquareWave"       ,0      ,50     ,150    ,0},
{"Square4QWave"      ,0      ,1     ,101    ,0},
{"Square8QWave"      ,0      ,1     ,101    ,0},
{"Sin124Wave"       ,0      ,1      ,101    ,0},
{"Sin13Wave"        ,0      ,1      ,43     ,0},
{"fluto"          ,0      ,1    ,68     ,0},
{"EnglishHorn"      ,0      ,3030   ,3142   ,0},
{"FrenchHorn"       ,0      ,3033   ,3132   ,0},
{"1278_trumpet"     ,0      ,9089   ,9200   ,0},
{"1507_trumpet"     ,0      ,6612   ,6718   ,0},
{"BrassP-C6"        ,0      ,2965  ,3133  ,0},
{"Trombone"         ,0      ,6852   ,6991   ,0},
{"Tuba_Loud"        ,0      ,12686  ,13088  ,0},
{"2524_cello"       ,0      ,8683   ,9157   ,0},
{"Contrabassoon"    ,0      ,5004   ,5759   ,0},
{"Base-Elec"        ,0      ,17400  ,17934  ,0},
{"EFEKTOharp"       ,0      ,9423   ,9522   ,0},
{"Harpsicord"       ,0      ,21595  ,21764  ,0},
{"Glockenspie"      ,0      ,3886   ,3911   ,0},
{"Xylofon"          ,0      ,1126   ,1150   ,0},
{"Acoustic Guitar"  ,0      ,11422   ,11622 ,0},
{"Piano"            ,0      ,6699   ,6783   ,0},
{"Piano 5"          ,0      ,13937  ,14335  ,0},
{"Piano 10"         ,0      ,11837  ,12005  ,0},
{"VIOLIN1"        ,0      ,1      ,56     ,0},
{"Strings"          ,0      ,3606   ,37992  ,84},
};
#endif

PresetVoiceDef PresetVoice[65];//={
#if 0
/*Name[16]       ,DCF Freq  ,Q      ,FreqEnv    ,QEnv  */
{"Piano "        ,30        ,0      ,0         ,0},// 1
{"Piano 5"       ,30        ,0      ,0         ,0},// 
{"Piano 10"      ,30        ,0      ,0         ,0},// 
{"Electo Piano"  ,30        ,0      ,0         ,0},// 
{"Organ 1"       ,30        ,0      ,0         ,0},   
{"Organ 2"       ,30        ,0      ,0         ,0},   
{"Organ 2B"      ,30        ,0      ,0         ,0},   
{"Synth Strings 1"     ,30        ,0      ,0         ,0},
{"Strings 1"     ,30        ,0      ,0         ,0},
{"Synthe Brass"  ,30        ,0      ,0         ,0}, 
{"Brass 1"       ,30        ,0      ,0         ,0}, 
{"Brass 2"       ,30        ,0      ,0         ,0}, 
{"EnglishHorn"   ,30        ,0      ,0         ,0}, 
{"Trb"           ,30        ,0      ,0         ,0}, 
{"Tuba"          ,30        ,0      ,0         ,0}, 
{"Harp"          ,30        ,0      ,0         ,0}, 
{"Harpsicord"    ,30        ,0      ,0         ,0}, 
{"Gloccken"      ,30        ,0      ,0         ,0}, 
{"Xylofon"       ,30        ,0      ,0         ,0}, 
{"Fluto"         ,30        ,0      ,0         ,0}, 
{"ContraBass"    ,30        ,0      ,0         ,0}, 
{"Chello&ContBass"  ,30        ,0      ,0         ,0}, 
{"Acoustic Guitar"   ,30        ,0      ,0         ,0}, 
{"Bass"          ,30        ,0      ,0         ,0}, 
{"Bass 2"        ,30        ,0      ,0         ,0}, 
{"User 1"        ,30        ,0      ,0         ,0}, 
{"User 2"        ,30        ,0      ,0         ,0}, 
{"User 3"        ,30        ,0      ,0         ,0}, 
{"User 4"        ,30        ,0      ,0         ,0}, 
{"User 5"        ,30        ,0      ,0         ,0}, 
{"User 6"        ,30        ,0      ,0         ,0}, 
{"User 7"        ,30        ,0      ,0         ,0}, 
{"User 8"        ,30        ,0      ,0         ,0}, 
{"User 9"        ,30        ,0      ,0         ,0}, 
{"User 10"       ,30        ,0      ,0         ,0} 
};  
#endif

void my_inthandler(void){
    while (USART1->SR & (1<<5)){ // RXNE 1: Received data is ready to be read.
       *midi_wrptr = (uint8_t)(USART1->DR & 0xFF);
       if (++midi_wrptr >&midi_receivebuf[255]) midi_wrptr = &midi_receivebuf[0];//
    }
}

void my_inthandler2(void){
        
    while (USART2->SR & (1<<5)){ // RXNE 1: Received data is ready to be read.
        *param_wrptr = (uint8_t)(USART2->DR & 0xFF);
        if (++param_wrptr >&param_receivebuf[255]) param_wrptr = &param_receivebuf[0];//
   }
}

void anykeyon(U8 inkey){
    U8 temp = inkey & 0x0f;
    /* Select OneGenSw of them */
    if (temp > 7){selectsw = 8;}
    else if(temp > 3){selectsw = 4;}
    else if(temp > 1){selectsw = 2;}
    else if(temp > 0){selectsw = 1;}

    if (inkey == 0x80){
    if (++menu_index > MENU_INDEXMAX) menu_index = MENU_INDEXMAX;
    }else if(inkey == 0x40){
        if(--menu_index < 0) menu_index = 0;    
    }        
    lcd_print1((char *)&MenuList[menu_index].menu);
    lcd_string[0] = 0;
    (*MenuList[menu_index].function)();
}


int main(){
    int temp2;
 uint8_t *test;  
    uGen4_device_init();
    pc.baud(115200);
    pc.attach(my_inthandler2, Serial::RxIrq);
//    pc.format(8,RawSerial::None,1);
    pc.printf("CPU SystemCoreClock is %d Hz\r\n", SystemCoreClock);
    PresetVoiceAmount = (U32)&PresetVoice[63]-(U32)&PresetVoice[0]+sizeof(PresetVoiceDef);
    SGenAmount = (U32)&sgen[PRGGENMAX * 64-1]-(U32)&sgen[0]+sizeof(GENERATOR);

//    pc.printf("%d\r\n",PresetVoiceAmount);
//    pc.printf("%d\r\n",SGenAmount);
 
    lcd_print_title();
     
    PresetVoiceNum = 1;
    MasterVolume = 127<<8;
    MidiChannel = 1;
    midi_base_ch = MidiChannel - 1;
    menu_index = 2;
    selectsw = 1;
    keystate = KEY_FIRST_WAIT;
    MasterTune = 0;
    rch_pol = 1;
    limit = 8;
    
    TimerCount10mS= 0;
    KeyValDiv = 1;
    int KeyAutoLoopCount = 0;

    reverve_wtemp = reverve_buf;

    if (temp2 = get_wave_addr(&Wave[0])){
        pc.printf("Wave Format Eror No %d\r\n",temp2);    
        lcd_print2("WaveFormatEror");
        val2str4(temp2);
        lcd_print(&str[0]);
        while(1){}    
    }

    init_sgen();
 
    voice_ptr  = &voice[0];
    gen =  &sgen[PresetVoiceNum - 1];
    pgen = &dgen[0]; 
    pgen_temp  = &dgen_temp[0]; 
    gen_encount = 0;
        
    init_midi(); 
    midi.attach(my_inthandler, Serial::RxIrq);
    midi.format(8,RawSerial::None,1);
    midi.baud(31250);

    load2from();

    uGen4_init();
    i2s_dma_init();
    
    init_param(); 
/*
    test = (uint8_t *)malloc(60000);
    if (test == 0) myled =1;
*/

    while(1) {
        if(BufferOffset != DMA_Idle) wave_generate();
        midi_work();        
        param_work();
        
        switch(keystate){
            case KEY_FIRST_WAIT:
                 if (ANYKEYON){
                    keystate = KEY_AFTER_ON;
                    anykeyon(0);
                 }           
                break;

            case KEY_GEN_WAVE1:
                 if (TimerCount10mS== 0){
                    keystate = KEY_WAIT_OFF;
                    TimerCount10mS= 100;// 1000mS Wait
                }           
                break;

            case KEY_WAIT_ON:
                if(key = ANYKEYON){
                    anykeyon(key);/* call function */
                    if(keystate == KEY_GEN_WAVE1){
                    }else{
                        keystate = KEY_AFTER_ON;
                        TimerCount10mS= 4;// 40mS wait for key stable
                    }
                }
                break;
        
            case  KEY_AFTER_ON:
                if (TimerCount10mS== 0){
                    keystate = KEY_WAIT_OFF;
                    TimerCount10mS= 100;// 1000mS Wait
                }
                break;
        
            case  KEY_AUTO_PRESS:
                anykeyon(key);/* call function */
                keystate = KEY_AFTER_AUTO_PRESS;
                TimerCount10mS = 20;// 200mS Wait
                break;
        
            case  KEY_AFTER_AUTO_PRESS:
                if(key = ANYKEYON){
                    if (TimerCount10mS== 0){
                        if(++KeyAutoLoopCount > 40){
                            KeyAutoLoopCount = 0;
                            KeyValDiv *= 10;
                            if(KeyValDiv >500) KeyValDiv = 500;
                        }
                        keystate = KEY_AUTO_PRESS;
                    }
                }else{
                    KeyValDiv = 1;
                    keystate = KEY_AFTER_OFF;
                    TimerCount10mS= 4;// 40mS wait for key stable
            
                }   
                break;
        
            case  KEY_WAIT_OFF:
                if (TimerCount10mS== 0){
                    KeyValDiv <<= 2;
                    if(KeyValDiv >500) KeyValDiv = 500;
                    keystate = KEY_AUTO_PRESS;
                }else if(ANYKEYON == 0){
                    KeyValDiv = 1;
                    keystate = KEY_AFTER_OFF;
                    TimerCount10mS= 7;// 70mS wait for key stable
                }
                break;
    
            case  KEY_AFTER_OFF:
                if (TimerCount10mS== 0){
                    keystate = KEY_WAIT_ON;
                }
                break;
        }
    }
}    











