#include "synthesizer.h"

extern Serial pc;
//extern RawSerial pc;
extern U32 PresetVoiceAmount;
extern U32 SGenAmount;

uint8_t com[16];
uint8_t *com_ptr;

volatile U8 *param_rdptr;
volatile U8 *param_wrptr;
volatile U8 param_receivebuf[PARAM_BUFSIZE];

void init_param(void){
    param_wrptr = param_rdptr = &param_receivebuf[0];
    com_ptr = &com[0];

}

int strxcmp(uint8_t *str1 ,uint8_t *str2){
    uint8_t *c1;
    uint8_t *c2;
    c1 = str1;
    c2 = str2;
    if ((*c1 == 0x0d)||(*c1 == 0x0a)) return 0; 
    while(*c1 != 0x0d){
        if (*c1++ != *c2++) return 0;   
    }
    return -1;
}

void name2pc(void){
    uint8_t c;
    uint8_t *ptr = (uint8_t *)&PresetVoice[0];
    U32 len = PresetVoiceAmount;
    while (len--){
            c = *ptr++ & 0xff;    
            pc.putc(c);    
    }

}

void sgen2pc(void){
    uint8_t c;
    uint8_t *ptr = (uint8_t *)&sgen[0];
    U32 len = SGenAmount;
    while (len--){
            c = *ptr++ & 0xff;    
            pc.putc(c);    
    }

}

void name2gen(void){
    uint8_t *ptr = (uint8_t *)&PresetVoice[0];
    U32 len = PresetVoiceAmount;
    while (len){
        if(param_rdptr != param_wrptr){
        *ptr++ = *param_rdptr;
        if (++param_rdptr >&param_receivebuf[255]) param_rdptr = &param_receivebuf[0];//
        len--;
        }
     }
}

void sgen2gen(void){
    uint8_t *ptr = (uint8_t *)&sgen[0];
    U32 len = SGenAmount;
    while (len){
        if(param_rdptr != param_wrptr){
        *ptr++ = *param_rdptr;
        if (++param_rdptr >&param_receivebuf[255]) param_rdptr = &param_receivebuf[0];//
        len--;
        }
     }
}

void param_work(void){
    uint8_t c;
    while(param_rdptr != param_wrptr){
    /* レシーブバッファが空なら、リターン */
        c = *param_rdptr;
        if (++param_rdptr >&param_receivebuf[255]) param_rdptr = &param_receivebuf[0];//
        if (c == 0x0a){
            /* compare command */
            com_ptr = &com[0];
            if(strxcmp(&com[0],(uint8_t *)"name2PC")){name2pc();}
            else if(strxcmp(&com[0],(uint8_t *)"gen2PC")){sgen2pc();}
            else if(strxcmp(&com[0],(uint8_t *)"name2GEN")){name2gen();}
            else if(strxcmp(&com[0],(uint8_t *)"gen2GEN")){
                sgen2gen();
                save2from();
                lcd_print2("Saved Parameter ");    
            }
        }else{
            *com_ptr++ = c;
        }
    }
}


