#include "synthesizer.h"

U8 PresetVoiceNum;
U8 MidiChannel;
S8 MasterTune;
int rch_pol;

extern S16 limit;

extern S16 MasterVolume;
U8 midi_base_ch;
extern volatile int KeyValDiv;

char lcd_string[20];
U8 selectsw = 0;
extern int menu_index;
char str[5];
char wave_type[5][5]={"Sine","Saw1","Saw2","Tri ","Squr"};

extern volatile U8 key;
extern KeyState_TypeDef keystate;

extern GENERATOR sgen[];
extern GENERATOR dgen[];
extern GENERATOR_TEMP dgen_temp[];
extern GENERATOR *gen ;// = &sgen[(PresetVoiceNum - 1)*PRGGENMAX] set by Menu PresetVoice
extern GENERATOR *pgen;// = &dgen[0]; 
extern GENERATOR_TEMP *pgen_temp;//  = &dgen_temp[0]; 

extern PresetVoiceDef PresetVoice[];
extern WaveDef Wave[];

MenuListDef MenuList[] ={
    {"Parameter"        ,param              ,0      ,0}, // index 0
    {"RchOut Polarity"  ,rch_polarity       ,-1      ,1},
    {"Voice "           ,presetvoice        ,1      ,64},
    {"Midi Channel"     ,midichannel        ,1      ,16}, 
    {"MasterTune "      ,mastertune         ,-128   ,127}, 
//    {"DCFF  Q FE  QE"   ,dcfcontrol         ,0      ,0}, 
    {"Generator Switch" ,gen_sw             ,0      ,0}, 
    {"Gen WaveNumber"   ,gen_wave           ,1      ,100},
    {"Gen NoteShift"    ,gen_notebias       ,-128   ,127}, 
    {"Gen OutputLevel"  ,gen_outlevel       ,0      ,127}, 
    {"Gen Detune"       ,gen_detune         ,-512   ,511}, 
    {"Gen AttackTime"   ,gen_attacktime     ,1      ,9999}, 
    {"Gen DecayTime"    ,gen_decaytime      ,1      ,9999}, 
    {"Gen SustainLevel" ,gen_sustainlevel   ,0      ,100}, 
    {"Gen ReleaseTime"  ,gen_relesetime     ,0      ,21}, // 13

    {"Gen LFO1 WavForm" ,gen_lfo1_wavetype  ,0      ,4}, // 14 Sine Saw1 Saw2 Tri Rect
    {"Gen LFO1 Speed"   ,gen_lfo1_speed     ,0      ,127}, 
    {"Gen LFO1 Depth"   ,gen_lfo1_depth     ,0      ,999}, 
    {"Gen LFO1 Delay"   ,gen_lfo1_delaytime ,0      ,3000}, 

    {"Gen LFO2 Speed"   ,gen_lfo2_speed     ,0      ,127}, 
    {"Gen LFO2 Depth"   ,gen_lfo2_depth     ,0      ,127}, // 19
    {"Gen LFO2 Delay"   ,gen_lfo2_delaytime ,0      ,3000}, // 20
    {"Gen Limit"        ,gen_limit           ,0      ,127} // 21
};

void lcd_print(char *str){
    lcd.printf(str);    
}
    
void lcd_print1(char *str){
    lcd.cls();
    lcd.printf(str);    
}    

void lcd_print2(char *str){
    lcd.locate(0,1);
    lcd.printf(str);    
}    

/* Title "μGen4" */
void lcd_print_title(void){
    lcd.setCGRAM(1<<3,&cgfont[0]);
    lcd_string[0] = 1;// 'μ'
    lcd_string[1] = 0;// NULL
    strcat ((char *)lcd_string,"Gen4 ");

//    strcpy ((char *)lcd_string,"uGen4 ");
    strcat ((char *)lcd_string,FWVERSION);
    lcd_print1((char *)lcd_string);
    strcpy((char *)lcd_string," Synthesizer");
    lcd_print2((char *)lcd_string);

}

void gen_limit(void){
    int value = limit;
    if(key & 0x10){
        value -= KeyValDiv;
        if(value < MenuList[menu_index].min) value = MenuList[menu_index].min;
    }else if(key & 0x20){
        value += KeyValDiv;
        if(value > MenuList[menu_index].max) value = MenuList[menu_index].max;
    
    }    
    limit = value;
    val2str4(limit);
    lcd_print(&str[0]);
}

void presetvoice(void){
    int value = PresetVoiceNum;
    if(key & 0x10){
        value -= KeyValDiv;
        if(value < MenuList[menu_index].min) value = MenuList[menu_index].min;
    }else if(key & 0x20){
        value += KeyValDiv;
        if(value > MenuList[menu_index].max) value = MenuList[menu_index].max;
    
    }    
    lcd_print1("Voice ");
    PresetVoiceNum = value;
    gen = (GENERATOR *)&sgen[(PresetVoiceNum - 1)*PRGGENMAX];
    val2str4(PresetVoiceNum);
    lcd_print(&str[0]);
    lcd_print2(PresetVoice[PresetVoiceNum-1].name);
} 

void param(void){
    lcd_print2("SaveLoad PC");
    if(SELECTSW1){
        save2from();
        lcd_print2("Saved Parameter ");    
    }else if(SELECTSW2){
        load2from();
        lcd_print2("Loaded Parameter");    
    }else if(SELECTSW3){
        lcd_print2("DumppingToSerial");
        dump2serial();        
        lcd_print2("Complete        ");          
    }
}

void mastertune(void){
    int value = MasterTune;
    if(key & 0x10){
        value -= KeyValDiv;
        if(value < MenuList[menu_index].min) value = MenuList[menu_index].min;
    }else if(key & 0x20){
        value += KeyValDiv;
        if(value > MenuList[menu_index].max) value = MenuList[menu_index].max;
    
    }    
    MasterTune = value;
    val2str4(MasterTune);
    lcd_print(&str[0]);
}

void rch_polarity(void){
    int value = rch_pol;
    if(key & 0x10){
        value = -1;
    }else if(key & 0x20){
        value = 1;
    }    
    rch_pol = value;

    if (rch_pol > 0){
           strcpy(lcd_string,"Same as LchOut");
    }else{
           strcpy(lcd_string,"Invert");
    }
    lcd_print1("RchOut Polarity");
    lcd_print2(lcd_string);
}

void dcfcontrol(void){
    /* DCFF  Q FE  QE */
    int value = PresetVoice[PresetVoiceNum - 1].dcf_freq;
    if (selectsw & 1){
        if(key & 0x20){
            value += KeyValDiv;
            if(value > 30) value = 30;
        }else if(key & 0x10){
            value -= KeyValDiv;
            if(value < 0) value = 0;
        }
        PresetVoice[PresetVoiceNum - 1].dcf_freq = value;
    }
    val2str4(value);
    strcat(lcd_string, &str[0]);

    value = PresetVoice[PresetVoiceNum - 1].dcf_q;
    if (selectsw & 2){
        if(key & 0x20){
            value += KeyValDiv;
            if(value > 10) value = 10;
        }else if(key & 0x10){
        value -= KeyValDiv;
            if(value < 0) value = 0;
        }
       PresetVoice[PresetVoiceNum - 1].dcf_q = value;
           }
    val2str4(value);
    strcat(lcd_string, &str[0]);

    value = PresetVoice[PresetVoiceNum - 1].dcf_freqsence;
    if (selectsw & 4){
        if(key & 0x20){
            value += KeyValDiv;
            if(value > 10) value = 10;
        }else if(key & 0x10){
            value -= KeyValDiv;
            if(value < 0) value = 0;
        }
        PresetVoice[PresetVoiceNum - 1].dcf_freqsence = value;
   }
    val2str4(value);
    strcat(lcd_string, &str[0]);


    value = PresetVoice[PresetVoiceNum - 1].dcf_qsence;
    if (selectsw & 8){
        if(key & 0x20){
            value += KeyValDiv;
            if(value > 10) value = 10;
        }else if(key & 0x10){
            value -= KeyValDiv;
            if(value < 0) value = 0;
        }
        PresetVoice[PresetVoiceNum - 1].dcf_qsence = value;
    }
    val2str4(value);
    strcat(lcd_string, &str[0]);
    
    lcd_print2(lcd_string);
}

void gen_sw(void){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    U8 bitsw = 1;
    int n = PRGGENMAX;
    while(n--){
        if(key & bitsw){
            gena->sw ^= 1;
            gena->sw &= 1;
        }            
        if(gena->sw){
           strcat(lcd_string," On ");
        }else{
           strcat(lcd_string," Off");
        }                    
        bitsw <<= 1;
        gena++;
    }
    lcd_print2(lcd_string);
}    

void midichannel(void){
    int value = MidiChannel;
    if(key & 0x10){
        value -= KeyValDiv;
        if(value < MenuList[menu_index].min) value = MenuList[menu_index].min;
    }else if(key & 0x20){
        value += KeyValDiv;
        if(value > MenuList[menu_index].max) value = MenuList[menu_index].max;
    
    }    
    MidiChannel = value;
    midi_base_ch = value -1;
    val2str4(MidiChannel);
    lcd_print(&str[0]);
 }

void gen_outlevel(void){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    int n = PRGGENMAX;
    U8 bitsw = 1;
    while(n--){
        int value = (gena->volume>>8);
        if (gena->sw){
            if(selectsw & bitsw){
                if(key & 0x20){
                    value += KeyValDiv;
                    if(value > MenuList[menu_index].max) value = MenuList[menu_index].max;
                }else if(key & 0x10){
                    value -= KeyValDiv;
                    if(value < MenuList[menu_index].min) value = MenuList[menu_index].min;
                }
                gena->volume = (value<<8);
            }
            val2str4((gena->volume)>>8);
            strcat(lcd_string, &str[0]);
        }else{
            strcat(lcd_string," Off");            
        }        
        bitsw <<= 1;
        gena++;
    }
    
    lcd_print2(lcd_string);
}

void gen_lfo1_wavetype(void){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    int n = PRGGENMAX;
    U8 bitsw = 1;
    while(n--){
        int value = gena->lfo1type;
        if (gena->sw){
            if(selectsw & bitsw){
                if(key & 0x10){
                    value -= KeyValDiv;
                    if(value < MenuList[menu_index].min) value = MenuList[menu_index].min;
                }else if(key & 0x20){
                    value += KeyValDiv;
                    if(value > MenuList[menu_index].max) value = MenuList[menu_index].max;
                }
            }    
            gena->lfo1type = value;
            strcat(lcd_string, &wave_type[value][0]);
        }else{
            strcat(lcd_string," Off");
        }
        gena++;
        bitsw <<= 1;
    }
    lcd_print2(lcd_string);
}

  
U8 gen_function_type_byte(GENERATOR *gena_value){
    int value ,value1;
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    U32 temp = (U32)gena_value - (U32)gena;
    int n = PRGGENMAX;
    U8 bitsw = 1;
    while(n--){
        value = *(U8 *)( (U32)gena + temp );
        if(gena->sw){
            if (selectsw & bitsw){
                if(key & 0x20){
                    value += KeyValDiv;
                    if(value > MenuList[menu_index].max) value = MenuList[menu_index].max;
                }else if(key & 0x10){
                    value -= KeyValDiv;
                    if(value < MenuList[menu_index].min) value = MenuList[menu_index].min;
                }
                 *(U8 *)( (U32)gena + temp )= value;
                value1 = value;    
            }
            val2str4(value);
            strcat(lcd_string, &str[0]);
        }else{
            strcat(lcd_string," Off");
        }
        gena++;
        gena_value++;
        bitsw <<= 1;
    }

    lcd_print2(lcd_string);
    return (U8)value1;
}   

void gen_function_type_word(GENERATOR *gena_value){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    U32 temp = (U32)gena_value - (U32)gena;
    int n = PRGGENMAX;
    U8 bitsw = 1;
    while(n--){
        int value = *(U16 *)( (U32)gena + temp );
        if(gena->sw){
            if (selectsw & bitsw){
                if(key & 0x20){
                    value += KeyValDiv;
                    if(value > MenuList[menu_index].max) value = MenuList[menu_index].max;
                }else if(key & 0x10){
                    value -= KeyValDiv;
                    if(value < MenuList[menu_index].min) value = MenuList[menu_index].min;
                }
                 *(U16 *)( (U32)gena + temp )= value;
            }
            val2str4(value);
            strcat(lcd_string, &str[0]);
        }else{
            strcat(lcd_string," Off");
        }
        gena++;
        gena_value++;
        bitsw <<= 1;
    }

    lcd_print2(lcd_string);
}   

void gen_function_type_sbyte(GENERATOR *gena_value){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    U32 temp = (U32)gena_value - (U32)gena;
    int n = PRGGENMAX;
    U8 bitsw = 1;
    while(n--){
        int value = *(S8 *)( (U32)gena + temp );
        if(gena->sw){
            if (selectsw & bitsw){
                if(key & 0x20){
                    value += KeyValDiv;
                    if(value > MenuList[menu_index].max) value = MenuList[menu_index].max;
                }else if(key & 0x10){
                    value -= KeyValDiv;
                    if(value < MenuList[menu_index].min) value = MenuList[menu_index].min;
                }
                 *(S8 *)( (U32)gena + temp )= value;
     
            }
            val2str4(value);
            strcat(lcd_string, &str[0]);
        }else{
            strcat(lcd_string," Off");
        }
        gena++;
        gena_value++;
        bitsw <<= 1;
    }

    lcd_print2(lcd_string);

}  
void gen_function_type_sword(GENERATOR *gena_value){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    U32 temp = (U32)gena_value - (U32)gena;
    int n = PRGGENMAX;
    U8 bitsw = 1;
    while(n--){
        int value = *(S16 *)( (U32)gena + temp );
        if(gena->sw){
            if (selectsw & bitsw){
                if(key & 0x20){
                    value += KeyValDiv;
                    if(value > MenuList[menu_index].max) value = MenuList[menu_index].max;
                }else if(key & 0x10){
                    value -= KeyValDiv;
                    if(value < MenuList[menu_index].min) value = MenuList[menu_index].min;
                }
                 *(S16 *)( (U32)gena + temp )= value;
     
            }
            val2str4(value);
            strcat(lcd_string, &str[0]);
        }else{
            strcat(lcd_string," Off");
        }
        gena++;
        gena_value++;
        bitsw <<= 1;
    }

    lcd_print2(lcd_string);

}   


void gen_attacktime(void){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    GENERATOR *gena_value = (GENERATOR *)&gena->attacktime;
    gen_function_type_word(gena_value);
}

void gen_wave (void){
//    pc.printf("PresetVoiceNum = %d\r\n",PresetVoiceNum);
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    GENERATOR *gena_value = (GENERATOR *)&gena->wave_num;
    U8 value = gen_function_type_byte(gena_value);
    if(key & 0x30){// when push Value+- key
        lcd_print2("                ");
        lcd_print2(Wave[value - 1].name);
//      keystate = KEY_GEN_WAVE1;
//      TimerCount10mS= 100;// 1000mS Wait
    }
}

void gen_notebias(void){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    GENERATOR *gena_value = (GENERATOR *)&gena->notebias;
    gen_function_type_sbyte(gena_value);
}

void gen_detune(void){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    GENERATOR *gena_value = (GENERATOR *)&gena->detune;
    gen_function_type_sword(gena_value);
}
 
void gen_decaytime(void){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    GENERATOR *gena_value = (GENERATOR *)&gena->decaytime;
    gen_function_type_word(gena_value);
}
void gen_sustainlevel(void){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    GENERATOR *gena_value = (GENERATOR *)&gena->sustainlevel;
    gen_function_type_byte(gena_value);
}
void gen_relesetime(void){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    GENERATOR *gena_value = (GENERATOR *)&gena->releasetime;
    gen_function_type_word(gena_value);
}
  
void gen_lfo1_speed (void){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    GENERATOR *gena_value = (GENERATOR *)&gena->lfo1speed;
    gen_function_type_byte(gena_value);
}


void gen_lfo1_depth(void){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    GENERATOR *gena_value = (GENERATOR *)&gena->lfo1depth;
    gen_function_type_word(gena_value);
}

void gen_lfo1_delaytime(void){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    GENERATOR *gena_value = (GENERATOR *)&gena->lfo1delaytime;
    gen_function_type_word(gena_value);
}

void gen_lfo2_delaytime(void){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    GENERATOR *gena_value = (GENERATOR *)&gena->lfo2delaytime;
    gen_function_type_word(gena_value);
}

void gen_lfo2_speed (void){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    GENERATOR *gena_value = (GENERATOR *)&gena->lfo2speed;
    gen_function_type_byte(gena_value);
}

void gen_lfo2_depth(void){
    GENERATOR *gena = &sgen[(PresetVoiceNum-1) * PRGGENMAX];
    GENERATOR *gena_value = (GENERATOR *)&gena->lfo2depth;
    gen_function_type_word(gena_value);
}

char *val2str4(int value){
    uint8_t n;
    char *c;
    int value_temp = value;
    if (value < 0){
        str[0] = '-';
        value_temp *= -1;

        n = 0;
        while(value_temp >= 100){
            value_temp -= 100;
            n++;
        }
        str[1] = 0x30 + n;
        n = 0;
        while(value_temp >= 10){
            value_temp -= 10;
            n++;
        }
        str[2] = 0x30 + n;
        str[3] = 0x30 + value_temp;
/*
        if (value_temp >99){
            str[1] = '1';
            value_temp -= 100;
        }else{
            str[1] = '0';
        }
        n = 0;
        while(value_temp >= 10){
            value_temp -= 10;
            n++;
        }
        str[2] = 0x30 + n;
        str[3] = 0x30 + value_temp;
*/
    }else{
        n = 0;
        while(value_temp >= 1000){
            value_temp -= 1000;
            n++;
        }
        str[0] = 0x30 + n;
        n = 0;
        while(value_temp >= 100){
            value_temp -= 100;
            n++;
        }
        str[1] = 0x30 + n;
        n = 0;
        while(value_temp >= 10){
            value_temp -= 10;
            n++;
        }
        str[2] = 0x30 + n;
        str[3] = 0x30 + value_temp;
    }

    n = 3;
    c = &str[0];
    while(n-- >0){
        if ((*c != '0')&&(*c != '-')) break;
        if (*c != '-') *c = ' ';
        c++;
    }
    if (str[0] == '-'){
        if (str[2] == ' '){// -  n  -> -n
            str[0] = str[1] = ' ';
            str[2] = '-';
        }else if (str[1] == ' '){// - mn -> -mn
            str[0] = ' ';
            str[1] = '-';
        }
    }
    str[4] = 0;
    return &str[4];
}


