#ifndef SYNTHESIZER_H
#define SYNTHESIZER_H

typedef signed long S32;
typedef signed short S16;
typedef signed char S8;
typedef unsigned long U32;
typedef unsigned short U16;
typedef unsigned char U8;

#include "mbed.h"
#include "cmsis.h"
#include "stm32f401xe.h"
#include "stm32f4xx.h"
#include "stm32f4xx_hal.h"
#include "stm32f4xx_hal_dma_ex.h"
#include "stm32f4xx_hal_dma.h"
#include "stm32f4xx_hal_i2s.h"
#include "stm32f4xx_hal_flash.h"
#include "stm32f4xx_hal_conf.h"
#include "stm32f4xx_it.h"

#include "error.h"
#include "pinmap.h"
#include "PinNames.h"
#include "gpio_irq_api.h"

#include "LCD.h"

#include "reverve_tap.h"
#include "from_save.h"
#include "lcd_sw.h"
#include "releasetime_table.h"

#include "lfo_table.h"
#include "dcf_table.h"

#define FWVERSION "  Ver 2.1"

#define DIST
//#define REVERVE16BIT
//#define DCF
#define INTERPO2
    
#define VOICEMAX 8
#define PRGGENMAX 4
//#define VOICEMAX 12
//#define PRGGENMAX 2
//#define GENMAX (PRGGENMAX*VOICEMAX)
#define GENMAX 24

#define I2S2    SPI2
#define DMA_BUFFERSIZE   2048

#define PARAM_BUFSIZE    256

#define GEN_IDLE 0
#define GEN_NOTEON 1
#define GEN_NOTEOFF 2
#define GEN_PORON 3
#define GEN_POROFF 4

/* for main Request*/
//#define REQUEST_NONE 0
//#define REQUEST_BUFFERFULL 1
//#define REQUEST_PARAM 2
//#define REQUEST_MIDI 4

/* EG Function */
#define EG_IDLE     0
#define EG_ATTACK   1
#define EG_DECAY    2
#define EG_SUSTAIN  3
#define EG_RELEASE  4
#define EG_BEFOREATTACK 5

extern S16 limit;

typedef struct {
    U8 sw;// 0,1
    U8 wave_num;// 1 - 100
    S8 notebias;// -128 - +127
    U8 pan;// 0-31
    S16 detune;// -512 - +511
    U16 volume;// 0-65535

    U16 attacktime;//
    U16 decaytime;//
    U8 sustainlevel;//
    U16 releasetime;// 0-21

    U8 lfo1type;
    U8 lfo1speed;
    U16 lfo1depth;
    U16 lfo1delaytime;// 0-3000

    U8 lfo2type;
    U8 lfo2speed;
    U16 lfo2depth;
    U16 lfo2delaytime;// 0-3000
}GENERATOR ;

typedef struct { 
    U8 status;// BUFFULL,PARAM,MIDI
    U8 eg_status;// IDLE,ATTCK,DECAY,SUSTAIN,RELEASE
    U8 *startadr;
    U8 *p1;
    U8 *p2;
    U8 *samplecountp1p2;
    U8 *cycle;
    U32 df;// 4e28f
    S32 dpf;// 4e28f portament data 110812
    U8 notenum;// 0-127
    volatile U32 voltemp;// 32bit
    volatile U32 voltemp1;// 32bit
    volatile U32 voltemp2;// 32bit
    volatile U32 voltempL;// 32bit
    volatile U32 voltempR;// 32bit
    U8 velocity;// 0-127
    U32 x;// 指数部２０ビット　小数部１２ビット
    U32 xx;// 指数部２０ビット　小数部１２ビット
    S16 lfo1value;
    U16 lfo1count;
    U16 lfo1delaycount;// 3000-0
    S16 lfo2value;
    U16 lfo2count;
    U16 lfo2delaycount;// 3000-0
    U16 zerocount;
}GENERATOR_TEMP ;  

typedef struct {
    U8  name[16];
    U32 p1;
    U32 p2;
    U32 cycle;
}GEN4_CHUNK;

typedef struct {
    char    menu[20];
    void (*function)(void);
    int     min;
    int     max;
}MenuListDef;


typedef struct  {
    int enable;
    S32 signal[6];// sample,x1,x2,y1,y2,result
    S32 *dcf_param;// pointer of dcf_table(b0a0 ,b1a0,... a2,a0)
    GENERATOR *gen;// gen1_adr,gen2_adr...gen4_adr
    GENERATOR_TEMP *gen_temp;// gen1_adr,gen2_adr...gen4_adr
}STR_VOICE;


typedef struct{
    char    name[20];
    uint32_t startaddr;// Wave data Start Address
    uint32_t p1;// Loop Point1
    uint32_t p2;// Loop Point2
    uint32_t cycle;// Loop Cycle :if (cycle == 0) cycle = P2-p1 ; 
}WaveDef;
 
typedef struct{
    char    name[20];
    uint8_t dcf_freq;
    uint8_t dcf_q;
    uint8_t dcf_freqsence;
    uint8_t dcf_qsence;
}PresetVoiceDef;
  
typedef enum
{
  DMA_Idle = 0,  
  DMA_HalfComplete,  
  DMA_FullComplete,     
}BUFFER_StateTypeDef;

typedef enum
{
    KEY_WAIT_ON = 0,  
    KEY_AFTER_ON,  
    KEY_WAIT_OFF,
    KEY_AFTER_OFF,
    KEY_AUTO_PRESS,
    KEY_AFTER_AUTO_PRESS,
    KEY_GEN_WAVE1,
    KEY_GEN_WAVE2,
    KEY_FIRST_WAIT
}KeyState_TypeDef;

void MX_GPIO_Init(void);
void uGen4_device_init(void);
void init_dmabuffer(void);
void i2s_dma_init(void);
void uGen4_init(void);

void lcd_print_title(void);
void gen_function(int *);

S32 satAdd32(S32 val1 ,S32 val2);
S16 satAdd16(S16 val1 ,S16 val2);
S16 dcf64(S32 *param ,S32 *signal);
char *val2str4(int value);
void presetvoice(void);
void param(void);
void midichannel(void);
void mastertune(void);
void dcfcontrol(void);
void gen_sw (void);
void gen_wave (void);
void gen_notebias(void);
void gen_outlevel(void);
void gen_detune(void);
void gen_attacktime(void);
void gen_decaytime(void);
void gen_sustainlevel(void);
void gen_relesetime(void);
void gen_lfo1_wavetype(void);
void gen_lfo1_speed (void);
void gen_lfo1_depth(void);
void gen_lfo2_speed (void);
void gen_lfo2_depth(void);
void gen_lfo1_delaytime(void);
void gen_lfo2_delaytime(void);
void gen_limit(void);

void Erase_Sector2(void);

HAL_StatusTypeDef WriteBlockFrom(uint32_t *src_address ,uint32_t *dst_address,uint32_t length);

int strcmp(U8 *a ,U8 *b);

void init_voice(void);
void init_sgen(void);
void noteon(U8 notenum ,U8 velocity);
void noteoff(U8 notenum ,U8 velocity);
void pgmchg(U8 number);
void change_endian16(U16 *data);
void wave_generate(void);

void gen_attack(GENERATOR *gena,GENERATOR_TEMP *gena_temp);
void notenum2df(GENERATOR *gen ,GENERATOR_TEMP *gen_temp);
void envelope_work(void);
void midi_work(void);
void param_work(void);
void init_midi(void);
void init_param(void);

int get_wave_addr (WaveDef *wave);
void load2from(void);

void lcd_print(char *str);
void lcd_print1(char *str);
void lcd_print2(char *str);

void anykeyon(U8 inkey);

U8 gen_function_type_byte(GENERATOR *gena_value);

void test_loop(void);
void test_loop2(void);

extern WaveDef Wave[];
extern PresetVoiceDef PresetVoice[];
extern GENERATOR sgen[];


#endif 









