#include "synthesizer.h"
 
/*
Sector 0 0x0800 0000 - 0x0800 3FFF 16 Kbytes
Sector 1 0x0800 4000 - 0x0800 7FFF 16 Kbytes
Sector 2 0x0800 8000 - 0x0800 BFFF 16 Kbytes
Sector 3 0x0800 C000 - 0x0800 FFFF 16 Kbytes
Sector 4 0x0801 0000 - 0x0801 FFFF 64 Kbytes
Sector 5 0x0802 0000 - 0x0803 FFFF 128 Kbytes
Sector 6 0x0804 0000 - 0x0805 FFFF 128 Kbytes
Sector 7 0x0806 0000 - 0x0807 FFFF 128 Kbytes
*/
extern Serial pc;
//extern RawSerial pc;

extern U32 PresetVoiceAmount;
extern U32 SGenAmount;

extern U8 PresetVoiceNum;
extern U8 MidiChannel;
extern U16 MasterVolume;
extern S8 MasterTune;
extern U8 midi_base_ch;
extern int rch_pol;

extern WaveDef Wave[];
extern PresetVoiceDef PresetVoice[];
extern GENERATOR sgen[];

void FROM_WriteBlock(uint32_t MemAddress , uint32_t FromAddress ,uint32_t datalength){
    uint32_t *SrcAddress = (uint32_t *)MemAddress;
    uint32_t *DstAddress = (uint32_t *)FromAddress;
    HAL_FLASH_Unlock();
    HAL_FLASH_OB_Unlock();
        datalength >>= 2;
        while(datalength--){
            HAL_StatusTypeDef status = HAL_FLASH_Program(TYPEPROGRAM_WORD, (uint32_t)DstAddress++, *SrcAddress++);
            if (status != HAL_OK){
                pc.printf("FLASH->CR = 0x%4x \n\r",FLASH->CR);
                pc.printf("FLASH->SR = 0x%4x \n\r",FLASH->SR);// PGPERR: Programming parallelism error
                pc.printf("FLASH->OPTCR = 0x%4x \n\r",FLASH->OPTCR);
                return ;
        }
    }    
    HAL_FLASH_Lock();
}
    

void save2from(void){
    U32 temp;
    HAL_StatusTypeDef status;
    
    HAL_FLASH_Unlock();// for Erase
    HAL_FLASH_OB_Unlock();// for Erase
    FLASH_Erase_Sector(FLASH_SECTOR_3, VOLTAGE_RANGE_3);//  FLASH_SECTOR_0-7
    FROM_WriteBlock((uint32_t) &Wave[0] , (uint32_t)Flash_Wave_Address ,(uint32_t)Flash_Wave_Len);
    FROM_WriteBlock((uint32_t) &PresetVoice[0] , (uint32_t)Flash_PresetVoice_Address ,(uint32_t)Flash_PresetVoice_Len);
    FROM_WriteBlock((uint32_t) &sgen[0] , (uint32_t)Flash_Generator_Address ,(uint32_t)Flash_Generator_Len);

    temp = (PresetVoiceNum<<24) |(MasterTune<<16) |(MasterVolume & 0x7f00) | (MidiChannel & 0x0f);
    HAL_FLASH_Unlock();
    HAL_FLASH_OB_Unlock();
    status = HAL_FLASH_Program(TYPEPROGRAM_WORD, (uint32_t)Flash_System_Address , temp);
    if (status != HAL_OK){
        pc.printf("System Write FLASH->SR = 0x%4x \n\r",FLASH->SR);// PGPERR: Programming parallelism error
   }
    temp = rch_pol;// & 0xffff;
    status = HAL_FLASH_Program(TYPEPROGRAM_WORD, (uint32_t)((uint32_t *)Flash_System_Address + 1) , temp);
    if (status != HAL_OK){
        pc.printf("System Write2 FLASH->SR = 0x%4x \n\r",FLASH->SR);// PGPERR: Programming parallelism error
   }

    HAL_FLASH_Lock();

}

void FROM_ReadBlock(uint32_t *MemAddress , uint32_t *FromAddress ,int datalength){
    memcpy (MemAddress ,FromAddress ,datalength);
}     

void load2from(void){
//    FROM_ReadBlock((uint32_t *) &Wave[0] , (uint32_t *)Flash_Wave_Address ,(U32)&Wave[99]-(U32)&Wave[0]+sizeof(WaveDef));
/*
    FROM_ReadBlock((uint32_t *) &PresetVoice[0] , (uint32_t *)Flash_PresetVoice_Address ,(U32)&PresetVoice[63]-(U32)&PresetVoice[0]+sizeof(PresetVoiceDef));
    FROM_ReadBlock((uint32_t *) &sgen[0] , (uint32_t *)Flash_Generator_Address ,(U32)&sgen[PRGGENMAX * 64-1]-(U32)&sgen[0]+sizeof(GENERATOR));
*/
    FROM_ReadBlock((uint32_t *) &PresetVoice[0] , (uint32_t *)Flash_PresetVoice_Address, PresetVoiceAmount);
    FROM_ReadBlock((uint32_t *) &sgen[0] , (uint32_t *)Flash_Generator_Address , SGenAmount);

    U32 temp = *Flash_System_Address;
    PresetVoiceNum = (U8)((temp>>24) & 0x7f);
    MasterTune = (S8)((temp>>16)& 0xff);
    MasterVolume = (U16)(temp & 0x7f00);
    MidiChannel = (U8)(temp & 0x0f);
    midi_base_ch = MidiChannel - 1; 

    temp = *(Flash_System_Address + 1);
    rch_pol = (int)temp;
}


int get_wave_addr (WaveDef *wave){
    WaveDef *wavea = wave;
    uint8_t *ptr = (uint8_t *)Flash_WaveData_Address;
    uint8_t *next_ptr;
    GEN4_CHUNK *Gen4Chunk;
    int n;
    int num = 0;
    
    while(1){
        /* RIFF ? */
        if(! ((*ptr == 'R') && (*(ptr+1) =='I') && (*(ptr+2) =='F') && (*(ptr+3) =='F')) ) return -1;
        ptr += 4;
        /* get next waveaddress */
        next_ptr = (uint8_t *)((*(ptr+3)<<24)|(*(ptr+2)<<16)|(*(ptr+1)<<8)|(*ptr));
        ptr += 4;
        next_ptr += (uint32_t )ptr;

        /* WAVE ? */
        if(! ((*ptr == 'W') && (*(ptr+1) =='A') && (*(ptr+2) =='V') && (*(ptr+3) =='E')) ) return -2;

        /* Search gen4 */
        ptr += 4;
        n = 64;
        while (n-- > 0){
            if ((*ptr == 'g') && (*(ptr+1) =='e') && (*(ptr+2) =='n') && (*(ptr+3) =='4')) break;
            ptr++;
        }
        if (n == 0)return -4;

//        printf("0x%x 0x%x\r\n",ptr,*ptr);

        ptr += 4;// volume
        ptr += 4;// name
        memcpy(&wave[num].name[0] ,ptr ,16);
 
        Gen4Chunk = (GEN4_CHUNK *)ptr;
        wave[num].name[16] = 0;
        num++;
        wavea->p1 = Gen4Chunk->p1;
        wavea->p2 = Gen4Chunk->p2;
        wavea->cycle = Gen4Chunk->cycle;
//        printf("p1 = %d\r\n",Gen4Chunk->p1);
        
         /* Search data */
        ptr += 16+4+4+4;
        n = 200;
        while (n-- > 0){
            if ((*ptr == 'd') && (*(ptr+1) =='a') && (*(ptr+2) =='t') && (*(ptr+3) =='a')) break;
            ptr++;
        }
        if (n == 0)return -3;

        /* get startaddr */
        ptr += 8;
        wavea->startaddr = (U32)ptr;
//        pc.printf("wavea->startaddr = 0x%4x \r\n",wavea->startaddr);
        wavea++;

        ptr = next_ptr;
        if ((*ptr == 0x00)||(*ptr == 0xff)) return 0;
    }
}

void dump2serial(void){
    uint32_t *ptr = Flash_Sector3_Address;
    uint8_t c;
//    uint32_t len = ALIGNMENT4_INC(sizeof(PresetVoiceDef));
    U32 len = 16384>>2;
    while (len--){
        for (int i =0;i<4;i++){
            c = (*ptr >>(i*8))& 0xff;    
            pc.putc(c);    
        }     
        ptr++;
    }
}
  



