/*
Sector 0 0x0800 0000 - 0x0800 3FFF 16 Kbytes
Sector 1 0x0800 4000 - 0x0800 7FFF 16 Kbytes
Sector 2 0x0800 8000 - 0x0800 BFFF 16 Kbytes
Sector 3 0x0800 C000 - 0x0800 FFFF 16 Kbytes
Sector 4 0x0801 0000 - 0x0801 FFFF 64 Kbytes
Sector 5 0x0802 0000 - 0x0803 FFFF 128 Kbytes
Sector 6 0x0804 0000 - 0x0805 FFFF 128 Kbytes
Sector 7 0x0806 0000 - 0x0807 FFFF 128 Kbytes
*/
#define Flash_Sector0_Address (uint32_t *)0x08000000
#define Flash_Sector1_Address (uint32_t *)0x08004000
#define Flash_Sector2_Address (uint32_t *)0x08008000
#define Flash_Sector3_Address (uint32_t *)0x0800C000
#define Flash_Sector4_Address (uint32_t *)0x08010000
#define Flash_Sector5_Address (uint32_t *)0x08020000
#define Flash_Sector6_Address (uint32_t *)0x08040000
#define Flash_Sector7_Address (uint32_t *)0x08060000

#define ALIGNMENT4_INC(_X_)   (((_X_)+3)&~3)

#define Flash_Wave_Address Flash_Sector3_Address
#define Flash_Wave_Len 3600
#define Flash_System_Address (uint32_t *)0x0800ce10

#define Flash_PresetVoice_Address (uint32_t *)0x0800d000
#define Flash_PresetVoice_Len 4096
#define Flash_Generator_Address (uint32_t *)0x0800e000
#define Flash_Generator_Len 8192 

#define Flash_WaveData_Address Flash_Sector4_Address


void FROM_WriteBlock(uint32_t MemAddress , uint32_t FromAddress ,uint32_t datalength);
void save2from(void);
void FROM_ReadBlock(uint32_t *MemAddress , uint32_t *FromAddress ,int datalength);
void load2from(void);
void dump2serial(void);

 

