/*
    COPYRIGHT(c) 2014 p.igmon
*/

#ifndef SYNTHESIZER_H
#define SYNTHESIZER_H

typedef signed long S32;
typedef signed short S16;
typedef signed char S8;
typedef unsigned long U32;
typedef unsigned short U16;
typedef unsigned char U8;

#include "mbed.h"
#include "cmsis.h"
#include "stm32f401xe.h"
#include "stm32f4xx.h"
#include "stm32f4xx_hal.h"
#include "stm32f4xx_hal_dma_ex.h"
#include "stm32f4xx_hal_dma.h"
#include "stm32f4xx_hal_i2s.h"

#include "stm32f4xx_hal_conf.h"
#include "stm32f4xx_it.h"

#include "error.h"
#include "pinmap.h"
#include "PinNames.h"
#include "gpio_irq_api.h"

#define I2S2    SPI2
#define DMA_BUFFERSIZE   2048


typedef enum
{
  DMA_Idle = 0,  
  DMA_HalfComplete,  
  DMA_FullComplete,     
}BUFFER_StateTypeDef;

void MX_GPIO_Init(void);
void uGen4_device_init(void);
void init_dmabuffer(void);
void i2s_dma_init(void);

void wave_generate(void);

void test_loop(void);
void test_loop2(void);

#endif 
