/*
    COPYRIGHT(c) 2014 p.igmon
*/

#include "synthesizer.h"

/* DMA WAVE BUFFER */
extern S16 DMA_Buffer[];
extern __IO BUFFER_StateTypeDef BufferOffset;

void wave_generate(void){
    u16 count;
    s16 rch,lch;// 16bit stereo
    volatile s16 *ptr0;

    if (bufferoffset == dma_fullcomplete){
        ptr0 = (s16 *)&dma_buffer[dma_buffersize>>1];// from half
    }else{
        ptr0 = (s16 *)&dma_buffer[0];// from top
    }    
    bufferoffset = dma_idle;

    count = dma_buffersize>>2;// 512samples
    while(count-- > 0){

        /* generate wave here */
        lch = ((s16)(count - 256))<<6;// Saw Wave Lch
        rch = ((s16)(256 -count))<<6;// Saw Wave Rch
        *ptr0++ = lch;
        *ptr0++ = rch;
     }
}
