#include "synthesizer.h"

extern Serial pc;
extern DigitalOut myled;

extern I2S_HandleTypeDef hi2s2;
extern DMA_HandleTypeDef hdma_i2s2_ext_tx;


S16 DMA_Buffer[DMA_BUFFERSIZE];
//S16 * DMA_Buffer = (S16 *)0x20008000;
__IO BUFFER_StateTypeDef BufferOffset = DMA_Idle;


static const PinMap PinMap_I2S_MCK[] = {
    {PC_6,  SPI_2, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI2)},
//    {PC_7,  SPI_3, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF6_SPI3)},
    {NC,    NC,    0}
};

static const PinMap PinMap_I2S_CK[] = {
    {PB_10,  SPI_2, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI2)},
    {PB_13,  SPI_2, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI2)},
//    {PD_3,  SPI_2, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI2)},
//    {PC_10,  SPI_3, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF6_SPI3)},
    {NC,    NC,    0}
};

static const PinMap PinMap_I2S_WS[] = {
    {PB_12,  SPI_2, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI2)},
    {PB_9,  SPI_2, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI2)},
//    {PA_15,  SPI_3, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF6_SPI3)},
    {NC,    NC,    0}
};

static const PinMap PinMap_I2S_SD[] = {
    {PC_3,  SPI_2, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI2)},
    {PB_15,  SPI_2, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI2)},
//    {PC_12,  SPI_3, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF6_SPI3)},
//    {PD_6,  SPI_3, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI3)},
    {NC,    NC,    0}
};



void HAL_I2S_TxCpltCallback(I2S_HandleTypeDef *hi2s)
{
  if(hi2s->Instance == I2S2)
  {
    BufferOffset = DMA_FullComplete;
    HAL_I2S_Transmit_DMA(&hi2s2, (uint16_t*)&DMA_Buffer[0], DMA_BUFFERSIZE); 
  }
}

void HAL_I2S_TxHalfCpltCallback(I2S_HandleTypeDef *hi2s)
{
    if(hi2s->Instance == I2S2) BufferOffset = DMA_HalfComplete;
}



void init_dmabuffer(void){
    int16_t *ptr0 = (int16_t*)&DMA_Buffer[0];
    for (int i =0;i < DMA_BUFFERSIZE/2 ;i++){
        *ptr0++ = 0;// Lch 
        *ptr0++ = 0;// Rch 
    }
}

   
void i2s_dma_init(void) {
    pinmap_pinout(PC_6, PinMap_I2S_MCK);
    pinmap_pinout(PB_13, PinMap_I2S_CK);
    pinmap_pinout(PB_12, PinMap_I2S_WS);
    pinmap_pinout(PB_15, PinMap_I2S_SD);

    pin_mode(PC_6, PullUp);
    pin_mode(PB_13, PullUp);
    pin_mode(PB_12, PullUp);
    pin_mode(PB_15, PullUp);

    init_dmabuffer();

    HAL_I2S_Transmit_DMA(&hi2s2, (uint16_t *)&DMA_Buffer[0],DMA_BUFFERSIZE / 2); 

/*   for debug */
/*
    pc.printf("DMA CR =%4x \n\r"  ,DMA1_Stream4->CR);
    pc.printf("DMA FCR =%4x \n\r"  ,DMA1_Stream4->FCR);

    pc.printf("DMA M0AR =%4x M1AR =%4x PAR = %4x \n\r"  ,DMA1_Stream4->M0AR  ,DMA1_Stream4->M1AR ,DMA1_Stream4->PAR);
    pc.printf("I2S CR2 = %4x \n\r" ,SPI2->CR2);
    pc.printf("I2S SR = %4x \n\r" ,SPI2->SR);
    pc.printf("I2S I2SCFGR = %4x \n\r" ,SPI2->I2SCFGR);
    pc.printf("I2S I2SPR = %4x \n\r" ,SPI2->I2SPR);
    pc.printf("RCC->PLLI2SCFGR = %4x \n\r" ,RCC->PLLI2SCFGR);
*/
 
//    HAL_RCC_MCOConfig(uint32_t RCC_MCO2, RCC_MCO2SOURCE_PLLI2SCLK, RCC_MCODIV_5);
}

