#ifndef MBED_LCD_H
#define MBED_LCD_H

#include "mbed.h"

class LCD : public Stream {
public:
    enum Icon {
        ANTENNA  = 0x0010,
        PHONE    = 0x0210,
        ALARM    = 0x0410,
        INPUT    = 0x0610,
        UP       = 0x0710,
        UPDOWN   = 0x0718,
        DOWN     = 0x0708,
        LOCK     = 0x0910,
        NO_SOUND = 0x0B10,
        BATTERY1 = 0x0D12,
        BATTERY2 = 0x0D1A,
        BATTERY3 = 0x0D1E,
        BATTERY0 = 0x0D02,
        MARK     = 0x0F10,
        ALL      = 0xFFFF
    };

    LCD(PinName sdaPin, PinName sclPin, PinName resetPin = NC, PinName backlightPin = NC,
        int contrast = 32, bool cursor = false, bool blink = false);
    void reset();
    void cls();
    void locate(int column, int row);
    void setCGRAM(uint8_t addr ,char data[]);
    void showIcon(Icon icon);
    void hideIcon(Icon icon);
    void setBacklight(bool on);

private:
    virtual int _putc(int value);
    virtual int _getc();

    void display(int column, int row, int c);
    void scrollDown();

    void writeCommand(int command);
    void writeData(int data);
    void writeData(char data[], int length);

    DigitalOut _reset;
    DigitalOut backlight;

    I2C i2c;

    char contrast;
    bool cursor;
    bool blink;
    bool resetEnabled;
    bool backlightEnabled;
    int column;
    int row;
    char row2[16];
};

#endif